;** os is an os struct
;** lp is an lp struct
;** index is the index of the particular start time
;** 
FUNCTION BUILD_LP_COMMAND, os, lp, index, ip_table, TYPE=type, START_ENTRY=start_entry, $
                           END_ENTRY=end_entry, CMD_TABLE=cmd_table, TAI_START=tai_start, $
			   BITPACK=bitpack, GET_BITPACK=get_bitpack

COMMON CMD_TABLE_ENTRY, first, cmd_table_entry

COMMON CMD_BITPACKED, bp_ind, bp_data


   IF (os.lp_num EQ 3) OR (os.lp_num EQ 24) THEN BITPACK=0   ;** don't bitpack wobble_in or CMD_TABLE LP's
   IF KEYWORD_SET(CMD_TABLE) THEN BITPACK=0   ;** don't bitpack if loading command table

   ;**************************************************************************
   ;** the following are used in the call to build_sis_msg() and
   ;** are common to all LPs
   ;**
   num_words = 28		;** # words of data after LCF header
   destination = '63'x		;** destination Processor for LCF
   lcf_cmnd_id = '91'x		;** LCF cmnd ID LCI_SCHEDULE
   data = INTARR(num_words)	;** pointer to the data to make up the lcf body

   IF KEYWORD_SET(GET_BITPACK) THEN GOTO, BITPACK_CONT

   IF (bp_ind EQ 0) THEN bp_data = INTARR(num_words)

   lcf_cmnd_id_cmd_table = '61'x		;** LCF cmnd ID LCI_UPLOAD_TABLE

   ;**************************************************************************
   ;** build up data according to exit criteria
   ;**
   ;** according to obe.ids:
   ;** EXIT CRITERIA: SCHED_ITERATION, SCHED_CYCLIC, SCHED_DURATION, SCHED_END_AT
   ;**       values           2              1               4              3
   ;**
   CASE (os.lp_exit) OF

      ;** Iteration
      0 : BEGIN
             data(0) = (ISHFT(2,8) OR os.lp_num)	;** exit criteria & lp_num
             data(4) = 0;				;** not used for Iteration exit type
             data(5) = 0;				;** not used for Iteration exit type
             data(6) = os.lp_iter;			;** iteration count
          END

      ;** Time Duration
      1 : BEGIN
             data(0) = (ISHFT(4,8) OR os.lp_num)	;** exit criteria & lp_num
             PRINT, '%%%BUILD_LP_COMMAND: Exit type of Duration Time not implemented yet.'
             RETURN, ''
          END

      ;** Absolute Time
      2 : BEGIN
             data(0) = (ISHFT(3,8) OR os.lp_num)	;** exit criteria & lp_num
             PRINT, '%%%BUILD_LP_COMMAND: Exit type of Absolute Time not implemented yet.'
             RETURN, ''
          END

      ;** Unknown exit type
      ELSE : BEGIN
             PRINT, '%%%BUILD_LP_COMMAND: Illegal exit type: '+STRN(os.lp_exit)+'  Fatal Error.'
             RETURN, ''
          END

   ENDCASE

   ;**************************************************************************
   ;** build up the start time (common for all LPs and Exit Types)
   ;**
   tai = UTC2TAI32(os.lp_start(index))
   data(1) = tai(0)		;** start time msw
   data(2) = tai(1)		;** start time mwd (32 secs)
   data(3) = tai(2)		;** start time lsw (f32 secs)

   ;**************************************************************************
   ;** build up the rest of data words for particular LP
   ;**
   CASE (os.lp_num) OF
 
      ;** Wobble In
      3 : BEGIN
             data(7) = 7		;** number of parameters to follow max 20
             ;** the 7 params for wobble in
             data(8)  = os.os_num	;** campaign number
             data(9) = lp.dpt		;** parameter table
             data(10) = lp.fw		;** filter wheel
             data(11) = lp.pw		;** polarizer wheel
             data(12) = ip_table	;** image processing table
             data(13) = N_ELEMENTS(lp.wavelength)	;** number of wl steps (images)
             data(14) = lp.start	;** start index
          END
 
      ;** Take Dark
      5 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 5		;** number of parameters to follow max 20
             ;** the 5 params for take dark
             data(8)  = os.os_num	;** campaign number
             data(9)  = lp.tele		;** telescope
             data(10) = lp.dpt		;** parameter table
             data(11) = lp.exptime	;** exposure time
             data(12) = ip_table	;** image processing table

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.tele,14) OR ISHFT(lp.dpt,12) OR ISHFT(ip_table,7) 
             bp_data(bp_ind*7+5) = word1
             bp_data(bp_ind*7+6) = lp.exptime
             bp_ind = bp_ind+1

           ENDELSE

          END

      ;** Take FP Scan Line
      8 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 8		;** number of parameters to follow max 20
             ;** the 8 params for take fp scan line
             data(8)  = os.os_num	;** campaign number
             data(9)  = lp.sub		;** use sub regions
             data(10) = lp.dpt		;** parameter table
             data(11) = lp.fw		;** filter wheel
             data(12) = lp.pw		;** polarizer wheel
             data(13) = ip_table	;** image processing table
             data(14) = N_ELEMENTS(lp.wavelength)	;** number of wl steps (images)
             data(15) = lp.start	;** start index

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.dpt,14) OR ISHFT(ip_table,9) OR ISHFT(lp.sub,8) OR $
                     ISHFT(lp.fw,5) OR ISHFT(lp.pw,2)
             bp_data(bp_ind*7+5) = word1
             word2 = ISHFT(N_ELEMENTS(lp.wavelength),10) OR ISHFT(lp.start,4)
             bp_data(bp_ind*7+6) = word2
             bp_ind = bp_ind+1

           ENDELSE

          END
 
      ;** Take Normal
      9 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 20		;** number of parameters to follow max 20
             ;** the 20 params for take normal
             ;** note: with the scheduling tool we only schedule Take Normals with
             ;**       one telescope at a time.
             data([9,14,19,24]) = 1	;** initialize all dpt's to 1 (OBE chokes if 0)
             i = (lp.tele * 5) + 8
             data(i)   = 1		;** use lp.tele
             data(i+1) = lp.dpt		;** lp.tele dpt
             data(i+2) = lp.fw		;** lp.tele fw
             data(i+3) = lp.pw		;** lp.tele pw
             data(i+4) = ip_table	;** image processing table
             data(8) = (data(8) + (os.os_num*2))	;** add campaign number to use c1 index

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.tele,14) OR ISHFT(lp.dpt,12) OR ISHFT(ip_table,7) OR $
                      ISHFT(lp.fw,4) OR ISHFT(lp.pw,1)
             bp_data(bp_ind*7+5) = word1
             bp_ind = bp_ind+1

           ENDELSE
          END
 
      ;** Ground to Periph 
      11 : BEGIN

             CASE (type) OF

                0 : BEGIN		;** Check and Correct
                      data(7) = 1		;** number of parameters to follow max 20
                      data(8)  = 34061       	;** data word for check and correct
                    END

                1 : BEGIN		;** Move FP
                      wl = os.lp_move_fp_wl(index)
                      order = os.lp_move_fp_order(index)
                      data(7) = 4		;** number of parameters to follow max 20
                      data(8)  = 5396       	;** data word for move fp
                      data(9)  = FIX(wl)   	;** integer wavelength
                      data(10)  = FIX(FLOAT((wl - FIX(wl))*10000))   	;** fractional wavelength
                      data(11)  = FIX(order)	;** order
                    END

                ELSE : BEGIN
                       PRINT, '%%BUILD_LP_COMMAND: Unknown table type: ', type
                    END

             ENDCASE
          END

      ;** Upload Parameter Table
      13 : BEGIN
             CASE (type) OF

                1 : BEGIN		;** camera parameters table
                       data(7) = 15		;** number of parameters to follow max 20
                       data(8) = 1		;** Type of Table: camera
                       data(9) = lp.tele	;** Telescope (0-3)
                       data(10) = lp.dpt		;** parameter table
                       data(11)= lp.ccd.lpulse	;** long pulse
                       data(12)= lp.ccd.y1
                       data(13)= lp.ccd.x1
                       data(14)= lp.ccd.y2
                       data(15)= lp.ccd.x2
                       data(16)= lp.ccd.ysum
                       data(17)= lp.ccd.xsum
                       data(18)= (lp.ccd.side * 2^8) OR lp.ccd.port
                       data(19)= (lp.ccd.nclrs * 2^8) OR lp.ccd.clr_spd
                       data(20)= (lp.ccd.hihtr * 2^8) OR lp.ccd.lowhtr
                       data(21)= lp.ccd.fp_candc	;** do_fp_cc
                       data(22)= lp.ccd.leb_sum		;** leb inter sum wt
                    END

                2 : BEGIN		;** Region Of Interest Mask
                       data(7) = 19		;** number of parameters to follow max 20
                       data(8) = 2		;** Type of Table: ROI
                       data(9) = lp.tele	;** Telescope (0-3)
                       data(10) = start_entry	;** Start Entry (0-63)
                       obeblocks = BLOCKS2OBE(lp.roi)
                       FOR i=0, 15 DO $		;** 16 blocks at a time
                          data(11+i) = (obeblocks(start_entry + i) AND 'ffff'x)
                    END

                3 : BEGIN		;** Occulter Mask
                       data(7) = 19		;** number of parameters to follow max 20
                       data(8) = 3		;** Type of Table: Occulter
                       data(9) = lp.tele	;** Telescope (0-3)
                       data(10) = start_entry	;** Start Entry (0-63)
                       obeblocks = BLOCKS2OBE(lp.occ)
                       FOR i=0, 15 DO $		;** 16 blocks at a time
                          data(11+i) = (obeblocks(start_entry + i) AND 'ffff'x)
                    END

                4 : BEGIN		;** Exposure Times
                    END

                5 : BEGIN		;** FP Wavelength/Exposure Times
                       data(7) = 4+((end_entry-start_entry+1)*4) ;** number of parameters to follow max 20
                       data(8) = 5		;** Type of Table: WL/EXP
                       data(9) = lp.dpt-1	;** parameter table (0-2)
                       data(10) = lp.fw		;** filter (0-4)
                       data(11) = start_entry	;** Start Entry (0-9)
                       wl = lp.wavelength
                       FOR i=0, end_entry-start_entry DO BEGIN
                          data(12+(i*4)) = FIX(wl(i+start_entry))	;** Integer Wavelength
                          data(13+(i*4)) = FIX((wl(i+start_entry) - FIX(wl(i+start_entry))) * 10000)	;** Fractional Wavelength
                          data(14+(i*4)) = FIX(lp.exptime(i+start_entry))	;** Exposure Time
                          data(15+(i*4)) = FIX(lp.order(i+start_entry))	;** FP Order
                       ENDFOR
                    END

                ELSE : BEGIN
                       PRINT, '%%BUILD_LP_COMMAND: Unknown table type: ', type
                    END

             ENDCASE

          END
 
      ;** Take Polarization Sequence
      14 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 11		;** number of parameters to follow max 20
             ;** the 10 params for take polarization sequence
             data(8)  = os.os_num	;** campaign number
             data(9)  = lp.tele		;** telescope
             data(10) = lp.dpt		;** parameter table
             data(11) = lp.fw		;** filter wheel
             data(12) = ip_table	;** image processing table
             data(13) = N_ELEMENTS(lp.pw)	;** number PW positions (num images)
             data(14:14+N_ELEMENTS(lp.pw)-1) = lp.pw	;** PW positions

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.tele,14) OR ISHFT(lp.dpt,12) OR ISHFT(ip_table,7) OR $
                      ISHFT(lp.fw,4) OR ISHFT(N_ELEMENTS(lp.pw),1)
             bp_data(bp_ind*7+5) = word1
             pw = INTARR(5)
             pw(0:N_ELEMENTS(lp.pw)-1) = lp.pw	;** PW positions
             word2 = ISHFT(pw(0),13) OR ISHFT(pw(1),10) OR ISHFT(pw(2),7) OR $
                     ISHFT(pw(3),4) OR ISHFT(pw(4),1)
             bp_data(bp_ind*7+6) = word2
             bp_ind = bp_ind+1

           ENDELSE
          END
 
      ;** Take Cal Lamp
      17 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 7		;** number of parameters to follow max 20
             ;** the 7 params for take cal lamp
             data(8)  = os.os_num	;** campaign number
             data(9)  = lp.tele		;** telescope
             data(10) = lp.dpt		;** parameter table
             data(11) = lp.fw		;** filter wheel
             data(12) = lp.pw		;** polarizer/sector wheel
             data(13) = ip_table	;** image processing table
             data(14) = lp.lamp		;** lamp to use

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.tele,14) OR ISHFT(lp.dpt,12) OR ISHFT(ip_table,7) OR $
                      ISHFT(lp.fw,4) OR ISHFT(lp.pw,1)
             bp_data(bp_ind*7+5) = word1
             bp_data(bp_ind*7+6) = lp.lamp
             bp_ind = bp_ind+1

           ENDELSE
          END
 
      ;** Take Sum
      19 : BEGIN
           IF NOT(KEYWORD_SET(BITPACK)) THEN BEGIN

             data(7) = 9		;** number of parameters to follow max 20
             ;** the 9 params for take sum
             data(8)  = os.os_num	;** campaign number
             data(9)  = lp.tele		;** telescope
             data(10) = lp.dpt		;** parameter table
             data(11) = lp.fw		;** filter wheel
             data(12) = lp.pw		;** polarizer wheel
             data(13) = lp.num		;** number of images
             data(14) = ip_table(0)	;** image processing table 0
             data(15) = ip_table(1)	;** image processing table sum
             data(16) = ip_table(2)	;** image processing table final

           ENDIF ELSE BEGIN

             bp_data(bp_ind*7)   = (ISHFT(0,8) OR os.lp_num)	;** 00 - flag for bitpacked cmd & lp_num
             bp_data(bp_ind*7+1) = tai(0)
             bp_data(bp_ind*7+2) = tai(1)
             bp_data(bp_ind*7+3) = tai(2)
             bp_data(bp_ind*7+4) = os.os_num
             word1 = ISHFT(lp.tele,14) OR ISHFT(lp.dpt,12) OR ISHFT(lp.fw,9) OR $
                     ISHFT(lp.pw,6) OR lp.num
             bp_data(bp_ind*7+5) = word1
             word2 = ISHFT(ip_table(0),11) OR ISHFT(ip_table(1),6) OR ISHFT(ip_table(2),1)
             bp_data(bp_ind*7+6) = word2
             bp_ind = bp_ind+1

           ENDELSE
          END

      ;** CMD Table Schedule
      24 : BEGIN
             data(7) = 2		;** number of parameters to follow max 20
             ;** the 2 params for Sched Set
             data(8)  = lp.start
             data(9) = lp.num_images
          END
 
      ELSE : BEGIN
             PRINT, '%%%BUILD_LP_COMMAND: Unknown LP: '+STRN(os.lp_num)
             RETURN, ''
          END

   ENDCASE

IF NOT(KEYWORD_SET(CMD_TABLE)) THEN BEGIN

BITPACK_CONT:

 ;** check to see if bitpacked command is full (4 cmds) if so generate cmd str else return
 IF (KEYWORD_SET(BITPACK)) THEN BEGIN
    IF ( (bp_ind EQ 4) OR KEYWORD_SET(GET_BITPACK) ) THEN BEGIN
       bp_ind = 0 
       data = bp_data
    ENDIF ELSE RETURN, ''
 ENDIF
   ;**************************************************************************
   ;** call the c routine build_sis_msg to build the binary command string
   ;**
   check = 1
   WHILE (check EQ 1) DO BEGIN
;      so_path = ''
;help,so_path +'build_sis_msg.so',num_words,destination,data
;stop
;      cmd_string = CALL_EXTERNAL(		$
;          so_path +'build_sis_msg.so', 	$;** the sharable object file
;          'build_sis_msg', 		$;** the routine to call (entry point)
;          num_words, 		$;** param 0 unsigned short num_words;     /* of data in LCF msg            */
;          destination, 		$;** param 1 unsigned short destination;   /* LEB PROCESSOR; for LCF header */
;          lcf_cmnd_id, 		$;** param 2 unsigned short lcf_cmnd_id;   /* for LCF header                */
;          data, 			$;** param 3 unsigned short *data; /* pointer to all data           */
;          /S_VALUE)		 ;** routine returns a null terminated string
      build_sis_msg,num_words,destination,lcf_cmd_id,data,cmd_string
      IF (STRLEN(cmd_string) EQ 223) THEN $
         check = 0 $
      ELSE BEGIN
         PRINT, '%%BUILD_LP_COMMAND: build_sis_msg error - re-generating command ', cmd_string
      ENDELSE
   ENDWHILE

ENDIF ELSE BEGIN
   ;**************************************************************************
   ;** call the c routine build_sis_msg to build the binary command string
   ;** for the command table upload.
   ;**
   so_path = ''

   IF (first EQ 1) THEN first=0 ELSE cmd_table_entry=cmd_table_entry+1

   ;******************************************************************************************
   ;** first get the command for SCHED_SET_TIME to set the start time, LP, and iteration count
   num_words = 9
   cmd_data = INTARR(num_words)
   cmd_data(0) = ISHFT(num_words-2,8) OR 32	;** # words to follow | 32 (SCHED_SET_TIME)
   cmd_data(1) = cmd_table_entry	;** index to line in table
   cmd_data(2) = 1			;** schedule
   cmd_data(3) = os.lp_num		;** LP number
   delta_tai = UTC2TAI32(TAI2UTC(UTC2TAI(os.lp_start(index)) - tai_start))
   cmd_data(4) = delta_tai(2)	;** Start Time F32 (MSW is ignored since only delta)
   cmd_data(5) = delta_tai(1)	;** Start Time C32 (MSW is ignored since only delta)
   cmd_data(6) = 2			;** exit type, 2=iteration
   cmd_data(7) = os.lp_iter		;** iteration count
   cmd_data(8) = 0			;** exit time, not used
   ;cmd_string1 = CALL_EXTERNAL(		$
   ;    so_path +'build_sis_msg.so', 	$;** the sharable object file
   ;    'build_sis_msg', 		$;** the routine to call (entry point)
   ;    num_words, 		$;** param 0 unsigned short num_words;     /* of data in LCF msg            */
   ;    destination, 		$;** param 1 unsigned short destination;   /* LEB PROCESSOR; for LCF header */
   ;    lcf_cmnd_id_cmd_table,	$;** param 2 unsigned short lcf_cmnd_id;   /* for LCF header                */
   ;    cmd_data, 		$;** param 3 unsigned short *data; /* pointer to all data           */
   ;    /S_VALUE)		 ;** routine returns a null terminated string
      build_sis_msg,num_words,destination,lcf_cmd_id_cmd_table,cmd_data,cmd_string1

   ;***************************************************************************
   ;** then get the command for SCHED_SET_PARM to set the parameters for the LP
   num_words = 23
   cmd_data2 = INTARR(num_words)
   cmd_data2(0) = ISHFT(num_words-2,8) OR 33	;** # words to follow | 33 (SCHED_SET_PARM)
   cmd_data2(1) = cmd_table_entry	;** index to line in table
   cmd_data2(2) = data(7)	;** # of parameters
   cmd_data2(3:*) = data(8:*)	;** parameters
   ;cmd_string2 = CALL_EXTERNAL(		$
   ;    so_path +'build_sis_msg.so', 	$;** the sharable object file
   ;    'build_sis_msg', 		$;** the routine to call (entry point)
   ;    num_words, 		$;** param 0 unsigned short num_words;     /* of data in LCF msg            */
   ;    destination, 		$;** param 1 unsigned short destination;   /* LEB PROCESSOR; for LCF header */
   ;    lcf_cmnd_id_cmd_table,	$;** param 2 unsigned short lcf_cmnd_id;   /* for LCF header                */
   ;    cmd_data2, 		$;** param 3 unsigned short *data; /* pointer to all data           */
   ;    /S_VALUE)		 ;** routine returns a null terminated string
   build_sis_msg,num_words,destination,lcf_cmd_id_cmd_table,cmd_data2,cmd_string2
   cmd_string = [cmd_string1, cmd_string2]

ENDELSE

   RETURN, cmd_string

END
