/* 2/5/2024 Dennis Wang  removed unneeded include files and unused variables */
/* ======================================================================== */
/* include the header files  */
/* ------------------------------------------------------------------------ */
#include <stdio.h>
#include <ctype.h>
#include <string.h>
/*
#include <xview/xview.h>                       
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/icon.h>
#include <xview/font.h>
#include <xview/xview.h>                       
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/icon.h>
#include <xview/font.h>
#include <xview/notify.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include <xview/scrollbar.h>
#include "control_global_data.c"
#include "igse.inc"
#include "lcf.h"
*/

extern char rcc_send();

unsigned short build_cam_word0();

void build_sis_msg( num_words, destination, lcf_cmnd_id, data, string )

   unsigned short num_words;     /* of data in LCF msg            */
   unsigned char  destination;   /* LEB PROCESSOR; for LCF header */
   unsigned char  lcf_cmnd_id;   /* for LCF header                */
   unsigned short *data;         /* pointer to all data           */
   unsigned char  *string;       /* pointer to output msg         */
{
   
   short          status;
   short          i;
   unsigned char  byte_x_sum;
   unsigned short SOHO_OBDH_xsum = 0;
   unsigned char  string2[10];

/* ============================================================================== */
/* Now build up the SIS channel direction stuff                                   */
/* ============================================================================== */
   strcpy (string,"");

/* NOTE: this stuff is the same for whatever control panel module you create */
/*    However, I don't know if it will change when going to CCS from SIS */

/* ============================================================================== */
/* SOHO header= destination(msb) and Word count(lsb) including SOHO header        */
/* ------------------------------------------------------------------------------ */
/* NOTE: this line may change with the CCS (I don't know) */

   strcat( string,"0x25" ); /* this is lasco destination field(EIT stuff goes to lasco anyway) */

/* this is msg length in words not including the SOHO xsum word at the end (SIS creates it) */
   sprintf( string2,"%02x,", 1 + /* SOHO header */
                            2 + /* LCF header */
                            num_words ); /* length in words of message data */
   strcat( string, string2 );

   SOHO_OBDH_xsum += 0x2500 + 1 + 2 + num_words;

/* =========================================================================== */
/* Now build the LCF header and attach to string                                / */
/* =========================================================================   */
/* NOTE: LCF is Lasco Communication Format and is LEB dependent */

/* LCF first word */
   sprintf( string2,"0x%02x", lcf_cmnd_id );
   strcat( string, string2 );

   sprintf( string2,"%02x", destination );
   strcat( string, string2 );

   SOHO_OBDH_xsum += (lcf_cmnd_id << 8) + destination;;

/* LCF word two */
/* ------------------------------------------------------------------------------ */
/* byte count to follow after this field (always odd)                             */
/* ------------------------------------------------------------------------------ */
   sprintf( string2, ",0x%02x", (num_words*2) +1 );
   strcat( string, string2 );

   SOHO_OBDH_xsum += ((num_words*2) + 1) << 8 ;
  
/* ------------------------------------------------------------------------------ */
/* xsum field                                                                     */
/* xsum includes everything in LCF except xsum field                              */
/* ------------------------------------------------------------------------------ */
   byte_x_sum = (num_words*2) +1; 
   byte_x_sum += destination;
   byte_x_sum += lcf_cmnd_id;

   for( i=0; i<num_words; i++)
   {
      byte_x_sum += data[i] & 0xFF;
      byte_x_sum += data[i] >>8;
   }
   sprintf( string2, "%02x", byte_x_sum );
   strcat( string,string2 ); 

   SOHO_OBDH_xsum += byte_x_sum ;

/*
#ifdef DEBUG_PRINT
printf(" num_words %x xsum = %x soho_xsum %x\n",num_words,byte_x_sum,SOHO_OBDH_xsum);
#endif
*/

/* NOTE: the data that goes after the LCF header is according to the IDS's for all
   the lasco processors. See each for specific information to fill these msgs */

/* ============================================================================== */
/* Now attach the data to the end of the LCF header                               */
/* ============================================================================== */

/* The bytes need to be swapped for this system to work ?? I don't know why */
   for( i=0; i<num_words; i++)
   {
      sprintf( string2,",0x%02x", (data[i] & 0xFF) );
      strcat( string, string2 );

      sprintf( string2,"%02x", (data[i] >> 8) );
      strcat( string, string2 );

      SOHO_OBDH_xsum += ((data[i] & 0xFF) << 8) + (data[i] >> 8);

/*
#ifdef DEBUG_PRINT
printf("data[%d]=%04x\n",i,data[i] );
#endif
*/
   }

/* ====Add SOHO_OBDH_xsum word===D.Wang 1/24/95================================== */

      sprintf( string2,",0x%04x", SOHO_OBDH_xsum );
      strcat( string, string2 );

/* Done creating the message to send */
#ifdef DEBUG_PRINT
   printf(" %s \n", string );
#else
      i = rcc_send( string );        /* this sends the file to the SIS */
#endif

 }


unsigned short 
build_cam_word0(num_params, cam_id, cmnd_id)
   unsigned char  num_params;      /* number of parameters in command   */
   unsigned char  cam_id;          /* camera identification (1-4)       */
   unsigned char  cmnd_id;         /* command identification number     */
{
   unsigned short word0;

   /* build first word in camera command */
   word0 = (num_params << 11) | (cam_id << 8) | cmnd_id;

   /* if num_params == 0 then set high bit on */
   if (num_params == 0) word0 = word0 | 0x8000;

   return word0;
}
