; IDL port of build_sis_msg.c
; INPUT: from C code
; unsigned short num_words;     /* of data in LCF msg            */
; unsigned char  destination;   /* LEB PROCESSOR; for LCF header */
; unsigned char  lcf_cmnd_id;   /* for LCF header                */
; unsigned short *data;         /* pointer to all data           */

; OUTPUT: ; from C code
; unsigned char  *string;       /* pointer to output msg         */

; COMMENTS:
; replaces build_sis_msg.so CALL_EXTERNAL
; VERSION: 11 Feb 2024 - SuperBowl LVIII Sunday 2024 - Dennis Wang
;
PRO build_sis_msg, num_words, destination,lcf_cmnd_id,data,outstr,prt=prt
; LASCO destination id = 0x25 = 69
;
; define LCF_CMND_ID
lcf_cmnd_id = 145
;
;
if keyword_set(prt) then print,'num_words',num_words, ' destination ',destination ,' lcf_cmnd_id ',lcf_cmnd_id 
outstr='0x25'  
string2=string(format='(z02)',1+2+num_words)
outstr=outstr+string2
soho_xsum=uint('2500'x + 1ul + 2 + num_words)

; LCF word 1
string2=string(format='(3h,0x,z02)',lcf_cmnd_id AND 255)
outstr=outstr+string2
string2=string(format='(z02)',destination AND 255)
outstr=outstr+string2
soho_xsum=soho_xsum + (256*lcf_cmnd_id) + destination

; LCF word 2 
string2=string(format='(3h,0x,z02)',(num_words*2u) + 1u)
outstr=outstr+string2
soho_xsum=soho_xsum+(256*((num_words*2) + 1u))

;xsum
byte_xsum = (num_words*2) + 1u + destination + lcf_cmnd_id
FOR i=0,num_words-1 DO BEGIN
ldata = uint(data)
byte_xsum = byte_xsum + (ldata[i] AND 255)
byte_xsum = byte_xsum + ((ldata[i]/256) AND 255)
ENDFOR
; just append LSB to LCF
byte_xsum = byte_xsum AND 255
string2=string(format='(z02)',byte_xsum)
outstr=outstr+string2

soho_xsum=soho_xsum + byte_xsum

if keyword_set(prt) then print,format='(10Hbyte_xsum ,z02,11H soho_xsum ,z04)',byte_xsum AND 'FF'x,soho_xsum AND 'FFFF'x

; byte_swap words
FOR i=0,num_words-1 DO BEGIN
string2=string(format='(3h,0x,z02)',ldata[i] AND 255)
outstr=outstr+string2
string2=string(format='(z02)',(ldata[i]/256) AND 255)
outstr=outstr+string2

soho_xsum=soho_xsum + (256*(ldata[i] AND  255)) + (ldata[i]/256)
if keyword_set(prt) then print,format='(5hdata ,z04,2h: ,z04)',i,ldata[i]
ENDFOR

string2=string(format='(3h,0x,z04)',soho_xsum AND 'FFFF'x)
outstr=outstr+string2

if keyword_set(prt) then print,' byte_xsum (with data) ',byte_xsum ,' soho_xsum ',soho_xsum 
if keyword_set(prt) then print,outstr
END
