;+
; Project     : SOHO - LASCO/EIT
;
; Name        : FAKE_OS
;
; Purpose     : Define some sample Observation Sequences for LASCO/EIT Schedule.
;
; Explanation : This routine defines the os_arr, tm_arr, and defined_os_arr
;               Observation Sequence arrays either from scratch
;               or from the saved dataset 'os_arr.dat'.  In the future
;               this routine may be replaced by a better implementation
;               such as one that reads from a database.
;
; Use         : FAKE_OS, startdis
;
; Inputs      : startdis        input start of display time in TAI.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : TAI2UTC, UTC2TAI
;
; Called from : SCHEDULE.PRO
;
; Common      : 
;		COMMON OS_SCHEDULED, os_struct, os_arr, tm_arr
;		COMMON OS_DEFINED, defined_os_arr, os_instance
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Planning, Scheduling.
;
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;
; Modified    :
;
; Version     : Version 0.1, December 5, 1994
;-
 
;__________________________________________________________________________________________________________
;

PRO FAKE_OS, startdis

COMMON OS_SCHEDULED, os_struct, os_arr, tm_arr, load_camtable, load_wlexptable, do_candc, move_fp
COMMON OS_DEFINED, defined_os_arr, os_instance


   os_struct = {os_struct, os_num:0L, os_start:0.0D, os_stop:0.0D, os_size:0L, os_duration:0.0D}

;goto, cont
   exist = FINDFILE('os_arr.dat')
   IF (exist(0) EQ '') THEN os_arr = -1 ELSE RESTORE, 'os_arr.dat'
   ;** change day to startdis
;   datastart = TAI2UTC(startdis)             ; form .DAY and .TIME
;   thisstart = TAI2UTC(os_arr.os_start)      ; form .DAY and .TIME
;   thisstart.mjd = datastart.mjd
;   os_arr.os_start = UTC2TAI(thisstart)                ; start of STARTDIS in TAI
;   os_arr.os_stop = os_arr.os_start + os_arr.os_duration
   GOTO, CONT2
CONT:


   os_arr = REPLICATE(os_struct, 100)	;** an array of 100 structures


   datastart = TAI2UTC(startdis)                ; form .DAY and .TIME
   datastart.time = 0                           ; only want day part
   daystart = UTC2TAI(datastart)                ; start of STARTDIS in TAI


   D1 = [2,6.5,8,20]                     ; contact start time
   D2 = [3.5,8,16,21.5]                  ; contact end time
 
  ; Convert to second from DAYSTART and load into common
 
  dsn_start = daystart + (D1 * 3600D)   ; into sec
  dsn_stop  = daystart + (D2 * 3600D)   ; into sec

i = 0  
s=[2,6.5,8,20]  &  d=0.3D  &  os_num=1000  &  os_size=16777700
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

s=[3]  &  d=0.5D  &  os_num=2010  &  os_size=16777700
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

s=[4,6]  &  d=0.5D  &  os_num=10  &  os_size=16777700
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

s=[9,9.2,9.4,9.6]  &  d=0.2D  &  os_num=1013  &  os_size=16777700
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

s=[15,15.2,15.4,15.6]  &  d=5.D/60.D  &  os_num=990  &  os_size=152278L
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

s=[16]  &  d=0.5D  &  os_num=2009  &  os_size=12052619L*8L
for j=0, n_elements(s)-1 do begin
  os_arr(i).os_num=os_num 
  os_arr(i).os_start=daystart+(s(j)*3600D) 
  os_arr(i).os_stop=daystart+(s(j)*3600D)+(d*3600D)
  os_arr(i).os_size=os_size 
  os_arr(i).os_duration=(d*3600D)
  i = i + 1
endfor

   os_arr = os_arr(0:i-1)
   os_arr.os_size = os_arr.os_size + (os_arr.os_size MOD 8)	;** align on byte boundary




CONT2:
   tm_struct = {tm_struct, start:0.0D, mode:0}

   tmstrt = [0.0,6.5,8.0,30.0,36.0]      ; hrs into day tm mode is switched
   mode = [  1,  2,   1,   1, 1]      ; mode tm switched to
   tm_arr = REPLICATE(tm_struct, N_ELEMENTS(tmstrt))

   tm_arr.start = (tmstrt * 3600D) + startdis
   tm_arr.mode = mode


END
