; fills in the  ccd structure with input string arrays
;
; ccd : the ccd structure (defined in fill_in_lp.pro)
;
; ro  : '(p1row,p1col,p2row,p2col,sumrow,sumcol)' ex: '(1,21,1024,1044,2,2)'
; oth : '(port,clr_type,nclr,hi_heat,low_heat,lpulse,fp_cc,leb_sum,side)' ex: '(2,1,10,0,255,20,32,1,0)'
;
FUNCTION FILL_IN_CCD, ccd, ro, oth

   ro_arr = FIX(STR2ARR(STRMID(ro,1,STRLEN(ro)-2),DELIM=','))
   ccd.x1 = 1 > ro_arr(1)
   ccd.y1 = 1 > ro_arr(0)
   ccd.x2 = 1 > ro_arr(3) > ccd.x1
   ccd.y2 = 1 > ro_arr(2) > ccd.y1
   ccd.xsum = ro_arr(5) & IF (ccd.xsum LE 1) THEN ccd.xsum = 0
   ccd.ysum = ro_arr(4) & IF (ccd.ysum LE 1) THEN ccd.ysum = 0

   oth_arr = FIX(STR2ARR(STRMID(oth,1,STRLEN(oth)-2),DELIM=','))
   ccd.port    = 0 > oth_arr(0) < 3
   ccd.clr_spd = 0 > oth_arr(1) < 1
   ccd.nclrs   = 0 > oth_arr(2) < 15
   ccd.hihtr  = 0 > oth_arr(3) < 1
   ccd.lowhtr = 0 > oth_arr(4) < 255
   ccd.lpulse  = 0 > oth_arr(5)
   ccd.fp_candc= 0 > oth_arr(6)
   ccd.leb_sum = 1 > oth_arr(7) < 1024
   ccd.side    = 0 > oth_arr(8) < 1

   RETURN, ccd

END
