PRO gen_occ_cmd,fname,telescope
;
;  procedure to read in text file of hex values for the occulter mask
;  output by the planning tool and then generate scenario file of 4 commands
;
np = n_params()
IF (np EQ 1)  THEN BEGIN
   t = ''
   READ,'Enter Telescope Name (EIT,C1,C2,C3):  ',t
ENDIF ELSE t=telescope
tname = ['C1','C2','C3','EIT']
w = WHERE (tname EQ STRUPCASE(t),nw)
IF (nw NE 1)  THEN BEGIN
   PRINT,'ERROR: (GEN_OCC_CMD) Unrecognized telescope:  ',t
   RETURN
ENDIF
tnum = w(0)
IF (np GT 0)  THEN BEGIN
   OPENR,lu,fname,/GET_LUN
ENDIF ELSE BEGIN
   PRINT,'ERROR: (GEN_OCC_CMD) Input file name must be specified.'
   RETURN
ENDELSE
nc = STRLEN(fname)
root = STRMID(fname,0,nc-3)
fname_out = root+'sce'
PRINT,'Writing occulter mask commands to '+fname_out
OPENW,luout,fname_out,/GET_LUN
lp_num = 13			; occulter upload
num_words = 28
destination = '63'x
lcf_cmd_id = '91'x
cmd = INTARR(num_words)
FOR icmd=0,3 DO BEGIN
    data = LONARR(8)
;
;  exit by iteration count of 1
;
    cmd(0) = (ISHFT(2,8) OR lp_num)
    cmd(4) = 0
    cmd(5) = 0
    cmd(6) = 1
;
;  start time
;
    cmd(1) = 0		; tai(0)
    cmd(2) = 0		; tai(1)
    cmd(3) = 0		; tai(2)
;
;  Occulter Mask Command
;
    cmd(7) = 19		; number of parameters to follow
    cmd(8) = 3		; type of table - occulter
    cmd(9) = tnum	; telescope number
    cmd(10) = 16*icmd	; start entry (0,16,32,48)
    ok = ''
    s = ''
    FOR j=0,1 DO BEGIN
        ok = ''
        REPEAT BEGIN
           READF,lu,s
           IF (STRLEN(s) GE 62)  THEN BEGIN
              IF (STRMID(s,0,2) EQ '0x')  THEN BEGIN
                 READS,s,data,format='(2x,z4,4x,z4,4x,z4,4x,z4,4x,z4,4x,z4,4x,z4,4x,z4)'
                 FOR i=0,7 DO cmd(11+i+8*j) = data(i) AND 'ffff'x
                 ok = 'ok'
              ENDIF
           ENDIF
        ENDREP UNTIL (ok NE '')
    ENDFOR
    ; write out the SIS message
;    PRINTF,luout,cmd,FORMAT='(27("0x",z4.4,","),"0x",z4)'
    so_path = ''
    ;cmd_string = CALL_EXTERNAL(so_path+'build_sis_msg.so', 'build_sis_msg', $
    ;             num_words, destination, lcf_cmd_id, cmd, /S_VALUE)
    build_sis_msg, num_words, destination, lcf_cmd_id, cmd, cmd_string)
    IF (STRLEN(cmd_string) EQ 223)  THEN BEGIN
       PRINTF,luout,cmd_string
    ENDIF ELSE BEGIN
       PRINT,'%%GEN_OCC_CMD: build_sis_msg error'
    ENDELSE

ENDFOR
CLOSE,lu
PRINTF,luout,'*'
CLOSE,luout
FREE_LUN,lu
FREE_LUN,luout
RETURN
END

