PRO GENERATE_BUF, startdis, enddis

COMMON SCHEDULE_BUFFER, save_buffer


   ;*************************************************
   ;** form BUF filename LASYYYYMMDDvvv.BUF
   ;**
   GET_UTC, today
   utc = TAI2UTC(startdis, /EXTERNAL)
   buf_file_name = 'LAS'+STRN(utc.year)+STRN(utc.month,FORMAT='(I2.2)')+STRN(utc.day,FORMAT='(I2.2)')

   ;*************************************************
   ;** check for previous versions
   ;** 
 ; 2011-Jan-20 (einfalt) Changed to square braces, for LASCO13
   ;                       Use to be: IF (exist(0) EQ '') THEN $
   ; Also added brackets to the exist[count-1] if base file exists
   
   exist = FINDFILE(buf_file_name + '???.BUF', count=count)
   IF (exist[0] EQ '') THEN $					;** first version
      buf_file_name = buf_file_name + '000.BUF' $
   ELSE BEGIN
      exist = STRUPCASE(exist[count-1])				;** make next version
      version = FIX(STRMID(exist,11,3))+1
      buf_file_name = buf_file_name + STRN(version,FORMAT='(I3.3)') + '.BUF'
   ENDELSE

   ;*************************************************
   ;** Write out BUF File Header
   ;** 
   PRINT, '%%%GENERATE_BUF: Generating BUF File ', buf_file_name
   OPENW, buf_file, buf_file_name, /GET_LUN
   PRINTF, buf_file, 'DATATYPE = LASCO BUFFER USAGE STATISTICS'
   PRINTF, buf_file, 'FILENAME = '+buf_file_name
   PRINTF, buf_file, 'INSTRUME = LASCO'
   PRINTF, buf_file, 'ORIG_ID  = igse@lasco'
   PRINTF, buf_file, 'OBSERVER = LASCO Operator'
   PRINTF, buf_file, 'DATE_CRE = '+UTC2STR(today, /ECS, /TRUNCATE)
   PRINTF, buf_file, 'STARTIME = '+UTC2STR(TAI2UTC(startdis), /ECS, /TRUNCATE)
   PRINTF, buf_file, 'ENDTIME  = '+UTC2STR(TAI2UTC(enddis), /ECS, /TRUNCATE)
   PRINTF, buf_file, 'COMMENT  = buffer size is 1069256 words * 2 bytes/word * 8 bits/byte = 17108096 bits'
   PRINTF, buf_file, 'COMMENT  = TAI    BITS USED         %FULL'
   PRINTF, buf_file, 'END'
   PRINTF, buf_file

   ;*************************************************
   ;** Write out Buffer Stats
   ;** 
   bufsize = 1069256D                      	;** size of circular buffer in words (A & B are the same)
   bufsize = bufsize*2D*8D                 	;** convert to bits (2 bytes/word, 8 bits/byte)
   buffer_pct = (save_buffer / bufsize)*100     	;** normalize to 1.0 = 100% full
   FOR i=0, N_ELEMENTS(save_buffer)-1 DO $		;** one entry per minute of plot range
      PRINTF, buf_file, startdis+(i*60D), save_buffer(i), buffer_pct(i)

   CLOSE, buf_file
   FREE_LUN, buf_file
   PRINT, '%%%GENERATE_BUF: Done.'

END
