FUNCTION GENERATE_COMMANDS, pt_output_file_name, SILENT=silent, CMD_TABLE=cmd_table

COMMON CMD_TABLE_ENTRY, first, cmd_table_entry

COMMON CMD_BITPACKED, bp_ind, bp_data

bitpack = 1
bp_ind = 0
lp_cmd = ''

loaded_roi = BYTARR(4,1024)

   OPENR, pt_output_file, pt_output_file_name, /GET_LUN
   commands_outfile = pt_output_file_name+'.sce'

   IF KEYWORD_SET(CMD_TABLE) THEN BEGIN
      commands_outfile = pt_output_file_name+'_cmd_table.sce'
      input = ''
      PRINT, 'All observations will be scheduled as deltas from first'
      READ, 'Enter Date/Time of first observation.  (ex. 1997/06/10 13:00): ', input
      tai_start=UTC2TAI(STR2UTC(input))
      input = 0
      READ, 'Enter Index into command table for first entry (0): ', input
      cmd_table_entry = FIX(input)
      first = 1
   ENDIF

   PRINT, '**************************************'
   PRINT, 'GENERATING SCENARIO FILE: ', commands_outfile
   PRINT, '**************************************'

   str = ''

   all_commands = ''
   all_times = 0.0D

   ;** find first occurance of PT_OS_NUM
   WHILE ( NOT(EOF(pt_output_file)) AND (STRMID(str,0,9) NE "PT_OS_NUM") ) DO BEGIN
      READF, pt_output_file, str
      str = STRTRIM(str, 2)
   ENDWHILE

   ;*************************************************
   ;** loop over each OS
   ;** 
   WHILE (NOT(EOF(pt_output_file))) DO BEGIN
      curr_str_arr = str

      str = ''
      ;** find everything up to the next occurance of PT_OS_NUM
      WHILE ( NOT(EOF(pt_output_file)) AND (STRMID(str,0,9) NE "PT_OS_NUM") ) DO BEGIN
         READF, pt_output_file, str
         str = STRTRIM(str, 2)
         ;** throw out comments and blank lines now
         IF ( (STRMID(str,0,1) NE ';') AND (str NE '') ) THEN curr_str_arr = [curr_str_arr, str]
      ENDWHILE

      ;** if str is "PT_OS_NUM" it is for the next OS loop
      IF NOT(EOF(pt_output_file)) THEN curr_str_arr = curr_str_arr(0:N_ELEMENTS(curr_str_arr)-2)

      ;print, curr_str_arr, FORMAT='(a)'
      ;print & print

      ;** curr_str_arr contains all parameters for this OS
      ;** convert this to an array of keyword/value structures
      key_val_arr = STR_ARR2KEY_VAL(curr_str_arr)

      ;** keep track of which parameters we have used
      used = BYTARR(N_ELEMENTS(curr_str_arr))

      ;** now initialize an OS structure and fill it in
      os = FILL_IN_OS(key_val_arr, used)

      ;help, /struct, os

      ;** now initialize an LP structure for this particular LP and fill it in
      lp = FILL_IN_LP(os.lp_num, key_val_arr, used)

      ;help, /struct, lp

      IF NOT(KEYWORD_SET(SILENT)) THEN BEGIN
         print & print
         ;print, key_val_arr(where(used EQ 1)), format='(a)'
         ;print & print
         print, 'Unused parameter/values:'
         print, key_val_arr(where(used NE 1)), format='(a)'
         print & print
      ENDIF

      ;** loop over each scheduled start time
      FOR s_index = 0, N_ELEMENTS(os.lp_start)-1 DO BEGIN

         ;** decide which ip table to use
         ;** for now use table number defined by os - don't upload any IP tables.
         ip_tab_num = lp.ip_tab_num

         ;**
         ;** generate command for ip upload (if needed)
         ;**

         ;**
         ;** generate command for cam upload (if needed)
         ;**
         IF (os.lp_load_cam(s_index) EQ 1) THEN BEGIN
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, '%%GENERATE_COMMANDS: Generating camera table upload commands.'
            os_cam = os
            os_cam.lp_num = 13	;** table upload
            ;** do the table upload 5 secs before the LP starts
            tai = UTC2TAI(os_cam.lp_start(s_index))
            tai = tai - 5
            os_cam.lp_start(s_index) = TAI2UTC(tai)
            cam_cmd = BUILD_LP_COMMAND(os_cam, lp, s_index, ip_tab_num, TYPE=1, CMD_TABLE=cmd_table, TAI_START=tai_start)
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, cam_cmd
            all_commands = [all_commands, cam_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
         ENDIF

         ;**
         ;** generate command for exptime upload (if needed)
         ;**

         ;**
         ;** generate command for occulter upload (if needed)
         ;**
;         ind = WHERE(lp.ip EQ 27)	;** 27 is no occ masking
;         IF (ind(0) EQ -1) THEN BEGIN
;            PRINT, '%%GENERATE_COMMANDS: Generating occulter table upload commands.'
;            IF (TOTAL(lp.occ) EQ 0) THEN $
;               PRINT, '%%GENERATE_COMMANDS: Warning defined occulter table empty.'
;            os_occ = os
;            os_occ.lp_num = 13	;** table upload
;            ;** do the table upload 5 secs before the LP starts
;            tai = UTC2TAI(os_occ.lp_start(s_index))
;            tai = tai - 5
;            os_occ.lp_start(s_index) = TAI2UTC(tai)
;            occ_cmd = BUILD_LP_COMMAND(os_occ, lp, s_index, ip_tab_num, TYPE=3, START_ENTRY=0, CMD_TABLE=cmd_table, TAI_START=tai_start)
;            PRINT, occ_cmd
;            occ_cmd = BUILD_LP_COMMAND(os_occ, lp, s_index, ip_tab_num, TYPE=3, START_ENTRY=16, CMD_TABLE=cmd_table, TAI_START=tai_start)
;            PRINT, occ_cmd
;            occ_cmd = BUILD_LP_COMMAND(os_occ, lp, s_index, ip_tab_num, TYPE=3, START_ENTRY=32, CMD_TABLE=cmd_table, TAI_START=tai_start)
;            PRINT, occ_cmd
;            occ_cmd = BUILD_LP_COMMAND(os_occ, lp, s_index, ip_tab_num, TYPE=3, START_ENTRY=48, CMD_TABLE=cmd_table, TAI_START=tai_start)
;            PRINT, occ_cmd
;         ENDIF

         ;**
         ;** generate command for roi upload (if needed)
         ;**
         ind = WHERE(lp.ip EQ 25)	;** 25 is use ROI table
         IF (ind(0) NE -1) THEN BEGIN
            PRINT, '%%GENERATE_COMMANDS: OS '+STRTRIM(os.os_num,2)+' uses the ROI table.'
            PRINT, '%%GENERATE_COMMANDS: Checking to see whether an ROI upload is needed.'
            IF (MIN(REFORM(loaded_roi(lp.tele,*)) EQ lp.roi) EQ 1) THEN BEGIN
               PRINT, '%%GENERATE_COMMANDS: This ROI is the same as the previous. No upload of ROI is needed.'
            ENDIF ELSE BEGIN
            PRINT, '%%GENERATE_COMMANDS: ROI uploaded needed.  Generating ROI table upload commands.'
            loaded_roi(lp.tele,*) = lp.roi
            IF (TOTAL(lp.roi) EQ 0) THEN $
               PRINT, '%%GENERATE_COMMANDS: Warning defined ROI table empty.'
            os_roi = os
            os_roi.lp_num = 13	;** table upload
            ;** do the table upload 5 secs before the LP starts
            tai = UTC2TAI(os_roi.lp_start(s_index))
            tai = tai - 5
            os_roi.lp_start(s_index) = TAI2UTC(tai)
            roi_cmd = BUILD_LP_COMMAND(os_roi, lp, s_index, ip_tab_num, TYPE=2, START_ENTRY=0, CMD_TABLE=cmd_table, TAI_START=tai_start)
            PRINT, roi_cmd
            all_commands = [all_commands, roi_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
            roi_cmd = BUILD_LP_COMMAND(os_roi, lp, s_index, ip_tab_num, TYPE=2, START_ENTRY=16, CMD_TABLE=cmd_table, TAI_START=tai_start)
            PRINT, roi_cmd
            all_commands = [all_commands, roi_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
            roi_cmd = BUILD_LP_COMMAND(os_roi, lp, s_index, ip_tab_num, TYPE=2, START_ENTRY=32, CMD_TABLE=cmd_table, TAI_START=tai_start)
            PRINT, roi_cmd
            all_commands = [all_commands, roi_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
            roi_cmd = BUILD_LP_COMMAND(os_roi, lp, s_index, ip_tab_num, TYPE=2, START_ENTRY=48, CMD_TABLE=cmd_table, TAI_START=tai_start)
            PRINT, roi_cmd
            all_commands = [all_commands, roi_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
            ENDELSE	;** upload of ROI needed
         ENDIF

         ;**
         ;** generate command for fp_wl upload (if needed)
         ;**
         IF ( (os.lp_num EQ 8) AND (os.lp_load_wlexp(s_index) EQ 1) ) THEN BEGIN  ;** check for LP:scan line
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, '%%GENERATE_COMMANDS: Generating Wavelength/Exposure table upload commands.'
            os_fpwl = os
            os_fpwl.lp_num = 13	;** table upload
            ;** do the table upload 5 secs before the LP starts
            tai = UTC2TAI(os_fpwl.lp_start(s_index))
            tai = tai - 5
            os_fpwl.lp_start(s_index) = TAI2UTC(tai)
            num_steps = N_ELEMENTS(lp.wavelength)

            IF (num_steps GE 4) THEN end_e = 3 ELSE end_e = num_steps-1
            fpwl_cmd = BUILD_LP_COMMAND(os_fpwl, lp, s_index, ip_tab_num, TYPE=5, $
                          START_ENTRY=0, END_ENTRY=end_e, CMD_TABLE=cmd_table, TAI_START=tai_start)
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, fpwl_cmd
            all_commands = [all_commands, fpwl_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]

            IF (num_steps GT 4) THEN BEGIN
               IF (num_steps GE 8) THEN end_e = 7 ELSE end_e = num_steps-1
               fpwl_cmd = BUILD_LP_COMMAND(os_fpwl, lp, s_index, ip_tab_num, TYPE=5, $
                          START_ENTRY=4, END_ENTRY=end_e, CMD_TABLE=cmd_table, TAI_START=tai_start)
               IF NOT(KEYWORD_SET(SILENT)) THEN $
               PRINT, fpwl_cmd
               all_commands = [all_commands, fpwl_cmd]
               all_times = [all_times, UTC2TAI(os.lp_start(s_index))]

               IF (num_steps GT 8) THEN BEGIN
                  fpwl_cmd = BUILD_LP_COMMAND(os_fpwl, lp, s_index, ip_tab_num, TYPE=5, $
                          START_ENTRY=8, END_ENTRY=num_steps-1, CMD_TABLE=cmd_table, TAI_START=tai_start)
                  IF NOT(KEYWORD_SET(SILENT)) THEN $
                    PRINT, fpwl_cmd
                  all_commands = [all_commands, fpwl_cmd]
                  all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
               ENDIF
            ENDIF
         ENDIF

         ;**
         ;** generate command for concurrent upload (if needed)
         ;**

         ;**
         ;** generate command for check and correct (if needed)
         ;**
         IF (os.lp_do_candc(s_index) EQ 1) THEN BEGIN
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, '%%GENERATE_COMMANDS: Generating check and correct command.'
            os_cc = os
            os_cc.lp_num = 11	;** ground to periph
            ;** do the check and correct 5 secs before the LP starts
            tai = UTC2TAI(os_cc.lp_start(s_index))
            tai = tai - 5
            os_cc.lp_start(s_index) = TAI2UTC(tai)
            cc_cmd = BUILD_LP_COMMAND(os_cc, lp, s_index, ip_tab_num, TYPE=0, CMD_TABLE=cmd_table, TAI_START=tai_start)
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, cc_cmd
            all_commands = [all_commands, cc_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
         ENDIF

         ;**
         ;** generate command to move FP (if needed)
         ;**
         IF (os.lp_move_fp_wl(s_index) NE 0) THEN BEGIN
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, '%%GENERATE_COMMANDS: Generating command to move FP.'
            os_cc = os
            os_cc.lp_num = 11	;** ground to periph
            ;** do the grnd-to-periph 5 secs before the LP starts
            tai = UTC2TAI(os_cc.lp_start(s_index))
            tai = tai - 5
            os_cc.lp_start(s_index) = TAI2UTC(tai)
            cc_cmd = BUILD_LP_COMMAND(os_cc, lp, s_index, ip_tab_num, TYPE=1, CMD_TABLE=cmd_table, TAI_START=tai_start)
            IF NOT(KEYWORD_SET(SILENT)) THEN $
            PRINT, cc_cmd
            all_commands = [all_commands, cc_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
         ENDIF

         ;**
         ;** generate binary command for the LP
         ;**
            IF NOT(KEYWORD_SET(SILENT)) THEN $
         PRINT, '%%GENERATE_COMMANDS: Generating command for the LP.'
         lp_cmd = BUILD_LP_COMMAND(os, lp, s_index, ip_tab_num, CMD_TABLE=cmd_table, TAI_START=tai_start, $
				   BITPACK=bitpack)
         IF NOT(KEYWORD_SET(SILENT)) THEN print, lp_cmd
         IF (lp_cmd(0) NE '') THEN BEGIN	;** bitpacked cmds only every 4 LPs
            all_commands = [all_commands, lp_cmd]
            all_times = [all_times, UTC2TAI(os.lp_start(s_index))]
         ENDIF

      ENDFOR	;** end looping on start times for this lp

   ENDWHILE

   IF (lp_cmd(0) EQ '') AND (bitpack EQ 1) THEN BEGIN	;** check for remaining bitpacked cmds
      lp_cmd = BUILD_LP_COMMAND(os, lp, s_index, ip_tab_num, BITPACK=bitpack, /GET_BITPACK)
      IF NOT(KEYWORD_SET(SILENT)) THEN print, lp_cmd
      all_commands = [all_commands, lp_cmd]
      all_times = [all_times, UTC2TAI(os.lp_start(s_index-1))]
   ENDIF

   CLOSE, pt_output_file
   FREE_LUN, pt_output_file

   ;** now write all commands to output file
   all_commands = all_commands(1:*) 	;** first was empty string
   all_times = all_times(1:*) 		;** first was empty
   len = N_ELEMENTS(all_commands)
   expected = 224L*len+2 	;** 224 is bytes for commands + 2 for *

   ;**
   ;** sort cmds by time order to fix scheduling bugs in LEB
   ;**
   IF KEYWORD_SET(CMD_TABLE) THEN BEGIN	;** each schedule created 2 commands
      all_times2 = [all_times,all_times]
      all_times2(indgen(N_ELEMENTS(all_times))*2) = all_times
      all_times2(indgen(N_ELEMENTS(all_times))*2+1) = all_times
      all_times = all_times2
      expected = 280*len/2+2 	;** 280 is bytes for the 2 commands + 2 for *
   ENDIF
   sort_ind = SORT(all_times)
   all_commands = all_commands(sort_ind)
   all_times = all_times(sort_ind)

   OPENW, 1, commands_outfile
   FOR i=0, N_ELEMENTS(all_commands)-1 DO PRINTF, 1, all_commands(i)
   PRINTF, 1, '*'
   CLOSE, 1
   ;** now check for garbage commands
   OPENR, 1, commands_outfile
   fs = FSTAT(1)
   CLOSE, 1

   ; Print out the command file expected and actual #'s
   PRINT, '**************************************'
   PRINT, '%%% GENERATED COMMANDS:  Expected:', expected, ' Actual:', fs.size
   PRINT, '**************************************'


   IF (fs.size EQ expected) THEN $
      done = 1 $
   ELSE BEGIN
      PRINT, '%%GENERATE_COMMANDS: Found error in output file.', fs.size, ' NE ' , expected, '  Regenerating.'
      RETURN, -1
   ENDELSE

   PRINT, '**************************************************'
   PRINT, 'DONE GENERATING SCENARIO FILE: ', commands_outfile
   PRINT, '**************************************************'

   RETURN, 0
   
END
