;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : GENERATE_IPT
;               
; Purpose     : Routine to output the schedule in IPT form.
;               
; Explanation : This routine prints out the current schedule in IPT format.
;		See the document "pt_format.txt" for a description of the
;		keyword/value pairs.
;               
; Use         : GENERATE_IPT
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : FIND_DATA_RUNS, TAI2UTC
;
; Called From : SCHEDULE_EVENT.PRO
;
; Common      : OP_SCHEDULED	Defined in FAKE_OP.PRO
;		OS_DEFINED	Defined in FAKE_OS.PRO
;		OS_SCHEDULED	Defined in FAKE_OS.PRO
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : Ed Esfandiari, NRL, March 2002.
;               Corrected C2 calib lamp assignments. C2 lamp options are either door_lamp with a value of 2
;               or shutter_lamp with a value of 3. If the input C2 lamp value is already 2 or 3, we don't
;               change the value. If input value is less than 2, then 2 is added to it to make it 2 or 3.
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
PRO GENERATE_IPT, startdis, enddis, ipt_name

COMMON OP_SCHEDULED
COMMON OS_DEFINED
COMMON OS_SCHEDULED

   IF (DATATYPE(os_arr(0)) EQ 'INT') THEN RETURN
   ;*************************************************
   ;** form IPT filename LASYYYYMMDDvvv.IPT
   ;**
   utc = TAI2UTC(startdis, /EXTERNAL)
   ipt_file_name = 'LAS'+STRN(utc.year)+STRN(utc.month,FORMAT='(I2.2)')+STRN(utc.day,FORMAT='(I2.2)')
 
   ;*************************************************
   ;** check for previous versions
   ;**
   exist = FINDFILE(ipt_file_name + '???.IPT', count=count)

   ; 2011-Jan-20 (einfalt) Changed to square braces, for LASCO13 
   ;                       Use to be: IF (exist(0) EQ '') THEN $  
   ; Also added brackets to the exist[count-1] if base file exists

   IF (exist[0] EQ '') THEN $					;** first version	
      ipt_file_name = ipt_file_name + '000.IPT' $
   ELSE BEGIN
      exist = STRUPCASE(exist[count-1])                         ;** make next version
      version = FIX(STRMID(exist,11,3))+1
      ipt_file_name = ipt_file_name + STRN(version,FORMAT='(I3.3)') + '.IPT'
   ENDELSE

   ipt_name = ipt_file_name
   OPENW, OUT, ipt_file_name, /GET_LUN
   PRINT,'%%%GENERATE_IPT: Creating file: '+ipt_file_name
   WIDGET_CONTROL, /HOUR
 

   os_arr2 = os_arr(SORT([os_arr.os_num]))   ;** sort on os_num
   uniq_os_arr2 = os_arr2(UNIQ([os_arr2.os_num]))
   num_os = N_ELEMENTS(uniq_os_arr2)

   FOR i = num_os-1, 0, -1 DO BEGIN    ;** for every unique os_num

      os_num = uniq_os_arr2(i).os_num
;   OPENW, OUT, 'OS'+STRTRIM(os_num,2)+'.IPT', /GET_LUN
      PRINTF, OUT, 'PT_OS_NUM = '+STRTRIM(os_num,2)
      ind = WHERE(defined_os_arr.os_num EQ os_num)
      lp = defined_os_arr(ind).lp

      ;** convert from LP num defined in define_os (op_types) to
      ;** actual LP num as understood by the LEB
      tmp = [0,9,5,17,14,7,20,16,19,21,2,3,4,6,8,15,11,12,13,18,22,10,1,24,0]
      PRINTF, OUT, 'PT_LP_NUM = ' + STRTRIM(tmp(lp),2)

      PRINTF, OUT, 'PT_LP_EXIT = '+STRTRIM(0,2)	;** for now always use exit by iteration
      iter_cnt = 1				;** for now always schedule just 1
      PRINTF, OUT, 'PT_LP_ITER = '+STRTRIM(iter_cnt,2)

      good = WHERE(os_arr.os_num EQ uniq_os_arr2(i).os_num)
      ;** sort on start time
      nsched = N_ELEMENTS(good)
      IF (nsched GT 1) THEN good = good(SORT([os_arr(good).os_start]))
      first_os = os_arr(good(0))
      PRINTF, OUT, 'PT_LP_NSCHED = '+STRTRIM(nsched,2)

      ;** output start times
      c = 0 					;** counter, only 5 start times per line
      cc = 0 					;** counter, only 5 start times per line
      ccc = 0 					;** counter, only 5 start times per line
      c4 = 0 					;** counter, only 5 start times per line
      FOR j=0, nsched-1 DO BEGIN 		;** for every occurance of this os_num
         IF (c EQ 0) THEN str = '('		;** new line
         IF (cc EQ 0) THEN cam_str = '('		;** new line
         IF (cc EQ 0) THEN wlexp_str = '('		;** new line
         IF (ccc EQ 0) THEN candc_str = '('		;** new line
         IF (c4 EQ 0) THEN movefp_str = '('		;** new line
         IF (c4 EQ 0) THEN movefp_str2 = '('		;** new line
         IF (c4 EQ 0) THEN movefp_str3 = '('		;** new line
         os_start = os_arr(good(j)).os_start
         utc = TAI2UTC(os_start, /EXTERNAL)
         yy = STRTRIM(utc.year,2) 
         mm = STRTRIM(utc.month,2) & IF (STRLEN(mm) EQ 1) THEN mm = '0'+mm
         dd = STRTRIM(utc.day,2)   & IF (STRLEN(dd) EQ 1) THEN dd = '0'+dd
         hh = STRTRIM(utc.hour,2)  & IF (STRLEN(hh) EQ 1) THEN hh = '0'+hh
         mi = STRTRIM(utc.minute,2)& IF (STRLEN(mi) EQ 1) THEN mi = '0'+mi
         ss = STRTRIM(utc.second,2)& IF (STRLEN(ss) EQ 1) THEN ss = '0'+ss
         tt = yy+mm+dd+'_'+hh+mi+ss
         str = str + tt + ','
         IF (DATATYPE(load_camtable) EQ 'STC') THEN BEGIN
            cind = WHERE((os_num EQ load_camtable.os_num) AND (os_start EQ load_camtable.os_start))
            IF (cind(0) NE -1) THEN BEGIN
               cam_str = cam_str + tt + ','
               cc = cc + 1
            ENDIF
         ENDIF
         IF (DATATYPE(load_wlexptable) EQ 'STC') THEN BEGIN
            cind = WHERE((os_num EQ load_wlexptable.os_num) AND (os_start EQ load_wlexptable.os_start))
            IF (cind(0) NE -1) THEN BEGIN
               wlexp_str = wlexp_str + tt + ','
               cc = cc + 1
            ENDIF
         ENDIF
         IF (DATATYPE(do_candc) EQ 'STC') THEN BEGIN
            cind = WHERE((os_num EQ do_candc.os_num) AND (os_start EQ do_candc.os_start))
            IF (cind(0) NE -1) THEN BEGIN
               candc_str = candc_str + tt + ','
               ccc = ccc + 1
            ENDIF
         ENDIF
         IF (DATATYPE(move_fp) EQ 'STC') THEN BEGIN
            cind = WHERE((os_num EQ move_fp.os_num) AND (os_start EQ move_fp.os_start))
            IF (cind(0) NE -1) THEN BEGIN
               movefp_str = movefp_str + tt + ','
               movefp_str2 = movefp_str2 + STRTRIM(move_fp(cind(0)).wl,2) + ','
               movefp_str3 = movefp_str3 + STRTRIM(move_fp(cind(0)).order,2) + ','
               c4 = c4 + 1
            ENDIF
         ENDIF
         c = c + 1
         IF ((c EQ 5) OR (j EQ (nsched-1))) THEN BEGIN	;** only 5 entries per line
            str = STRMID(str,0,STRLEN(str)-1) + ')'
            PRINTF, OUT, 'PT_LP_START = '+str
            c = 0
         ENDIF
      ENDFOR					;** for every start time for this os_num

      cam_str = STRMID(cam_str,0,STRLEN(cam_str)-1) + ')'
      IF (cam_str NE ')') THEN PRINTF, OUT, 'PT_LOAD_CAM = '+cam_str

      wlexp_str = STRMID(wlexp_str,0,STRLEN(wlexp_str)-1) + ')'
      IF (wlexp_str NE ')') THEN PRINTF, OUT, 'PT_LOAD_WLEXP = '+wlexp_str

      candc_str = STRMID(candc_str,0,STRLEN(candc_str)-1) + ')'
      IF (candc_str NE ')') THEN PRINTF, OUT, 'PT_DO_CANDC = '+candc_str

      movefp_str = STRMID(movefp_str,0,STRLEN(movefp_str)-1) + ')'
      IF (movefp_str NE ')') THEN PRINTF, OUT, 'PT_MOVE_FP = '+movefp_str

      movefp_str2 = STRMID(movefp_str2,0,STRLEN(movefp_str2)-1) + ')'
      IF (movefp_str2 NE ')') THEN PRINTF, OUT, 'PT_MOVE_FP_WL = '+movefp_str2

      movefp_str3 = STRMID(movefp_str3,0,STRLEN(movefp_str3)-1) + ')'
      IF (movefp_str3 NE ')') THEN PRINTF, OUT, 'PT_MOVE_FP_ORDER = '+movefp_str3

      tele = defined_os_arr(ind).tele
      fw = defined_os_arr(ind).fw
      pw = defined_os_arr(ind).pw
      sub = defined_os_arr(ind).sub
      start = defined_os_arr(ind).start
      table = defined_os_arr(ind).table
      iptable = defined_os_arr(ind).iptable
      lamp = defined_os_arr(ind).lamp
      num_images = defined_os_arr(ind).num_images
      ccd = defined_os_arr(ind).ccd
      ip = defined_os_arr(ind).ip
      ex = defined_os_arr(ind).ex
      occ_blocks = REFORM(defined_os_arr(ind).occ_blocks(tele,*))
      roi_blocks = REFORM(defined_os_arr(ind).roi_blocks(tele,*))
      fpwl = defined_os_arr(ind).fpwl
  
      IF (lp EQ 23) THEN BEGIN	;** CMD TABLE
         PRINTF, OUT, 'PT_START = '+STRTRIM(start,2)
         PRINTF, OUT, 'PT_STOP = '+STRTRIM(num_images,2)
         GOTO, CONT
      ENDIF

      PRINTF, OUT, 'PT_TELE = '+STRTRIM(tele,2)
      PRINTF, OUT, 'PT_DPT = '+STRTRIM(table+1,2)	;** cnvrt: LEB wants 1-3
      PRINTF, OUT, 'PT_FW = '+STRTRIM(fw,2)
      IF (lp EQ 8) THEN BEGIN		;** LP Take Sum
         PRINTF, OUT, 'PT_NSUM = '+STRTRIM(num_images,2)
      ENDIF
      IF (lp EQ 14) OR (lp EQ 11) THEN BEGIN	;** FP WL Scan, output wl/exp table instead of pw/exp pairs
         PRINTF, OUT, 'PT_PW = '+STRTRIM(pw(0),2)
         fpwl = REFORM(fpwl(table, fw, *))
         PRINTF, OUT, 'PT_NWAVE = '+STRTRIM(num_images,2)
         str = '('
         FOR n=start, start+num_images -1 DO $	;** for each wl/exp position
            str = str + STRTRIM(fpwl(n).wl,2) + '/' + STRTRIM(fpwl(n).exp,2) + '/' + STRTRIM(fpwl(n).order,2) + ','
         str = STRMID(str,0,STRLEN(str)-1) + ')'
         PRINTF, OUT, 'PT_WAVE = '+str
         IF (lp EQ 14) THEN PRINTF, OUT, 'PT_SUB = '+STRTRIM(sub,2)
         PRINTF, OUT, 'PT_START = '+STRTRIM(start,2)
      ENDIF ELSE BEGIN			;** output pw/exp pairs
         pwstr = '('
         expstr = '('
         IF (lp EQ 8) THEN num_images = 1		;** Take Sum LP
         FOR n=0, num_images -1 DO BEGIN	;** for each pw position
            pwstr = pwstr + STRTRIM(pw(n),2) + ','
            expstr = expstr + STRTRIM(ex(tele,table,fw,pw(n)),2) + ','
         ENDFOR
         pwstr = STRMID(pwstr,0,STRLEN(pwstr)-1) + ')'
         PRINTF, OUT, 'PT_PW = '+pwstr
         expstr = STRMID(expstr,0,STRLEN(expstr)-1) + ')'
         PRINTF, OUT, 'PT_EXPTIME = '+expstr
      ENDELSE
      CASE (tele) OF
         0 : lamp = 2
         1 : IF (lamp LT 2) THEN lamp = lamp+2   ; C2 options: door_lamp = 2 and shutter_lamp = 3
         2 : lamp = 3
         3 : lamp = 3
      ENDCASE
      PRINTF, OUT, 'PT_CAL_LAMP = '+STRTRIM(lamp,2)
      str = '('+STRTRIM(ccd(tele,table).y1,2)+','
      str = str+STRTRIM(ccd(tele,table).x1,2)+','
      str = str+STRTRIM(ccd(tele,table).y2,2)+','
      str = str+STRTRIM(ccd(tele,table).x2,2)+','
      str = str+STRTRIM(ccd(tele,table).ysum,2)+','
      str = str+STRTRIM(ccd(tele,table).xsum,2)+')'
      PRINTF, OUT, 'PT_CAM_RO = '+str
      str = '('+STRTRIM(ccd(tele,table).port,2)+','
      str = str+STRTRIM(FIX(ccd(tele,table).clr_spd),2)+','
      str = str+STRTRIM(ccd(tele,table).nclrs,2)+','
      str = str+STRTRIM(FIX(ccd(tele,table).hihtr),2)+','
      str = str+STRTRIM(ccd(tele,table).lowhtr,2)+','
      str = str+STRTRIM(ccd(tele,table).lpulse,2)+','
      str = str+STRTRIM(ccd(tele,table).fp_candc,2)+','
      str = str+STRTRIM(ccd(tele,table).leb_sum,2)+','
      str = str+STRTRIM(FIX(ccd(tele,table).side),2)+')'
      PRINTF, OUT, 'PT_CAM_OTH = '+str

      ;** print out the image processing table number 
      IF (lp EQ 8) THEN BEGIN		;** Take Sum requires 3 tables
        iptable0 = iptable
        iptable1 = defined_os_arr(ind).pw(1)
        iptable2 = defined_os_arr(ind).pw(2)
         PRINTF, OUT, 'PT_IP_TAB_NUM = ('+STRTRIM(iptable0,2)+','+STRTRIM(iptable1,2)+','+STRTRIM(iptable2,2)+')'
      ENDIF ELSE $
         PRINTF, OUT, 'PT_IP_TAB_NUM = '+STRTRIM(iptable,2)

      good = WHERE(ip(iptable).steps GE 0, nip)
      str = '('
      FOR n=0, nip-1 DO BEGIN
         str = str+STRTRIM(ip(iptable).steps(good(n)),2)+','
      ENDFOR
      PRINTF, OUT, 'PT_NIP = '+STRTRIM(nip,2)
      str = STRMID(str,0,STRLEN(str)-1) + ')'
      PRINTF, OUT, 'PT_IP = '+str

      ind = WHERE(ip(iptable).steps EQ 27)
      IF (ind(0) LT 0) THEN useocc = 1 ELSE useocc = 0
      ind = WHERE(ip(iptable).steps EQ 25)
      IF (ind(0) LT 0) THEN useroi = 0 ELSE useroi = 1

         IF (useocc EQ 1) THEN BEGIN		;** Occulter Mask
            blocks = occ_blocks
            p1 = 'PT_NOCC = '
            p2 = 'PT_OCC_MASK = '
            good = WHERE(blocks GE 1, nb)
            PRINTF, OUT, p1+STRTRIM(nb,2)
            runs = FIND_DATA_RUNS(INDGEN(1024),blocks,0,0,1)
            c = 0 	;** counter, only 5 entries per line
            pairs = (N_ELEMENTS(runs)/2)
            FOR p=0, pairs-1 DO BEGIN
               IF (c EQ 0) THEN str = '('				;** new line
               IF (runs(p,0) EQ runs(p,1)) THEN $			;** ex. use 39, instead of 39-39,
                  str = str + STRTRIM(runs(p,0),2) + ',' $
               ELSE $
                  str = str + STRTRIM(runs(p,0),2) + '-' + STRTRIM(runs(p,1),2) + ','
               c = c + 1
               IF ((c EQ 5) OR (p EQ (pairs-1))) THEN BEGIN	;** only 5 entries per line
                  str = STRMID(str,0,STRLEN(str)-1) + ')'
                  PRINTF, OUT, p2+str
                  c = 0
               ENDIF
            ENDFOR		;** for each pair
         ENDIF
         IF (useroi EQ 1) THEN BEGIN		;** ROI Mask
            blocks = roi_blocks
            p1 = 'PT_NROI = '
            p2 = 'PT_ROI_MASK = '
            good = WHERE(blocks GE 1, nb)
            PRINTF, OUT, p1+STRTRIM(nb,2)
            runs = FIND_DATA_RUNS(INDGEN(1024),blocks,0,0,1)
            c = 0 	;** counter, only 5 entries per line
            pairs = (N_ELEMENTS(runs)/2)
            FOR p=0, pairs-1 DO BEGIN
               IF (c EQ 0) THEN str = '('				;** new line
               IF (runs(p,0) EQ runs(p,1)) THEN $			;** ex. use 39, instead of 39-39,
                  str = str + STRTRIM(runs(p,0),2) + ',' $
               ELSE $
                  str = str + STRTRIM(runs(p,0),2) + '-' + STRTRIM(runs(p,1),2) + ','
               c = c + 1
               IF ((c EQ 5) OR (p EQ (pairs-1))) THEN BEGIN	;** only 5 entries per line
                  str = STRMID(str,0,STRLEN(str)-1) + ')'
                  PRINTF, OUT, p2+str
                  c = 0
               ENDIF
            ENDFOR		;** for each pair
         ENDIF

CONT:

      os_size = first_os.os_size
      os_duration = first_os.os_duration
      PRINTF, OUT, 'PT_OS_SIZE = '+STRTRIM(os_size,2)
      PRINTF, OUT, 'PT_OS_DUR = '+STRTRIM(os_duration,2)
      PRINTF, OUT, ';' & PRINTF, OUT, ';'

;   CLOSE, OUT
;   FREE_LUN, OUT
   ENDFOR		;** for every unique os_num

   CLOSE, OUT
   FREE_LUN, OUT
   PRINT,'%%%GENERATE_IPT: Done.'

END


