;input: index, which pw for SEQ PW
;input: OS_INSTANCE structure (ex: from defined_os_arr)
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;output: obs_mode - structure containing  observing mode
;** Structure OBSERVING_MODES, 11 tags, length=68:
;   DB_NAME         STRING    'lasco'
;   TABLE_NAME      STRING    'observing_modes'
;   DATE_MOD        STRING    ''
;   TELESCOPE       INT              0
;   TEL_STATE_STR   STRING    ''
;   CAM_STATE_STR   STRING    ''
;   COMPRESSION_STR STRING    ''
;   AVG_PROC_TIME   FLOAT           0.00000
;   AVG_COMP_FACTOR FLOAT           0.00000
;   AVG_BITS_PIXEL  FLOAT           0.00000
;   NUM_IMAGES      LONG                 0
;
;

FUNCTION GET_OBSERVING_MODE, os, index, DOORCLOSED=doorclosed

COMMON DBMODES_COMMON, dbmodes

   obs_mode = GET_DB_STRUCT('lasco', 'observing_modes')

   ;**
   ;** READ IN STATISTICS DATA FROM DATABASE SAVESET
   ;**
   IF (DATATYPE(dbmodes) NE 'STC') THEN BEGIN
      RESTORE, 'dbmodes.dat'
   ENDIF

   ;**
   ;** FILL IN OBSERVING_MODE STRUCTURE
   ;**

   obs_mode.telescope = os.tele

   ;**
   ;** build up telescope state string
   ;**
   shutter = OS_GET_SHUTTER(os)
   lamp = 0
   IF (os.lp EQ 3) THEN BEGIN
      CASE (os.tele) OF
         0 : lamp = 2
         1 : lamp = os.lamp+2
         2 : lamp = 3
         3 : lamp = 3
      ENDCASE
   ENDIF
   IF ((os.lp EQ 2) AND (os.tele EQ 3)) THEN BEGIN	;** for eit dark
      fw = 2
      pw = 2
   ENDIF ELSE BEGIN
      fw = os.fw
      pw = os.pw
   ENDELSE

   IF (KEYWORD_SET(DOORCLOSED)) THEN door = 2 ELSE door = 0

   obs_mode.tel_state_str = STRTRIM(shutter,2) + $
                            STRTRIM(fw,2) + $
                            STRTRIM(pw(index),2) + $
                            STRTRIM(door,2) + $
                            STRTRIM(lamp,2)

help, lamp

   ;**
   ;** build up camera state string
   ;**
   obs_mode.cam_state_str = STRTRIM(STRING(os.ccd(os.tele,os.table).ysum,FORMAT='(I4.4)'),2) + $
                            STRTRIM(STRING(os.ccd(os.tele,os.table).xsum,FORMAT='(I4.4)'),2) + $
                            STRTRIM(STRING(os.ccd(os.tele,os.table).clr_spd,FORMAT='(I1.1)'),2) + $
                            STRTRIM(STRING(os.ccd(os.tele,os.table).nclrs,FORMAT='(I2.2)'),2) + $
                            '1' + $    ;** Dump Speed
                            STRTRIM(STRING(os.ccd(os.tele,os.table).port,FORMAT='(I1.1)'),2)


   ;**
   ;** build up compression string
   ;**
   comp_str = GET_COMP_STR(os)
   obs_mode.compression_str = comp_str

   ;**
   ;** QUERY DATABASE TO GET STATISTICS
   ;**
   ind = WHERE( (obs_mode.telescope EQ dbmodes.telescope) AND $
             (obs_mode.tel_state_str EQ dbmodes.tel_state_str) AND $
             (obs_mode.cam_state_str EQ dbmodes.cam_state_str) AND $
             (obs_mode.compression_str EQ dbmodes.compression_str) )

   IF (ind(0) GE 0) THEN BEGIN
      obs_mode.avg_proc_time = dbmodes(ind(0)).avg_proc_time
      obs_mode.avg_bits_pixel = dbmodes(ind(0)).avg_bits_pixel
      obs_mode.avg_comp_factor = dbmodes(ind(0)).avg_comp_factor
      obs_mode.num_images = dbmodes(ind(0)).num_images
   ENDIF ELSE BEGIN
      PRINT, '%%get_observing_mode: no statistics found.'
   ENDELSE

   RETURN, obs_mode

END
