;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : GET_OP_NUM()
;               
; Purpose     : Get the next unique Observation Program number.
;               
; Explanation : The OP_NUM counter is stored in the saved dataset
;		'op_num.dat'.  This routine simply reads in the last
;		allocated op_num and adds one to it.
;               
; Use         : op_num = GET_OP_NUM()
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : op_num	The next unique Observation Program number.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;               
; Restrictions: The saveset file 'op_num.dat' must exist in the current
;		directory and have write permission by the user.
;               
; Side effects: The saveset file 'op_num.dat' will be written over with
;		the allocated number.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
FUNCTION GET_OP_NUM

   RESTORE, 'op_num.dat'

   op_num = op_num + 1

   SAVE, op_num, FILENAME='op_num.dat'

   RETURN, op_num

END
