PRO INPUT_WL_ORDER_EVENT, ev

COMMON INPUT_WL_ORDER_COMMON, wl_s, order_s

WIDGET_CONTROL, ev.top, GET_UVALUE=fpv   ; get structure from UVALUE

    WIDGET_CONTROL, ev.id, GET_UVALUE=input

    CASE (input) OF

	'CANCEL' : BEGIN
                 wl_s = -1
                 order_s = -1
	         WIDGET_CONTROL, /DESTROY, fpv.base
                 RETURN
	     END

	'APPLY' : BEGIN
                 wl_s = fpv.wl
                 order_s = fpv.order
	         WIDGET_CONTROL, /DESTROY, fpv.base
                 RETURN
	     END

        'REMOVE' : BEGIN		;bytscl min
                 wl_s = 0
                 order_s = 0
	         WIDGET_CONTROL, /DESTROY, fpv.base
                 RETURN
	    END

	'ON' : BEGIN
                 wl = fpv.wl_arr(fpv.fw,0).wl
                 order = fpv.wl_arr(fpv.fw,0).order
                 fpv.wl = wl
                 fpv.order = order
	         WIDGET_CONTROL, fpv.wlt, SET_VALUE=STRTRIM(fpv.wl,2)
	         WIDGET_CONTROL, fpv.ordert, SET_VALUE=STRTRIM(fpv.order,2)
	    END

	'OFF' : BEGIN
                 wl = fpv.wl_arr(fpv.fw,1).wl
                 order = fpv.wl_arr(fpv.fw,1).order
                 fpv.wl = wl
                 fpv.order = order
	         WIDGET_CONTROL, fpv.wlt, SET_VALUE=STRTRIM(fpv.wl,2)
	         WIDGET_CONTROL, fpv.ordert, SET_VALUE=STRTRIM(fpv.order,2)
	    END

	'WL' : BEGIN 	;unsharp box size
	         WIDGET_CONTROL, fpv.wlt, GET_VALUE=wl
                 wl = DOUBLE(wl(0))
                 fpv.wl = wl
	    END

	'ORDER' : BEGIN 	;unsharp box size
	         WIDGET_CONTROL, fpv.ordert, GET_VALUE=order
                 order = DOUBLE(order(0))
                 fpv.order = order
	    END

	ELSE : BEGIN
                 PRINT, '%%Unknown event.'
	     END

    ENDCASE

  WIDGET_CONTROL, ev.top, SET_UVALUE=fpv

END



PRO INPUT_WL_ORDER, fw, wl_out, order_out, ONLINE=online

COMMON INPUT_WL_ORDER_COMMON, wl_s, order_s

   wl_stc = {wl_stc, wl:0.0D, order:0}
   wl_arr = REPLICATE(wl_stc,5,2)			;** 5 filters, on/off
   wl_arr(0,0).wl = 5695.2982D & wl_arr(0,1).wl = 5698.0396D & wl_arr(0,*).order = 120	;** CaXV
   wl_arr(1,0).wl = 6376.4418D & wl_arr(1,1).wl = 6380.9556D & wl_arr(1,*).order = 107	;** FeX
   wl_arr(2,0).wl = 6565.3908D & wl_arr(2,1).wl = 6569.5461D & wl_arr(2,*).order = 104	;** Orange
   wl_arr(3,0).wl = 5891.1339D & wl_arr(3,1).wl = 5886.6170D & wl_arr(3,*).order = 116	;** NaI
   wl_arr(4,0).wl = 5302.4222D & wl_arr(4,1).wl = 5309.2365D & wl_arr(4,*).order = 129	;** FeXIV

   IF (DATATYPE(wl_out) NE 'UND') THEN BEGIN
      wl = wl_out
      order = order_out
   ENDIF ELSE BEGIN
      wl = wl_arr(fw,0).wl
      order = wl_arr(fw,0).order
   ENDELSE

   wl_s = wl
   order_s = order
   IF KEYWORD_SET(ONLINE) THEN BEGIN
      wl_out = wl_s
      order_out = order_s
      RETURN
   ENDIF
;**--------------------Create Widgets-------------------------------**
   base = WIDGET_BASE(/COL, XOFFSET=275, YOFFSET=275, TITLE='SET FP WAVELENGTH')
   rowb = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_BUTTON(rowb, VALUE='Line Center', UVALUE='ON')
      tmp = WIDGET_BUTTON(rowb, VALUE=' Continuum ', UVALUE='OFF')
   rowb = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(rowb, VALUE='Wavelength')
      wlt = WIDGET_TEXT(rowb, VALUE=STRTRIM(wl,2), XSIZE=9, YSIZE=1, UVALUE='WL', /EDITABLE)
   rowb = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(rowb, VALUE='     Order')
      ordert = WIDGET_TEXT(rowb, VALUE=STRTRIM(order,2), XSIZE=5, YSIZE=1, UVALUE='ORDER', /EDITABLE)

   done = WIDGET_BUTTON(base, VALUE='   APPLY    ', UVALUE='APPLY')
   done = WIDGET_BUTTON(base, VALUE='REMOVE MARK ', UVALUE='REMOVE')
   done = WIDGET_BUTTON(base, VALUE='   CANCEL   ', UVALUE='CANCEL')

;**--------------------Done Creating Widgets-----------------------------**

   WIDGET_CONTROL, /REAL, base

   fpv = { $
 		base:base, $ 
 		fw:fw, $ 
 		wl:wl, $ 
 		order:order, $ 
 		wlt:wlt, $ 
 		ordert:ordert, $ 
 		wl_arr:wl_arr $ 
            }

   WIDGET_CONTROL, base, SET_UVALUE=fpv


   XMANAGER, 'INPUT_WL_ORDER', base, EVENT_HANDLER='INPUT_WL_ORDER_EVENT', /MODAL

   wl_out = wl_s
   order_out = order_s

END
