;** Define structures used when reading in KAP file (ECS Keyword
;** input to the Activity Plan) for LASCO Planning Purposes
;**
;** kap_nrt_reserved
;** kap_resource
;**
;** the following are not implemented
;**
;** kap_sci_plan
;** kap_program 
;** kap_activity
;** kap_other_obs
;**
;** kap_iie
;** kap_nrt_session 
;** kap_delayed_cmd 
;** kap_tstol_execution 

PRO KAP_INIT

COMMON KAP_INIT

kap_file_name = ''

kap_nrt_reserved = {kap_nrt_reserved,	$
                    startime:	0D,	$	;** TAI
                    endtime:	0D,	$	;** TAI
                    instrume:	'',	$	;** L, E, C, S, M, ...
                    cmd_rate:	0,	$	;** cmds/minute
                    status:	''      }	;** acceptance status from ECS: Requested,Confirmed,Denied

kap_resource = {kap_resource,		$
                id:		0B,	$
		startime:	0D, 	$	;** TAI
		endtime:	0D, 	$	;** TAI
		type:		0	}
;**
;** 			name			endtime?	type
;**
kap_resource_names = [  		$
                        'TLM_MODE',	$;	  N/A		0:IDLE, 1:LR, 2:MR, 3:HR
                        'TLM_SUBMODE',	$;	  N/A		0:?   , 1:MODE 1, 2:MODE 2, 3:MODE 3, 4:MODE 4
                        'TLM_MDI',	$;			0:Magnetogram, 1:H
                        'TLM_HR_IDLE',	$;			N/A
                        'TLM_TAPE_DUMP',$;			N/A
                        'CLOCK_ADJUST',	$;	  N/A		index in description table
                        'SPACECRAFT_MANEUVER',$;		index in description table
                        'THROUGHPUT',	$;			0:No RCR, 1:RCR Allowed
                        'RESERVED',	$;			0:SVM Reserved, 1:Payload Reserved
                        'DSN_CONTACT'	$;			0:?, 1:CAN, 2:MAD, 3:GDS 
                     ]
kap_dsn_names = ['?','CAN','MAD','GDS']
kap_tlm_mode_names = ['IDLE','LR','MR','HR']


kap_iie = {iie,	$
           type:	0,	$	;** 1: Master
           startime:	0D,	$	;** TAI
           endtime:	0D,	$	;** TAI
           instrume:	'',	$	;** L, E, C, S, M, ...
           status:	''      }	;** acceptance status from ECS: Requested,Confirmed,Denied


END
