; converts '(0-10,35,40-45,60-70)' to a bytarr(32*32) with
; input indices set to 1
;
FUNCTION MASK_RUNS2ARR, data_str

   mask = BYTARR(32*32)

   ;** clip off "(" and ")" and convert to string array
   arr = STR2ARR(STRMID(data_str,1,STRLEN(data_str)-2),DELIM=',')

   IF (arr(0) EQ '-1') THEN BEGIN
      PRINT, '%%MASK_RUNS2ARR: Warning. Empty mask table'
      RETURN, mask
   ENDIF

   FOR i=0, N_ELEMENTS(arr)-1 DO BEGIN
      loc = STRPOS(arr(i), '-')
      IF (loc GE 0) THEN BEGIN		;** entry is 'x1-x2'
         x1 = FIX(STRMID(arr(i),0,loc))
         x2 = FIX(STRMID(arr(i),loc+1,STRLEN(arr(i))-loc)) > x1
         IF ( (x1 GE 0) AND (x1 LE 1023) AND (x2 GE 0) AND (x2 LE 1023) ) THEN mask(x1:x2) = 1
      ENDIF ELSE BEGIN			;** entry is 'x1'
         x1 = FIX(arr(i))
         IF ( (x1 GE 0) AND (x1 LE 1023) ) THEN mask(x1) = 1
      ENDELSE
   ENDFOR

   RETURN, mask
END
