;** convert ip steps from intarr of OBE numbers to planning tool structure
FUNCTION CONVOBE2IP, obeip

      ;** convert IP to what OBE expects
      ;  0 = No op (signals end of sequence)
      ;  1 = Bad Column Averaging
      ;  2 = Inter Min
      ;  3 = Shift Right 1 Bit (divide by 2)
      ;  4 = Intra Sum (Pixel summing)
      ;  5 = Radial Spoke
      ;  6 = Square Root
      ;  7 = Pyramid (Super Pixels for Transient Detect)
      ;  8 = Inter Sum
      ;  9 = Inter Diff (fixed base)
      ;  10 = Inter Diff (moving base)
      ;  11 = No Compression
      ;  12 = Rice (lossless compression)
      ;  13 = ADCT (lossy compression)
      ;  14 = DCMP (lossy compression)
      ;  15 = Camera and line sync strip
      ;  16 = inter-instrument bright pixel search
      ;  17 = inter-instrument delta pixel search
      ;  18 = Not in Use
      ;  19 = Reserved for Debugging
      ;  20 = Transmit Header Only
      ;  21 = Debug Image 0 - Linear Gradient - occulter off
      ;  22 = Debug Image 1 - Inverse Radial Gradient- occulter off
      ;  23 = Debug Image 2 - Radial Gradient - 2 DN - occulter off
      ;  24 = Debug Image 3 - Radial Gradient - 256 DN - occulter on
      ;  25 = Use Image Mask Table
      ;  26 = Do Not Use Image Mask Table
      ;  27 = Do Not Use Occulter Mask (default = use Occulter mask)
      ;  28 = Debug Image 4   - full Scale Linear Grad
      ;  29 = Invert is_masked[] table when masking image
      ;  30 = Do not invert is_masked[] table when masking image
      ;  31 = Transmit Transient Detect Array
      ;  32 = Reset Science Circular Buffer 
      conv2obe = [1,2,3,4,5,6,7,8,9,10,15,16,17,18,19,20,21,22,23,24,28,31,32]

      good = WHERE(ip(iptable).steps GE 0, nip)
      str = '('
      FOR n=0, nip-1 DO BEGIN
         str = str+STRTRIM(conv2obe(ip(iptable).steps(good(n))),2)+','
      ENDFOR
      CASE (ip(iptable).mask) OF
         0 : BEGIN			;** No Masking
                str = str+'27,'
                nip = nip + 1
             END
         1 : 				;** Occulter Masking
         2 : BEGIN			;** ROI Masking
                str = str+'25,27,'
                nip = nip + 2
             END
         ELSE : PRINT,'%%%GENERATE_IPT: Unknown mask type: '+STRN(ip(iptable).mask)
      ENDCASE

      ;** convert compression to what obe expects
      nip = nip + 1	;** add 1 step for compression
      conv2obe = [11,12,14,13]
      str = str+STRTRIM(conv2obe(ip(iptable).comp),2)+')'

      PRINTF, OUT, 'PT_NIP = '+STRTRIM(nip,2)
      PRINTF, OUT, 'PT_IP = '+str

END
