;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : FAKE_OP
;               
; Purpose     : Define some sample Observation Programs for LASCO/EIT Schedule.
;               
; Explanation : This routine defines the defined_op_arr, op_arr, and
;		op_id_arr Observation Program arrays either from scratch
;		or from the saved dataset 'op_arr.dat'.  In the future
;		this routine may be replaced by a better implementation
;		such as one that reads from a database.
;               
; Use         : FAKE_OP, startdis
;    
; Inputs      : startdis	input start of display time in TAI.
;               
; Opt. Inputs : None.
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : TAI2UTC, UTC2TAI
;
; Called from : SCHEDULE.PRO
;
; Common      : OP_DEFINED, op_instance, defined_op_arr
;               OP_SCHEDULED, op_struct, op_arr
;               OBS_PROG_DEF, op_id_struct, op_id_arr
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
PRO FAKE_OP, startdis

COMMON OP_DEFINED, op_instance, defined_op_arr
COMMON OP_SCHEDULED, op_struct, op_arr
COMMON OBS_PROG_DEF, op_id_struct, op_id_arr


   op_id_struct = {op_id_struct, op_id:0L, op_id_name:'', op_id_desc:''}

   op_instance = {op_instance, num:0L, id:0L, camp_num:0L, instrument:'', sci_obj:'', object:'', $
                  comment:'', date_modified:0.0D}
   op_struct = {op_struct, num:0L, op_start:0.0D, op_stop:0.0D}

;   TEXT = ['SYNOPTIC STUDIES ' + '(WL & EMISSION LINES)', $
;          'STREAMER (CME WAIT & SEE)',     $
;          'FULL CORONA', $
;          'POLAR CORONAL HOLE BORDERS',    $
;          'SYNOPTIC STUDIES',	$
;          'JOP 006',	$
;          'CORONAL EVOLUTION']
;   op_id_arr = REPLICATE(op_id_struct,N_ELEMENTS(text))
;   op_id_arr.op_id = INDGEN(N_ELEMENTS(text))
;   op_id_arr.op_id_name = text
   RESTORE, 'op_id_arr.dat'

   RESTORE, 'op_arr.dat'
goto, cont2
   ;** change day to startdis
   datastart = TAI2UTC(startdis)             ; form .DAY and .TIME
   thisstart = TAI2UTC(op_arr.op_start)      ; form .DAY and .TIME
   thisstop = TAI2UTC(op_arr.op_stop)      ; form .DAY and .TIME
   daydiff = datastart.mjd - thisstart.mjd
   thisstart.mjd = thisstart.mjd + daydiff
   thisstop.mjd = thisstop.mjd + daydiff
   op_arr.op_start = UTC2TAI(thisstart)                ; start of STARTDIS in TAI
   op_arr.op_stop = UTC2TAI(thisstop)

   GOTO, CONT2

CONT:



   datastart = TAI2UTC(startdis)                ; form .DAY and .TIME
   datastart.time = 0                           ; only want day part
   daystart = UTC2TAI(datastart)                ; start of STARTDIS in TAI

  start_arr = [0,3,6, 7,10,15,20]       ; study start hrs from start of STARTDIS day
  stop_arr  = [3,6,7,10,15,20,25]      	; study stop hrs from start of STARTDIS day
  op_nums   = [100,101,102, 103, 104,105, 106]	;** this is unique
  op_ids    = [0,1,2, 0, 1,3,  4]	;** this is index into op_id_arr 
  camp_nums = [0,9,9, 0, 9,15, 0]
  instrument = 'LASCO'
  sci_obj = 'The scientific objective would go here.'
  comment = 'Any comments would go here.'

op_arr = REPLICATE(op_struct, n_elements(start_arr))
defined_op_arr = REPLICATE(op_instance, n_elements(start_arr))

  defined_op_arr.num=op_nums
  defined_op_arr.id=op_ids 
  defined_op_arr.camp_num=camp_nums 
  defined_op_arr.instrument=instrument
  defined_op_arr.sci_obj=sci_obj
  defined_op_arr.comment=comment
  get_utc, stime                    ; get system time
  defined_op_arr.date_modified=utc2tai(stime)         ; seconds since 1 jan 1958 (TAI)

  op_arr.num=op_nums 
  op_arr.op_start=(start_arr*3600D) +daystart
  op_arr.op_stop=(stop_arr*3600D)+daystart

CONT2:

END
