FUNCTION FILL_IN_LP, lp_num, key_val_arr, used


   ccdvars = {ccdvars, x1:0, x2:0, y1:0, y2:0, xsum:0, ysum:0, clr_spd:0B, nclrs:0, lpulse:0,       $
                       port:0, leb_sum:0, fp_candc:0, hihtr:0B, lowhtr:0, side:0B}


   CASE (lp_num) OF

      ;** Take Dark
      5 : BEGIN
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   exptime:	-1,		$
                   ccd:		ccdvars,	$
                   ip_tab_num:	-1,		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_EXPTIME' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.exptime = FIX(val)
             used(index) = 1

          END	;** Take Dark

      ;** Take FP Scan Line
      8 : BEGIN
             key = 'PT_WAVE' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             wl_exp = STR2ARR(STRMID(val, 1, STRLEN(val)-2), DELIM=',')
             num_wl = N_ELEMENTS(wl_exp)
             wl = DBLARR(num_wl)
             expt = INTARR(num_wl)
             order = INTARR(num_wl)
             FOR i=0, num_wl-1 DO BEGIN
                wl_exp1 = STR2ARR(wl_exp(i), DELIM='/')
                wl(i) = DOUBLE(wl_exp1(0))
                expt(i) = FIX(wl_exp1(1))
                IF (N_ELEMENTS(wl_exp1) EQ 3) THEN order(i) = FIX(wl_exp1(2))
             ENDFOR
             used(index) = 1
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   fw:		-1,		$
                   pw:		-1,		$
                   sub_regions:	-1,		$
                   wavelength:	DBLARR(num_wl)-1,	$
                   exptime:	INTARR(num_wl)-1,	$
                   order:	INTARR(num_wl)-1,	$
                   ccd:		ccdvars,	$
                   ip_tab_num:	-1,		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_FW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.fw = FIX(val)
             used(index) = 1
             key = 'PT_PW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.pw = FIX(val)
             used(index) = 1
             key = 'PT_SUB_REGIONS' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN BEGIN
                ;PRINT, '%%%FILL_IN_LP: PT_SUB_REGIONS Undefined.  Assuming 0.'
                lp.sub_regions = 0
             ENDIF ELSE BEGIN
                lp.sub_regions = FIX(val)
                used(index) = 1
             ENDELSE
             lp.wavelength = wl
             lp.exptime = expt
             lp.order = order

          END	;** Take FP Scan Line

      ;** Take Normal
      9 : BEGIN
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   fw:		-1,		$
                   pw:		-1,		$
                   exptime:	-1,		$
                   ccd:		ccdvars,	$
                   ip_tab_num:	-1,		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_FW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.fw = FIX(val)
             used(index) = 1
             key = 'PT_PW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.pw = FIX(val)
             used(index) = 1
             key = 'PT_EXPTIME' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.exptime = FIX(val)
             used(index) = 1

          END	;** Take Normal

      ;** Take Polarization Sequence
      14 : BEGIN
             key = 'PT_PW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             pw = FIX(STR2ARR(val,DELIM=','))
             num_pw = N_ELEMENTS(pw)
             used(index) = 1
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   fw:		-1,		$
                   pw:		INTARR(num_pw)-1,		$
                   exptime:	INTARR(num_pw)-1,		$
                   ccd:		ccdvars,	$
                   ip_tab_num:	-1,		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_FW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.fw = FIX(val)
             used(index) = 1
             lp.pw = pw
             key = 'PT_EXPTIME' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             exptime = FIX(STR2ARR(val,DELIM=','))
             num_exp = N_ELEMENTS(exptime)
             IF (num_exp NE num_pw) THEN BEGIN
                PRINT, '%%%FILL_IN_LP: N_ELEMENTS(pw) '+STRN(num_pw)+' NE N_ELEMENTS(exptime) '+ $
		   STRN(num_exp)+'.  Fatal Error.'
                RETURN, -1
             ENDIF
             lp.exptime = exptime
             used(index) = 1

          END	;** Take Polarization Sequence

      ;** Take Cal Lamp
      17 : BEGIN
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   fw:		-1,		$
                   pw:		-1,		$
                   exptime:	-1,		$
                   lamp:	-1,		$
                   ccd:		ccdvars,	$
                   ip_tab_num:	-1,		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_FW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.fw = FIX(val)
             used(index) = 1
             key = 'PT_PW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.pw = FIX(val)
             used(index) = 1
             key = 'PT_EXPTIME' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.exptime = FIX(val)
             used(index) = 1
             key = 'PT_CAL_LAMP' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.lamp = FIX(val)
             used(index) = 1

          END	;** Take Cal Lamp

      ;** Take SUM
      19 : BEGIN
             lp = {tele:	-1,		$
                   dpt:		-1,		$
                   fw:		-1,		$
                   pw:		-1,		$
                   exptime:	-1,		$
                   num:		-1,		$
                   ccd:		ccdvars,	$
                   ip_tab_num:	[-1,-1,-1],		$
                   ip:		INTARR(19)-1,	$
                   occ:		BYTARR(32*32),	$
                   roi:		BYTARR(32*32)	$
                  }
             key = 'PT_FW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.fw = FIX(val)
             used(index) = 1
             key = 'PT_PW' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.pw = FIX(val)
             used(index) = 1
             key = 'PT_EXPTIME' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
             lp.exptime = FIX(val)
             used(index) = 1
             key = 'PT_NSUM' & val = KEYWORD_VALUE(key_val_arr, key, index)
             IF (val EQ '') THEN GOTO, FATAL_ERROR
             lp.num = FIX(val)
             used(index) = 1

          END	;** Take Sum

      ELSE : BEGIN
             PRINT, '%%%FILL_IN_LP: Unknown LP: '+STRN(lp_num)
             RETURN, -1
          END

   ENDCASE

   ;** these are common for all LPs except TAKE_SEQ and TAKE_CONCURRENT
   key = 'PT_TELE' & val = KEYWORD_VALUE(key_val_arr, key, index)
   IF (val EQ '') THEN GOTO, FATAL_ERROR
   lp.tele = FIX(val)
   used(index) = 1
   key = 'PT_DPT' & val = KEYWORD_VALUE(key_val_arr, key, index)
   IF (val EQ '') THEN GOTO, FATAL_ERROR
   lp.dpt = FIX(val)
   used(index) = 1
   key = 'PT_CAM_RO' & ccd1 = KEYWORD_VALUE(key_val_arr, key, index)
   IF (ccd1 EQ '') THEN GOTO, FATAL_ERROR
   used(index) = 1
   key = 'PT_CAM_OTH' & ccd2 = KEYWORD_VALUE(key_val_arr, key, index)
   IF (ccd2 EQ '') THEN GOTO, FATAL_ERROR
   used(index) = 1
   lp.ccd = FILL_IN_CCD(ccdvars, ccd1, ccd2)

   key = 'PT_IP_TAB_NUM' & val = KEYWORD_VALUE(key_val_arr, key, index)
   IF (val EQ '') THEN GOTO, FATAL_ERROR
   IF (lp_num EQ 19) THEN BEGIN	;** TAKE SUM requires 3 ip tables
      IF (STRMID(val,0,1) EQ '(') THEN val = STRMID(val,1,STRLEN(val)-2)
      val = FIX(STR2ARR(val,DELIM=','))
   ENDIF
   lp.ip_tab_num = FIX(val)
   used(index) = 1

   key = 'PT_IP' & ip = KEYWORD_VALUE(key_val_arr, key, index)
   IF (ip EQ '') THEN GOTO, FATAL_ERROR
   used(index) = 1
   ip = FIX(STR2ARR(STRMID(ip,1,STRLEN(ip)-2),DELIM=','))
   lp.ip(0:N_ELEMENTS(ip)-1) = ip
   key = 'PT_OCC_MASK' & val = KEYWORD_VALUE(key_val_arr, key, index, /GET_ALL)
   IF (val NE '') THEN BEGIN
      used(index) = 1
      lp.occ = MASK_RUNS2ARR(val)
   ENDIF
   key = 'PT_ROI_MASK' & val = KEYWORD_VALUE(key_val_arr, key, index, /GET_ALL)
   IF (val NE '') THEN BEGIN
      used(index) = 1
      lp.roi = MASK_RUNS2ARR(val)
   ENDIF

   RETURN, lp

   FATAL_ERROR:
      PRINT, '%%%FILL_IN_LP: '+key+' undefined.  Fatal Error.'
      RETURN, -1
END
