FUNCTION FILL_IN_OS, key_val_arr, used


   nsched = KEYWORD_VALUE(key_val_arr, 'PT_LP_NSCHED', index)
   IF (nsched EQ '') THEN BEGIN
      PRINT, '%%%FILL_IN_OS: PT_LP_NSCHED undefined, assuming 1.'
      nsched = 1
   ENDIF ELSE BEGIN
      nsched = FIX(nsched)
      used(index) = 1
   ENDELSE

   utc = {cds_int_time, mjd:0L, time:0L}

   os = {os_num:	-1L,	$
         op_num:	-1L,	$
         op_id_name:	'',	$
         date_gen:	'',	$
         os_obj:	'',	$
         lp_num:	-1,	$
         lp_exit:	-1,	$
         lp_iter:	-1,	$
         lp_dur:	-1,	$
         os_size:	 0L,	$
         os_dur:	0.0,	$
         lp_nsched:	nsched,	$
         lp_start:	REPLICATE(utc,nsched),	$
         lp_load_cam:	BYTARR(nsched),	$		;** 1 means do it
         lp_load_wlexp:	BYTARR(nsched),	$		;** 1 means do it
         lp_do_candc:	BYTARR(nsched),	$		;** 1 means do it
         lp_move_fp_wl:	DBLARR(nsched),	$		;** wavelength
         lp_move_fp_order:INTARR(nsched),	$	;** order
         lp_end:	REPLICATE(utc,nsched) 	$
        }

   os_tags = TAG_NAMES(os)
   get_num = 10		;** only want the first n (os_num thru os_dur)
   fatal = [0,0,0,0,0,1,1,0,0,0,0]
   get_vars = 'PT_' + os_tags(0:get_num)

   FOR i=0, get_num DO BEGIN

      val = KEYWORD_VALUE(key_val_arr, get_vars(i), index)

      IF (val EQ '') THEN BEGIN	;** undefined
         IF (fatal(i)) THEN BEGIN
            PRINT, '%%%FILL_IN_OS: '+get_vars(i)+' must be defined.  Fatal Error'
            RETURN, -1
         ENDIF

      ENDIF ELSE BEGIN
         IF ( (get_vars(i) EQ 'PT_OS_NUM') AND (STRMID(val,0,1) EQ 'T') ) THEN $
            val = 0
            ;val = FIX(STRMID(val, 1, STRLEN(val)-1))   ;** clip off leading "T"
	    ;** need to allocate official number from database here
         t = DATATYPE(os.(i))
         CASE (t) OF
            'INT' : val = FIX(val)
            'LON' : val = LONG(val)
            'STR' : val = val
            'FLO' : val = FLOAT(val)
            ELSE : BEGIN
                  PRINT, '%%%FILL_IN_OS: Undefined datatype: '+t
                  RETURN, -1
               END
         ENDCASE
         os.(i) = val
         used(index) = 1
      ENDELSE

   ENDFOR

   ;** parse through start times
   start = KEYWORD_VALUE(key_val_arr, 'PT_LP_START', index, /GET_ALL)
   IF (start EQ '') THEN BEGIN
      PRINT, '%%%FILL_IN_OS: PT_LP_START undefined.  Fatal Error.'
      RETURN, -1
   ENDIF ELSE BEGIN
      start_utc = PTDATE2UTC(start)
      IF (os.lp_nsched NE N_ELEMENTS(start_utc)) THEN BEGIN
         PRINT, '%%%FILL_IN_OS: PT_LP_NSCHED: '+STRN(os.lp_nsched)+' not equal N_ELEMENTS(PT_LP_START)'+ $
            STRN(N_ELEMENTS(start_utc))
         IF (os.lp_nsched GT N_ELEMENTS(start_utc)) THEN BEGIN
            PRINT, '%%%FILL_IN_OS: Fatal Error.'
            RETURN, -1
         ENDIF
         PRINT, '%%%FILL_IN_OS: Only using first '+STRN(os.lp_nsched)+' elements of PT_LP_START.'
         start_utc = start_utc(0:os.lp_nsched-1)
      ENDIF
      os.lp_start = start_utc
      used(index) = 1
   ENDELSE

   ;** parse through to see if any need cam table updates
   start = KEYWORD_VALUE(key_val_arr, 'PT_LOAD_CAM', index, /GET_ALL)
   IF (start NE '') THEN BEGIN
      used(index) = 1
      start_cam = UTC2TAI(PTDATE2UTC(start))
      start_tai = UTC2TAI(start_utc)
      FOR s=0, N_ELEMENTS(start_cam)-1 DO BEGIN
         ind = WHERE(start_cam(s) EQ start_tai)
         IF (ind(0) EQ -1) THEN $
            PRINT, 'ERROR camera table load time does not correspond to any OS start time' $ 
         ELSE $
            os.lp_load_cam(ind) = 1
      ENDFOR
   ENDIF

   ;** parse through to see if any need wl/exp table updates
   start = KEYWORD_VALUE(key_val_arr, 'PT_LOAD_WLEXP', index, /GET_ALL)
   IF (start NE '') THEN BEGIN
      used(index) = 1
      start_cam = UTC2TAI(PTDATE2UTC(start))
      start_tai = UTC2TAI(start_utc)
      FOR s=0, N_ELEMENTS(start_cam)-1 DO BEGIN
         ind = WHERE(start_cam(s) EQ start_tai)
         IF (ind(0) EQ -1) THEN $
            PRINT, 'ERROR wavelength/exp table load time does not correspond to any OS start time' $ 
         ELSE $
            os.lp_load_wlexp(ind) = 1
      ENDFOR
   ENDIF

   ;** parse through to see if any check and corrects needed
   start = KEYWORD_VALUE(key_val_arr, 'PT_DO_CANDC', index, /GET_ALL)
   IF (start NE '') THEN BEGIN
      used(index) = 1
      start_cc = UTC2TAI(PTDATE2UTC(start))
      start_tai = UTC2TAI(start_utc)
      FOR s=0, N_ELEMENTS(start_cc)-1 DO BEGIN
         ind = WHERE(start_cc(s) EQ start_tai)
         IF (ind(0) EQ -1) THEN $
            PRINT, 'ERROR check and correct time does not correspond to any OS start time' $ 
         ELSE $
            os.lp_do_candc(ind) = 1
      ENDFOR
   ENDIF

   ;** parse through to see if any move FP needed
   start = KEYWORD_VALUE(key_val_arr, 'PT_MOVE_FP', index, /GET_ALL)
   wl = KEYWORD_VALUE(key_val_arr, 'PT_MOVE_FP_WL', index2, /GET_ALL)
   IF (STRMID(wl,0,1) EQ '(') THEN wl = STRMID(wl,1,STRLEN(wl)-2)
   wl = DOUBLE(STR2ARR(wl,DELIM=','))
   order = KEYWORD_VALUE(key_val_arr, 'PT_MOVE_FP_ORDER', index3, /GET_ALL)
   IF (STRMID(order,0,1) EQ '(') THEN order = STRMID(order,1,STRLEN(order)-2)
   order = FIX(STR2ARR(order,DELIM=','))
   IF (start NE '') THEN BEGIN
      used(index) = 1 & used(index2) = 1 & used(index3) = 1
      start_cc = UTC2TAI(PTDATE2UTC(start))
      start_tai = UTC2TAI(start_utc)
      FOR s=0, N_ELEMENTS(start_cc)-1 DO BEGIN
         ind = WHERE(start_cc(s) EQ start_tai)
         IF (ind(0) EQ -1) THEN $
            PRINT, 'ERROR check and correct time does not correspond to any OS start time' $ 
         ELSE BEGIN
            os.lp_move_fp_wl(ind) = DOUBLE(wl(s))
            os.lp_move_fp_order(ind) = FIX(order(s))
         ENDELSE
      ENDFOR
   ENDIF

   ;** fill in rest of structure according to exit criteria
   CASE (os.lp_exit) OF

      ;** Iteration
      0 : IF (os.lp_iter LE 0) THEN BEGIN
             PRINT, '%%%FILL_IN_OS: Undefined iteration count.  Assuming 1.'
             os.lp_iter = 1
          ENDIF		

      ;** Time Duration
      1 : BEGIN
             dur = KEYWORD_VALUE(key_val_arr, 'PT_LP_DUR', index)
             IF (dur EQ '') THEN BEGIN
                PRINT, '%%%FILL_IN_OS: PT_LP_DUR undefined.  Fatal Error.'
                RETURN, -1
             ENDIF ELSE BEGIN
                os.lp_dur = FIX(dur)
                used(index) = 1
             ENDELSE
          END

      ;** Absolute Time
      2 : BEGIN
             ;** parse through end times
             endt = KEYWORD_VALUE(key_val_arr, 'PT_LP_END', index, /GET_ALL)
             IF (endt EQ '') THEN BEGIN
                PRINT, '%%%FILL_IN_OS: PT_LP_END undefined.  Fatal Error.'
                RETURN, -1
             ENDIF ELSE BEGIN
                end_utc = PTDATE2UTC(endt)
                IF (os.lp_nsched NE N_ELEMENTS(end_utc)) THEN BEGIN
                   PRINT, '%%%FILL_IN_OS: PT_LP_NSCHED: '+STRN(os.lp_nsched)+$
                      ' not equal N_ELEMENTS(PT_LP_END)'+ STRN(N_ELEMENTS(end_utc))
                   IF (os.lp_nsched GT N_ELEMENTS(end_utc)) THEN BEGIN
                      PRINT, '%%%FILL_IN_OS: Fatal Error.'
                      RETURN, -1
                   ENDIF
                   PRINT, '%%%FILL_IN_OS: Only using first '+STRN(os.lp_nsched)+' elements of PT_LP_END.'
                   end_utc = end_utc(0:os.lp_nsched-1)
                ENDIF
                os.lp_end = end_utc
                used(index) = 1
             ENDELSE
          END

      ;** Unknown
      DEFAULT : BEGIN
             PRINT, '%%%FILL_IN_OS: PT_LP_EXIT Illegal Value: '+STRN(os.lp_exit)+'  Fatal Error.'
             RETURN, -1
          END

   ENDCASE
   
   RETURN, os
END
