PRO GENERATE_IAP, startdis, enddis

COMMON OP_DEFINED
COMMON OP_SCHEDULED
COMMON OBS_PROG_DEF

COMMON OS_SCHEDULED
COMMON OS_DEFINED

COMMON KAP_INIT
COMMON KAP_INPUT

   IF (DATATYPE(os_arr(0)) EQ 'INT') THEN RETURN
   sec_r = (16 * 60)	;** arc sec per solar radius
   pixel_size = [5.6,11.4,56.0,4.0]	;** pixel size in arc seconds for C1,C2,C3,EIT??
   ;** convert from LP num defined in define_os (op_types) to
   ;** actual LP num as understood by the LEB
   lp_conv = [0,9,5,17,14,7,20,16,19,21,2,3,4,6,8,15,11,12,13,18,22,10,1,0]
   lp_names = [ $
                                "NULL",			$
                                "Status Req",		$
                                "M1 Measure",		$
                                "Wobble In",		$
                                "Wobble Out",		$
                                "Dark Image",		$
                                "Chk & Corr",		$
                                "Cont Image",		$
                                "FP Scan Line",		$
                                "Normal Image",		$
                                "Dump Memory",		$
                                "Grnd-Periph",		$
                                "Periph Load",		$
                                "Up Dflt Prm",		$
                                "Seq PW FW",		$
                                "FP_CamCoord",		$
                                "Concurrent",		$
                                "Cal Lamp",		$
                                "Grnd Mech",		$
                                "Sum Img",		$
                                "Take Seq",		$
                                "Move M1",		$
                                "Trans Det"		$
              ]


   ;*************************************************
   ;** form IAP filename LASYYYYMMDDvvv.IAP
   ;**
   GET_UTC, today
   utc = TAI2UTC(startdis, /EXTERNAL)
   iap_file_name = 'LAS'+STRN(utc.year)+STRN(utc.month,FORMAT='(I2.2)')+STRN(utc.day,FORMAT='(I2.2)')

   ;*************************************************
   ;** check for previous versions
   ;** 
   exist = FINDFILE(iap_file_name + '???.IAP', count=count)
   IF (exist(0) EQ '') THEN $					;** first version
      iap_file_name = iap_file_name + '000.IAP' $
   ELSE BEGIN
      exist = STRUPCASE(exist(count-1))				;** make next version
      version = FIX(STRMID(exist,11,3))+1
      iap_file_name = iap_file_name + STRN(version,FORMAT='(I3.3)') + '.IAP'
   ENDELSE

   ;*************************************************
   ;** Write out IAP File Header
   ;** 
   PRINT, '%%%GENERATE_IAP: Generating IAP File ', iap_file_name
   OPENW, iap_file, iap_file_name, /GET_LUN
   PRINTF, iap_file, 'DATATYPE = INSTRUMENTER INPUT TO THE ACTIVITY PLAN'
   PRINTF, iap_file, 'FILENAME = '+iap_file_name
   PRINTF, iap_file, 'INSTRUME = LASCO'
   PRINTF, iap_file, 'ORIG_ID  = igse@lasco'
   PRINTF, iap_file, 'OBSERVER = LASCO Operator'
   PRINTF, iap_file, 'DATE_CRE = '+UTC2STR(today, /ECS, /TRUNCATE)
   PRINTF, iap_file, 'STARTIME = '+UTC2STR(TAI2UTC(startdis), /ECS, /TRUNCATE)
   PRINTF, iap_file, 'ENDTIME  = '+UTC2STR(TAI2UTC(enddis), /ECS, /TRUNCATE)
   PRINTF, iap_file, 'COMMENT  = '
   PRINTF, iap_file, 'END'
   PRINTF, iap_file

   ;*************************************************
   ;** Write out INST_NRT_SESSION
   ;** 
   id = WHERE(kap_resource_names EQ "THROUGHPUT") & id = id(0)
   ind = WHERE(kap_resource_arr.id EQ id)
   IF (ind(0) GE 0) THEN BEGIN
      throughput = kap_resource_arr(ind)
      ind = SORT([throughput.startime])    ;** sort by start time
      throughput = throughput(ind)
      FOR i = 0,N_ELEMENTS(throughput)-1 DO BEGIN
         t1 = throughput(i).startime
         t2 = throughput(i).endtime
         t1 = t1 > startdis
         t2 = t2 < enddis
         IF (t2 GT t1) THEN BEGIN
            PRINTF, iap_file, 'INST_NRT_SESSION'
            PRINTF, iap_file, '   STARTIME = ', UTC2STR(TAI2UTC(t1), /ECS, /TRUNCATE)
            PRINTF, iap_file, '   ENDTIME  = ', UTC2STR(TAI2UTC(t2), /ECS, /TRUNCATE)
            PRINTF, iap_file, '   INSTRUME = LASCO'
            PRINTF, iap_file, '   IWS_ID   = lasco'
            PRINTF, iap_file, '   CMD_RATE = 5'
         ENDIF
      ENDFOR
   ENDIF
   PRINTF, iap_file

   ;*************************************************
   ;** Write out "SCIPLAN_" Entries
   ;** 
   ;** This is our scheduled OP's
   FOR i=0, N_ELEMENTS(op_arr)-1 DO BEGIN	;** loop over all scheduled OP's
         t1 = op_arr(i).op_start
         t2 = op_arr(i).op_stop
         t1 = t1 > startdis
         t2 = t2 < enddis
         IF (t2 GT t1) THEN BEGIN
            ind = WHERE(defined_op_arr.num eq op_arr(i).num)
            IF (ind(0) GE 0) THEN BEGIN

               ind = ind(0)
               op_id =defined_op_arr(ind).id
               op_num =defined_op_arr(ind).num
               PRINTF, iap_file, 'SCIPLAN_OPNUM'+STRN(op_num)
               PRINTF, iap_file, '   STARTIME = ', UTC2STR(TAI2UTC(t1), /ECS, /TRUNCATE)
               PRINTF, iap_file, '   ENDTIME  = ', UTC2STR(TAI2UTC(t2), /ECS, /TRUNCATE)
               PRINTF, iap_file, '   INSTRUME = ' + defined_op_arr(ind).instrument
               ;PRINTF, iap_file, '   SCI_OBJ  = ' + op_id_arr(op_id).op_id_name
               str = STRTRIM(defined_op_arr(ind).sci_obj, 2)
               ;IF (str NE '') THEN PRINTF, iap_file, '   SCI_SPEC = ' + str
               IF (str EQ '') THEN BEGIN
                  PRINT, '%%GENERATE_IAP: Warning SCI_OBJ Undefined, setting to Synoptic'
                  str = 'Synoptic'
               ENDIF
               PRINTF, iap_file, '   SCI_OBJ  = ' + str
               str = STRTRIM(defined_op_arr(ind).object, 2)
               PRINTF, iap_file, '   OBJECT   = ' + str
               str = STRTRIM(defined_op_arr(ind).comment, 2)
               IF (str NE '') THEN PRINTF, iap_file, '   NOTES    = ' + str
               PRINTF, iap_file, '   DATE_MOD = ' + UTC2STR(TAI2UTC(defined_op_arr(ind).date_modified), /ECS, /TRUNCATE)

            ENDIF ELSE PRINT, '%%%GENERATE_IAP: Skipping Unknown OP_NUM: ', op_arr(i).num
         ENDIF
   ENDFOR
   PRINTF, iap_file
 

   ;*************************************************
   ;** Write out "PROGRAM_" Entries
   ;** 
   ;** This is our scheduled OS's

   os_arr2 = os_arr(SORT([os_arr.os_num]))   ;** sort on os_num
   uniq_os_arr2 = os_arr2(UNIQ([os_arr2.os_num]))
   num_os = N_ELEMENTS(uniq_os_arr2)

   print, 'num_os', num_os
   FOR i=0, num_os-1 DO BEGIN	;** loop over all unique scheduled OS's

         print, 'os_num', uniq_os_arr2(i).os_num
         good = WHERE(os_arr.os_num EQ uniq_os_arr2(i).os_num)
         ;** sort on start time
         nsched = N_ELEMENTS(good)
         IF (nsched GT 1) THEN good = good(SORT([os_arr(good).os_start]))

         t1 = os_arr(good(0)).os_start
         t2 = os_arr(good(N_ELEMENTS(good)-1)).os_start
         t1 = t1 > startdis
         t2 = t2 < enddis
         print, 't2 GT t1', (t2 GT t1)
         IF (t2 GT t1) THEN BEGIN
            ind = WHERE(defined_os_arr.os_num eq uniq_os_arr2(i).os_num)
			print, 'ind(0)', ind(0)
            IF (ind(0) GE 0) THEN BEGIN

               ind = ind(0)
               os_num =defined_os_arr(ind).os_num
               PRINTF, iap_file, 'PROGRAM_OS'+STRN(os_num)
               PRINTF, iap_file, '   STARTIME = ', UTC2STR(TAI2UTC(t1), /ECS, /TRUNCATE)
               PRINTF, iap_file, '   ENDTIME  = ', UTC2STR(TAI2UTC(t2), /ECS, /TRUNCATE)
               PRINTF, iap_file, '   INSTRUME = LASCO'
               str = lp_names(lp_conv(defined_os_arr(ind).lp))
               PRINTF, iap_file, '   OBS_PROG = ' + str

;** need to define these better
               PRINTF, iap_file, '   SCI_OBJ  = '
               PRINTF, iap_file, '   OBJECT   = COR'

         ;      ccd = defined_os_arr(ind).ccd

               PRINTF, iap_file, '   XCEN     = 0'
               PRINTF, iap_file, '   YCEN     = 0'
               PRINTF, iap_file, '   ANGLE    = 0'
               PRINTF, iap_file, '   IXWIDTH  = '+STRN(pixel_size(defined_os_arr(ind).tele)*1024)
               PRINTF, iap_file, '   IYWIDTH  = '+STRN(pixel_size(defined_os_arr(ind).tele)*1024)

            ENDIF ELSE PRINT, '%%%GENERATE_IAP: Skipping Unknown OS_NUM: ', uniq_os_arr2(i).os_num
         ENDIF
   ENDFOR
   PRINTF, iap_file
 


   CLOSE, iap_file
   FREE_LUN, iap_file
   PRINT, '%%%GENERATE_IAP: Done.'

END
