;input: OS_INSTANCE structure (ex: from defined_os_arr)
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;outputs: comp_str - compression string - 1 char per compression step
;
;


FUNCTION GET_COMP_STR, os

   comp_types = READ_IP_DAT()
   comp_str = ''

;   conv2obe = [1,2,3,4,5,6,7,8,9,10,15,16,17,18,19,20,21,22,23,24,28,31,32]
   IF (os.lp EQ 8) THEN $	;** FOR TAKE SUM USE LAST TABLE
      iptable = os.pw(2) $
   ELSE $
      iptable = os.iptable
   ip = os.ip(iptable)
   good = WHERE(ip.steps GE 0, nip)
   FOR n=0, nip-1 DO BEGIN
      obecode = ip.steps(good(n))
      cind = WHERE(obecode EQ comp_types.ip_num)
      IF (cind(0) NE -1) THEN BEGIN
         comp_str = comp_str + comp_types(cind(0)).ip_char
      ENDIF ELSE PRINT, '%%WARNING unknown compression type', obecode
   ENDFOR

   RETURN, comp_str

END
