;** if val is a number then return the descriptive string associated
;** with that index from the KAP Descriptions table ( kap_descriptions).
;** 
;** if val is a description string then return the index associated
;** with that string from the KAP Descriptions table.  If the string
;** does not exist in the table then create a new entry and return
;** the new index

FUNCTION GET_KAP_DESCRIPTION, val

COMMON KAP_INIT

   IF NOT(SEXIST(kap_descriptions)) THEN kap_descriptions = ''

   val_type = DATATYPE(val)

   IF (val_type EQ 'STR') THEN BEGIN
      ind = WHERE(kap_descriptions EQ val)
      IF (ind(0) GE 0) THEN BEGIN
         RETURN, ind(0)
      ENDIF ELSE BEGIN
         kap_descriptions = [kap_descriptions, val]
         RETURN, N_ELEMENTS(kap_descriptions)-1
      ENDELSE
   ENDIF ELSE BEGIN
      ind = FIX(val)
      IF ( (ind GE 0) AND (ind LT N_ELEMENTS(kap_descriptions)) ) THEN $
         RETURN, kap_descriptions(ind) $
      ELSE RETURN, ''
   ENDELSE

END
