;input: OS_INSTANCE structure (ex: from defined_os_arr)
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;outputs: os_size - size in bits
;         os_duration - duration in seconds
;
;


PRO GET_OS_DB_STATS, os, os_size, os_duration, DOORCLOSED=doorclosed

   ;** GET OBSERVING_MODE FOR EACH IMAGE IN THIS OS
   ;** MULTIPLE IMAGES FOR SEQ PW, ..

   os_size = 0L
   os_duration = 0.0D


lp = os.lp
CASE (1) OF

   ( (lp EQ 1) OR (lp EQ 2) OR (lp EQ 3) ) : BEGIN                 ;** Normal, Dark, Cal Lamp
      index = 0
      obs_mode = GET_OBSERVING_MODE(os, index, DOORCLOSED=doorclosed)
      numpixels = OS_GET_NUM_PIXELS(os)
help, /st, obs_mode
      os_size = numpixels * obs_mode.avg_bits_pixel

      pre_proc_time =  OS_GET_PRE_PROC_TIME(os, index)
help, pre_proc_time
      proc_time = numpixels * obs_mode.avg_proc_time / 1000	;** convert msec to sec
      os_duration = pre_proc_time + proc_time
   END

   (lp EQ 4) : BEGIN                 ;** Seq PW FW LP
      first = 1
      numpixels = OS_GET_NUM_PIXELS(os)
      FOR index=0, os.num_images-1 DO BEGIN
         obs_mode = GET_OBSERVING_MODE(os, index, DOORCLOSED=doorclosed)
help, /st, obs_mode
         an_os_size = numpixels * obs_mode.avg_bits_pixel

         pre_proc_time =  OS_GET_PRE_PROC_TIME(os, index)
         proc_time = numpixels * obs_mode.avg_proc_time / 1000	;** convert msec to sec
         an_os_duration = pre_proc_time + proc_time

         IF (first EQ 1) THEN BEGIN
            os_size = an_os_size
            os_duration = an_os_duration
            first = 0
         ENDIF ELSE BEGIN
            os_size = os_size + an_os_size
            os_duration = os_duration + an_os_duration
         ENDELSE
         IF (an_os_size EQ 0) THEN BEGIN
            index = os.num_images	;** if any stats come up zero -> quit
            os_size = 0
            os_duration = 0
         ENDIF
      ENDFOR
   END

   (lp EQ 8) : BEGIN                 ;** Take Sum
      index = 0
      obs_mode = GET_OBSERVING_MODE(os, index, DOORCLOSED=doorclosed)
      numpixels = OS_GET_NUM_PIXELS(os)
help, /st, obs_mode
      os_size = numpixels * obs_mode.avg_bits_pixel

      pre_proc_time =  OS_GET_PRE_PROC_TIME(os, index)
      proc_time = numpixels * obs_mode.avg_proc_time / 1000	;** convert msec to sec
      os_duration = (pre_proc_time * os.num_images) + proc_time
   END

   (lp EQ 14) : BEGIN                 ;** FP Scan Line
      index = 0
      obs_mode = GET_OBSERVING_MODE(os, index, DOORCLOSED=doorclosed)
      numpixels = OS_GET_NUM_PIXELS(os)
help, /st, obs_mode
      os_size = numpixels * obs_mode.avg_bits_pixel * os.num_images

      pre_proc_time =  OS_GET_PRE_PROC_TIME(os, index)
      proc_time = numpixels * obs_mode.avg_proc_time / 1000	;** convert msec to sec
      os_duration = (pre_proc_time + proc_time) * os.num_images
   END

   ELSE : BEGIN 
      PRINT, '%%GET_OS_DB_STATS: Unknown LP: ', os.lp
      RETURN
   END

ENDCASE

os_size = os_size > 1
os_duration = os_duration > 1
RETURN

END
