;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : GET_OS_NUM()
;               
; Purpose     : Get the next unique Observation Sequence number.
;               
; Explanation : The OS_NUM counter is stored in the saved dataset
;		'os_num.dat'.  This routine simply reads in the last
;		allocated os_num and adds one to it.
;               
; Use         : os_num = GET_OS_NUM()
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : os_num	The next unique Observation Sequence number.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;               
; Restrictions: The saveset file 'os_num.dat' must exist in the current
;		directory and have write permission by the user.
;               
; Side effects: The saveset file 'os_num.dat' will be written over with
;		the allocated number.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
FUNCTION GET_OS_NUM

   RESTORE, 'os_num.dat'

   os_num = os_num + 1

   SAVE, os_num, FILENAME='os_num.dat'

   RETURN, os_num

END
