;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : GET_PLAN_LP_INFO()
;               
; Purpose     : Return details of the given LEB Program.
;               
; Explanation : This routine will read the details (tele,table, etc)
;		for the current LEB Program being scheduled (plan_lp)
;		from the appropriate LP_..._SHARE common block.
;               
; Use         : result = GET_PLAN_LP_INFO( tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table )
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : 0 if LP was found, otherwise -1.
;               tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table
;		These are variables that will be filled.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None
;
; Common      : 
;		OS_INIT_SHARE	Defined in OS_INIT.PRO
;		OS_SHARE	Defined in DEFINE_OS.PRO
;		OS_ALL_SHARE	Defined in OS_INIT.PRO
;		
;		The following are defined in OS_LP.PRO
;		LP_NORMAL_IMAGE_SHARE
;		LP_DARK_IMAGE_SHARE
;		LP_SEQ_PW_FW_SHARE
;		LP_CAL_LAMP_SHARE
;		LP_FP_SCAN_LINE_SHARE
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
FUNCTION GET_PLAN_LP_INFO, tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table

COMMON OS_INIT_SHARE
COMMON OS_SHARE
COMMON OS_ALL_SHARE

COMMON LP_NORMAL_IMAGE_SHARE
COMMON LP_DARK_IMAGE_SHARE
COMMON LP_SEQ_PW_FW_SHARE
COMMON LP_CAL_LAMP_SHARE
COMMON LP_FP_SCAN_LINE_SHARE
COMMON LP_SUM_IMG_SHARE

;** depending on plan_lp (defined in OS_INIT_SHARE) this routine returns the above
;** variables from the correct COMMON LP_...

CASE (plan_lp) OF

   1 : BEGIN                 ;** Normal Image LP
      tele = lpnormv.tele
      table = lpnormv.table
      iptable = lpnormv.iptable
      fw = lpnormv.fw
      pw = INTARR(5)+lpnormv.pw
      lamp = 0
      lp_num_images = 1
      ex_table = ex
   END

   2 : BEGIN                 ;** Dark Image LP
      tele = lpdarkv.tele
      table = lpdarkv.table
      iptable = lpdarkv.iptable
      fw = 0
      pw = INTARR(5)
      lamp = 0
      lp_num_images = 1
      new_ex = ex
      ex(tele,table,0,0) = lpdarkv.expt		;** store exposure time here
      ex_table = new_ex
   END

   3 : BEGIN                 ;** Cal Lamp LP
      tele = lpcalv.tele
      table = lpcalv.table
      iptable = lpcalv.iptable
      fw = lpcalv.fw
      pw = INTARR(5)+lpcalv.pw
      lamp = lpcalv.lamp
      lp_num_images = 1
      ex_table = ex
   END

   4 : BEGIN                 ;** Seq PW FW LP
      tele = lpseqpwv.tele
      table = lpseqpwv.table
      iptable = lpseqpwv.iptable
      fw = lpseqpwv.fw
      pw = lpseqpwv.pw
      lamp = 0
      lp_num_images = lpseqpwv.num + 1 ;** this is an index into the widget (starts at 0)
      ex_table = ex
   END

   8 : BEGIN                 ;** Take Sum
      tele = lpsumv.tele
      table = lpsumv.table
      fw = lpsumv.fw
      pw = lpsumv.pw
      iptable = lpsumv.iptable0
      ;** store the other 2 iptables in pw
      pw = [pw, lpsumv.iptable1, lpsumv.iptable2, 0, 0]
      lamp = 0
      lp_num_images = lpsumv.num
      ex_table = ex
   END

   14 : BEGIN                 ;** FP Scan Line
      tele = 0
      table = lpscanv.table
      iptable = lpscanv.iptable
      fw = lpscanv.fw
      pw = INTARR(5)+lpscanv.pw
      lamp = 0
      lp_num_images = lpscanv.num
      ex_table = ex
   END

   ELSE : BEGIN 
      WIDGET_CONTROL, osv.info_text, SET_VALUE='No LP currently being scheduled.'
      RETURN, -1
   END

ENDCASE

RETURN, 0

END
