;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : OS_CALL_SCHEDULE
;               
; Purpose     : Routine to interface LASCO/EIT Planning and Scheduling Tools.
;               
; Explanation : This routine is the interface between the Planning tool
;		(DEFINE_OS) and the Scheduling Tool (SCHEDULE).  It 
;		adds the current OS to the defined_os_arr.  Then calculates
;		the stats for this OS, starts SCHEDULE if needed, and 
;		updates the OS_NUM, and stats in SCHEDULE.
;               
; Use         : OS_CALL_SCHEDULE
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : OS_STATS, SCHEDULE, XREGISTERED2, GET_OS_NUM, GET_PLAN_LP_INFO
;
; Common      : OS_SHARE	Defined in DEFINE_OS.PRO
;		OS_INIT_SHARE	Defined in OS_INIT.PRO
;		OS_ALL_SHARE	Defined in OS_INIT.PRO
;		OS_DEFINED	Defined in OS_INIT.PRO
;               
; Restrictions: None.
;               
; Side effects: Starts SCHEDULE if needed.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;

PRO OS_CALL_SCHEDULE

COMMON OS_SHARE
COMMON OS_INIT_SHARE
COMMON OS_ALL_SHARE
COMMON OS_DEFINED
COMMON OBS_PROG_DEF, op_id_struct, op_id_arr

   OS_STATS, ptime, psize, obs_mode_id

   IF XREGISTERED("SCHEDULE") THEN $
      print, 'SCHEDULE is up' $
   ELSE SCHEDULE

   tmp = XREGISTERED2("SCHEDULE", sched_base)
   WIDGET_CONTROL, sched_base, GET_UVALUE=schedv

   os_num = GET_OS_NUM()
   WIDGET_CONTROL, schedv.num_text, SET_VALUE='OS_NUM: '+STRTRIM(STRING(os_num),2)

   WIDGET_CONTROL, schedv.os_label, /SENSITIVE
   WIDGET_CONTROL, schedv.delta_text, /SENSITIVE
   WIDGET_CONTROL, schedv.count_text, /SENSITIVE

   WIDGET_CONTROL, schedv.bits_bytes, GET_VALUE=to	;** convert size to correct units
   new_value = SCHEDULE_CONVERT_UNITS(psize, 0, to)
   WIDGET_CONTROL, schedv.os_size_text, SET_VALUE=STRING(new_value,FORMAT='(d10.1)')

   new_value = FLOAT(ptime * schedv.os_dur_factor)         ;** units secs or mins
   WIDGET_CONTROL, schedv.os_dur_text, SET_VALUE=STRING(new_value,FORMAT='(d6.1)')

   ;WIDGET_CONTROL, osv.base, ICONIFY=1
   WIDGET_CONTROL, schedv.base, SHOW=1


   ;** save the os to the defined_os_arr
   new_entry = os_instance			;** os_instance defined in OS_DEFINED COMMON
   new_entry.os_num = os_num
   
;   oplist = STRARR(N_ELEMENTS(defined_op_arr))
;   FOR i=0, N_ELEMENTS(defined_op_arr)-1 DO BEGIN
;      ind = WHERE(defined_op_arr(i).id EQ op_id_arr.op_id )
;      oplist(i) = STRTRIM(defined_op_arr(i).num,2) + ':' + defined_op_arr.id + ':' + 
;   ENDFOR
;   ind = XSEL_LIST(oplist)
;   new_entry.op_num = op_num

   new_entry.lp = plan_lp
   ;** GET VARS FOR GIVEN LP BEING SCHEDULED
   result = GET_PLAN_LP_INFO( tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table)
   new_entry.tele = tele
   new_entry.table = table
   new_entry.iptable = iptable
   new_entry.fw = fw
   new_entry.pw = pw
print, 'fw = ', fw
print, 'pw = ', pw
   new_entry.lamp = lamp
   new_entry.num_images = lp_num_images
   new_entry.ex = ex_table
   new_entry.ccd = ccd
   new_entry.ip = ip
   new_entry.occ_blocks = occ_blocks
   new_entry.roi_blocks = roi_blocks
   new_entry.fpwl = fpwl
   IF ((SIZE(defined_os_arr))(1) EQ 0) THEN $	;** first os scheduled
      defined_os_arr = new_entry		$
   ELSE $
      defined_os_arr = [defined_os_arr, new_entry]	;** append to end of scheduled array


   RETURN

END
