;input: OS_INSTANCE structure (ex: from defined_os_arr)
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;outputs: number of pixels in image
;
;


FUNCTION OS_GET_NUM_PIXELS, os

   ccd = os.ccd
   tele = os.tele
   table = os.table
   iptable = os.iptable
   ip = os.ip
   occ_blocks = os.occ_blocks
   roi_blocks = os.roi_blocks

      ;** GET SIZE OF IMAGE ON CHIP
      ;** we shouldn't take into account summing until we see which blocks are masked ??
      ;                         ((x2  -                      x1) +1) /                    xsum
      xs = ((ccd(tele,table).x2 - ccd(tele,table).x1)+1)
      ys = ((ccd(tele,table).y2 - ccd(tele,table).y1)+1)
      ;** CALCULATE TOTAL PIXELS IN IMAGE BEFORE PROCESSING AND BEFORE SUMMING
      numpixels = LONG(xs)*ys
      numpixels_beforemask = numpixels
 
      ;** ACCOUNT FOR BLOCKS MASKED OUT IN OCCULTER TABLE AND MASKING TABLE
      ;** If only underscan region or No Masking selected then skip this part
      ind = WHERE(ip(iptable).steps EQ 27)
      IF (ind(0) LT 0) THEN useocc = 1 ELSE useocc = 0
      ind = WHERE(ip(iptable).steps EQ 25)
      IF (ind(0) LT 0) THEN useroi = 0 ELSE useroi = 1
      IF ( (ccd(tele,table).x2 GE 20) AND ((useocc EQ 1) OR (useroi EQ 1)) ) THEN BEGIN
         x1 = (ccd(tele,table).x1 - 20) > 0 < 1023      ;** masking table starts at col 20
         x2 = (ccd(tele,table).x2 - 20) > 0 < 1023
         y1 = (ccd(tele,table).y1 - 1) < 1023           ;** masking table ends at row 1023
         y2 = (ccd(tele,table).y2 - 1) < 1023
         block1 = FIX(x1/32) + FIX(y1/32)*32    ;** lower left corner of selected pixels (blocked)
         block2 = FIX(x2/32) + FIX(y2/32)*32    ;** upper right corner of selected pixels (blocked)
         xs2 = (((ccd(tele,table).x2 < 1043) - (ccd(tele,table).x1< 1043) )+1)
         ys2 = (((ccd(tele,table).y2 < 1024) - (ccd(tele,table).y1< 1024) )+1)
         blocksx = ((xs2 + 31) / 32) < 32
         blocksy = ((ys2 + 31) / 32) < 32
         goodblocks = INDGEN(blocksx)+block1
         FOR row=block1/32+1, (block1/32)+blocksy-1 DO $
            goodblocks = [goodblocks,INDGEN(blocksx)+((row*32)+(x1/32))]
 
         allmasked_blocks = -1
         CASE (1) OF
            ((useocc EQ 1) AND (useroi EQ 0)) : allmasked_blocks = WHERE(occ_blocks(tele,*) GT 0)
            ((useroi EQ 1) AND (useocc EQ 0)) : allmasked_blocks = WHERE(roi_blocks(tele,*) GT 0)
            ((useroi EQ 1) AND (useocc EQ 1)) : allmasked_blocks = WHERE((occ_blocks(tele,*)+(roi_blocks(tele,*))) GT 0)
            ELSE : BEGIN
               WIDGET_CONTROL, info_text, SET_VALUE='Unknown Masking Type.'
               RETURN, -1
            ENDELSE
         ENDCASE
         loc = WHERE(allmasked_blocks GE 0)
         IF (loc(0) GE 0) THEN BEGIN
            allmasked_blocks = allmasked_blocks(loc)
            ;** can't mask a block twice
            allmasked_blocks = allmasked_blocks(SORT([allmasked_blocks]))
            allmasked_blocks = allmasked_blocks(UNIQ([allmasked_blocks]))
            collisions = 0      ;** number of valid blocks masked out
            FOR i=0, N_ELEMENTS(allmasked_blocks)-1 DO BEGIN
               tmp = WHERE(allmasked_blocks(i) EQ goodblocks)
               IF (tmp(0) GE 0) THEN collisions = collisions + N_ELEMENTS(tmp)
            ENDFOR
            print, 'num pixels before mask = ', numpixels
            numpixels = numpixels - LONG(collisions)*32*32
            print, 'collisions = ', collisions
         ENDIF
      ENDIF
 
      ;** NOW ACCOUNT FOR SUMMING
      sumfactor = (ccd(tele,table).xsum > 1) * (ccd(tele,table).ysum > 1)
      numpixels = numpixels / sumfactor
 
   RETURN, numpixels

END
