;input: OS_INSTANCE structure (ex: from defined_os_arr)
;       index is which image for line scans and seq pw ...
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;output: number of seconds before processing image (mech movements,exptime,r/o,setup, ..)
;
;


FUNCTION OS_GET_PRE_PROC_TIME, os, index

   ccd = os.ccd
   tele = os.tele
   table = os.table
   iptable = os.iptable
   ip = os.ip
   occ_blocks = os.occ_blocks
   roi_blocks = os.roi_blocks
   long_pulse = ccd(tele,table).lpulse
   long_pulse = FLOAT(long_pulse)/10	;** convert to seconds

   IF (os.lp EQ 2) THEN long_pulse = 0	;** Don't open shutter for Dark
   IF (os.lp EQ 3) THEN BEGIN		;** Don't open shutter for some cal lamps
      IF (tele EQ 3) THEN long_pulse = 0
      IF (tele EQ 2) THEN long_pulse = 0
      IF ( (tele EQ 1) AND (os.lamp EQ 1) ) THEN long_pulse = 0
   ENDIF

   ;** get exptime
   IF (os.lp EQ 14) THEN BEGIN		;** FP Line Scan
      exptime = os.fpwl(table, os.fw, index).exp
   ENDIF ELSE BEGIN
      exptime = os.ex(tele, table, os.fw, os.pw(index))
   ENDELSE
   exptime = FLOAT(exptime)/32	;** convert to seconds

   tme = 0.0D

   ;** move a mech
   IF (long_pulse NE 0) THEN tme = tme + 1.5
print, 'move mech ', tme
   ;** set up complete
   tme = tme + 1.87
print, 'setup complete ', tme
   ;** open shutter (unless dark or cal lamp or long_pulse 0)
   tme = tme + long_pulse
print, 'open shutter ', tme
   ;** expose
   tme = tme + exptime
print, 'expose ', tme
   ;** close shutter
   tme = tme + long_pulse
print, 'close shutter ', tme
   ;** read out ccd

      ;** GET SIZE OF IMAGE ON CHIP
      ;** we shouldn't take into account summing until we see which blocks are masked ??
      ;                         ((x2  -                      x1) +1) /                    xsum
      xs = ((ccd(tele,table).x2 - ccd(tele,table).x1)+1)
      ys = ((ccd(tele,table).y2 - ccd(tele,table).y1)+1)
      ;** CALCULATE TOTAL PIXELS IN IMAGE BEFORE PROCESSING AND BEFORE SUMMING
      numpixels = LONG(xs)*ys
 
      ;** NOW ACCOUNT FOR SUMMING
      sumfactor = (ccd(tele,table).xsum > 1) * (ccd(tele,table).ysum > 1)
      numpixels = numpixels / sumfactor
 
   ro_time = DOUBLE(numpixels)/(1024L*1024)*20	;** fraction of full sized image which takes 20 secs
   tme = tme + ro_time
print, 'read out ccd ', tme
 
   RETURN, tme

END
