
;** THIS ROUTINE LOOKS UP os_num IN THE defined_os_arr
;** AND DISPLAYS A WIDGET OF SUMMARY INFORMATION

PRO OS_SUMMARY_FILL, os_num

COMMON OS_SUMMARY_SHARE, os_sumv

COMMON OP_SCHEDULED
COMMON OS_DEFINED
COMMON OS_SCHEDULED
COMMON OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, proc_tab_types, $
   ip_arr, plan_lp, lprow

   
   ind = WHERE(defined_os_arr.os_num EQ os_num)

   IF (ind(0) LT 0) THEN RETURN

   IF (SEXIST(tele_types) EQ 0) THEN OS_INIT	;** define some variables

   os = defined_os_arr(ind)
   lp = defined_os_arr(ind).lp
   tele = defined_os_arr(ind).tele
   fw = defined_os_arr(ind).fw
   pw = defined_os_arr(ind).pw
   table = defined_os_arr(ind).table
   iptable = defined_os_arr(ind).iptable
   lamp = defined_os_arr(ind).lamp
   num_images = defined_os_arr(ind).num_images
   ccd = defined_os_arr(ind).ccd
   ip = defined_os_arr(ind).ip
   ex = defined_os_arr(ind).ex
   occ_blocks = REFORM(defined_os_arr(ind).occ_blocks(tele,*))
   roi_blocks = REFORM(defined_os_arr(ind).roi_blocks(tele,*))
   fpwl = defined_os_arr(ind).fpwl

   IF (lp EQ 8) THEN BEGIN          ;** Take Sum
      ;iptable = [defined_os_arr(ind).iptable, defined_os_arr(ind).pw(1), defined_os_arr(ind).pw(2)]
      pw = defined_os_arr(ind).pw(0)
      iptable = defined_os_arr(ind).pw(1)
   ENDIF

   indm = WHERE(ip(iptable).steps EQ 27)
   IF (indm(0) LT 0) THEN useocc = 1 ELSE useocc = 0
   indm = WHERE(ip(iptable).steps EQ 25)
   IF (indm(0) LT 0) THEN useroi = 0 ELSE useroi = 1
   CASE (1) OF
      ((useocc EQ 1) AND (useroi EQ 0)) : BEGIN
         blocks = WHERE(occ_blocks GT 0,num)
         blockstr = 'Occulter (' + STRTRIM(num,2) + ' blocks)'
      END
      ((useroi EQ 1) AND (useocc EQ 0)) : BEGIN
         blocks = WHERE(roi_blocks GT 0,num)
         blockstr = 'ROI (' + STRTRIM(num,2) + ' blocks)'
      END
      ((useroi EQ 1) AND (useocc EQ 1)) : BEGIN
         blocks = WHERE((occ_blocks+roi_blocks) GT 0,num)
         blockstr = 'Occulter & ROI (' + STRTRIM(num,2) + ' blocks)'
      END
      ELSE : BEGIN
         blocks = -1
         blockstr = 'None'
      END
   ENDCASE

   ;** convert from LP num defined in define_os (op_types) to
   ;** actual LP num as understood by the LEB
   lptmp = [0,9,5,17,14,7,20,16,19,21,2,3,4,6,8,15,11,12,13,18,22,10,1,0]


   ind = 0
   add = 92	

   str = STRTRIM(STRING(os_num),2)
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='     OS_NUM = ' + STRPAD(str, add, /AFTER)
   ind = ind+1
   str = STRMID(tele_types(tele),11,3)
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='  Telescope = ' + STRPAD(str, add, /AFTER)
   ind = ind+1
   str = STRTRIM(STRING(lptmp(lp)),2)+' '+STRTRIM(op_types(lp-1),2)
   IF (num_images GT 1) THEN str = str + ' ('+STRTRIM(num_images,2)+' Steps)'
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='         LP = ' + STRPAD(str, add, /AFTER)
   ind = ind+1
   str = STRTRIM(table+1,2)
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='        DPT = ' + STRPAD(str, add, /AFTER)
   ind = ind+1
   str = STRTRIM(STRMID(fw_types(fw,tele),0,13), 2)
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='     Filter = ' + STRPAD(str, add, /AFTER)
   ind = ind+1

      IF (lp EQ 14) THEN BEGIN          ;** FP WL Scan, output wl/exp table instead of pw/exp pairs

         str1 = STRTRIM(STRMID(pw_types(pw(0),tele),0,10),2)
         fpwl = REFORM(fpwl(table, fw, *))
         str2 = ''
         str3 = ''
         str4 = ''
         FOR n=0, num_images -1 DO BEGIN    ;** for each wl/exp position
            str2 = str2 + STRTRIM(fpwl(n).wl,2) + '  '
            str3 = str3 + STRTRIM(fpwl(n).exp,2) + '  '
            str4 = str4 + STRTRIM(fpwl(n).order,2) + '  '
         ENDFOR
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='  Polarizer = ' + STRPAD(str1, add, /AFTER)
         ind = ind+1
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE=' Wavelength = ' + STRPAD(str2, add, /AFTER)
         ind = ind+1
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='    Exptime = ' + STRPAD(str3, add, /AFTER)
         ind = ind+1
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='      Order = ' + STRPAD(str4, add, /AFTER)
         ind = ind+1

      ENDIF ELSE BEGIN                  ;** output pw/exp pairs

         IF (tele EQ 3) THEN str0 = '     Sector = ' ELSE str0 = '  Polarizer = '
         str1 = ''
         str2 = ''
         IF (lp EQ 8) THEN num_images = 1	;** Take Sum LP
         FOR n=0, num_images -1 DO BEGIN        ;** for each pw position
            ;IF (tele EQ 3) THEN nchar = 1 ELSE nchar = 10
            str1 = str1 + STRTRIM(STRMID(pw_types(pw(n),tele),0,10),2) + '  '
            str2 = str2 + STRTRIM(ex(tele,table,fw,pw(n)),2) + '  '
         ENDFOR
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE=str0+STRPAD(str1, add, /AFTER)
         ind = ind+1
         WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='    Exptime = ' + STRPAD(str2, add, /AFTER)
         ind = ind+1

      ENDELSE

   ccd = ccd(tele,table)
   str1 = 'x1='+STRING(ccd.x1, FORMAT='(i4)') + $
              ' x2='+STRING(ccd.x2, FORMAT='(i4)') + $
              ' xsum='+STRING(ccd.xsum, FORMAT='(i2)')
   str2 = 'y1='+STRING(ccd.y1, FORMAT='(i4)') + $
              ' y2='+STRING(ccd.y2, FORMAT='(i4)') + $
              ' ysum='+STRING(ccd.ysum, FORMAT='(i2)')
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='        CCD = ' + STRPAD(str1, add, /AFTER)
   ind = ind+1
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='              ' + STRPAD(str2, add, /AFTER)
   ind = ind+1

   good = WHERE(ip(iptable).steps GE 0, nip)
   FOR n=0, nip-1 DO BEGIN
      IF (n EQ 0) THEN str0 = ' Image Proc = ' ELSE str0 = '              '
      str = STRING(ip_arr(ip(iptable).steps(good(n))-1).ip_description,FORMAT='(a15)')
      WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE=str0 + STRPAD(str, add, /AFTER)
      ind = ind+1
   ENDFOR

   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='    Masking = ' + STRPAD(blockstr, add, /AFTER)
   ind = ind+1

   str = GET_COMP_STR(os)
   str = STRTRIM(iptable, 2)+': '+str
   WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='Compression = ' + STRPAD(str, add, /AFTER)
   ind = ind+1

   IF (DATATYPE(os_arr(0)) NE 'INT') THEN BEGIN
   ind2 = WHERE(os_arr.os_num EQ os_num)
   IF (ind2(0) GE 0) THEN BEGIN
      str = STRING(SCHEDULE_CONVERT_UNITS(os_arr(ind2(0)).os_size, 0, 2), FORMAT='(f5.1)') + ' % buffer'
      WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='    OS_SIZE = ' + STRPAD(str, add, /AFTER)
      ind = ind+1
      num = N_ELEMENTS(ind2)
      str = STRTRIM(num, 2)
      WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='# Scheduled = ' + STRPAD(str, add, /AFTER)
      ind = ind+1
      daily_tlm = 23.5D * 60D * 60D * 5274D		;** 23.5 hrs a day we get low rate TLM of 5.2 kbs
      daily_tlm = daily_tlm + .5D * 60D * 60D * 26726D	;**   .5 hrs a day we get high rate TLM of 26.7 kbs
      str = STRING(((os_arr(ind2(0)).os_size * num) / daily_tlm) * 100., FORMAT='(f5.1)') + ' % Daily TLM'
      WIDGET_CONTROL, os_sumv.lab(ind), SET_VALUE='  TLM Usage = ' + STRPAD(str, add, /AFTER)
      ind = ind+1
   ENDIF 
   ENDIF 


   FOR i=ind, N_ELEMENTS(os_sumv.lab)-1 DO WIDGET_CONTROL, os_sumv.lab(i), SET_VALUE='   '


   PLOT_CCD, os_sumv.draw_win, tele, $
      ccd.x1, ccd.x2, ccd.y1, ccd.y2, $
      BLOCKS=blocks
 

END
 

;________________________________________________________________________________________________________
;


PRO OS_SUMMARY_EVENT, event
 
COMMON OS_SUMMARY_SHARE, os_sumv

CASE (event.id) OF
 
   os_sumv.dismiss : BEGIN      ;** exit program
      WIDGET_CONTROL, /DESTROY, os_sumv.base
   END
 
   ELSE : BEGIN
   END
 
ENDCASE
 
END
 
;________________________________________________________________________________________________________
;


PRO OS_SUMMARY, os_num, caller

COMMON OS_SUMMARY_SHARE, os_sumv

   IF XRegistered("OS_SUMMARY") THEN BEGIN
      OS_SUMMARY_FILL, os_num
      RETURN
   ENDIF

   base = WIDGET_BASE(/COLUMN, TITLE='LASCO/EIT OBSERVING SEQUENCE SUMMARY', /FRAME, $
          GROUP_LEADER=caller)

     row1 = WIDGET_BASE(base, /ROW)

       col = WIDGET_BASE(row1, /COLUMN)
         xsize = 650
         col1 = WIDGET_BASE(col, /COLUMN, /FRAME, SPACE=2, XSIZE=xsize, /SCROLL, $
                X_SCROLL_SIZE=270, Y_SCROLL_SIZE=234)
           lab = LONARR(20)
           str = STRING(' ', FORMAT='(a165)')
           FOR i=0, N_ELEMENTS(lab)-1 DO BEGIN
              lab(i) = WIDGET_LABEL(col1, VALUE=str)
           ENDFOR

         dismiss = WIDGET_BUTTON(col, VALUE=' Dismiss ')

       col2 = WIDGET_BASE(row1, /COLUMN, /FRAME)
         draw_w = WIDGET_DRAW(col2, /FRAME, XSIZE=256+5, YSIZE=256)


 
    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************
 
    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=400, TLB_SET_YOFFSET=400
    WIDGET_CONTROL, draw_w, GET_VALUE=draw_win

    os_sumv = CREATE_STRUCT( 'base', base,                      $
                             'draw_win', draw_win,                    $
                             'lab', lab,                    $
                             'dismiss', dismiss )
 
    OS_SUMMARY_FILL, os_num

    XMANAGER, "OS_SUMMARY", base

   RETURN

END
