;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : PICKFILES2
;               
; Purpose     : Widget tool to allow user to pick multiple files.
;               
; Use         : files = PICKFILES2(FILES=files, FILTER=filter, PATH=path)
;    
; Inputs      : None.
;               
; Outputs     : STRARR containing names of files selected, or '' (empty string)
;		if none selected.
;               
; Keywords    : 
;       FILES:  A string array containing file choices to diplay.
;
;       PATH:   The initial path to select files from.  If this keyword is
;               not set, the current directory is used.
;
;       FILTER: A string value for filtering the files in the file list.  This
;               keyword is used to reduce the number of files to choose from.
;               Example filter values might be "*.fits" or "*.pro".
;
;
; Common      : PICKFILES2_COMMON
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Widgets.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, Feb. 1996.
;               
; Modified    : 
;
; Version     : 
;-            

;__________________________________________________________________________________________________________
;

PRO PICKFILES2_EVENT, ev

COMMON PICKFILES2_COMMON, base, all_files, selected, files_base

WIDGET_CONTROL, ev.id, GET_UVALUE=uval

   xs = 100
   ys = 100
   colxmax = 5
    
   CASE (uval) OF

      0 : BEGIN	;** exit program
	     WIDGET_CONTROL, /DESTROY, base
	     GOTO, done
          END

      1 : BEGIN	;** select ALL files
             WIDGET_CONTROL, files_base, SET_BUTTON=1
             selected(*) = 1B
          END

      2 : BEGIN	;** CLEAR ALL files
             WIDGET_CONTROL, files_base, SET_BUTTON=0
             selected(*) = 0B
          END

      ELSE : BEGIN	;** file selection
             ind = WHERE(all_files EQ uval)
             IF (ev.select EQ 1) THEN selected(ind) = 1B ELSE selected(ind) = 0B
          END

   ENDCASE

   done:

END

;-----------------------------------------------------------------------

FUNCTION PICKFILES2, FILES=files, XSIZE=xsize, FILTER=filter, PATH=path, TITLE=title

COMMON PICKFILES2_COMMON, base, all_files, selected, files_base

   IF NOT(KEYWORD_SET(FILES)) THEN BEGIN
      IF (KEYWORD_SET(FILTER)) THEN filt = FILTER ELSE filt = "*.*"
      IF (KEYWORD_SET(PATH)) THEN filt = path + '/' + filt
      files = FINDFILE(filt)
   ENDIF
   IF KEYWORD_SET(xsize) THEN xs = xsize ELSE xs = 210

   all_files = files
   selected = BYTARR(N_ELEMENTS(files))

   ;********************************************************************
   ;** SET UP WIDGETS **************************************************

   IF (KEYWORD_SET(TITLE)) THEN atitle = title ELSE atitle = 'SELECT FILES'
   base = WIDGET_BASE(/COLUMN, TITLE=atitle, /FRAME, XSIZE=200)

   XMENU, all_files, base, /NONEXCLUSIVE, /COLUMN, UVALUE=all_files, $
     /FRAME, BASE=files_base, /SCROLL, X_SCROLL_SIZE=xs, Y_SCROLL_SIZE=500

   all_button = WIDGET_BUTTON(base, VALUE=" ALL ", UVALUE=1)
   none_button = WIDGET_BUTTON(base, VALUE=" NONE ", UVALUE=2)
   done_button = WIDGET_BUTTON(base, VALUE=" DONE ", UVALUE=0)

   ;********************************************************************
   ;** REALIZE THE WIDGETS *********************************************

   WIDGET_CONTROL, /REAL, base

   XMANAGER, 'PICKFILES2', base, /MODAL

   inds =WHERE(selected EQ 1B)
   IF (inds(0) LT 0) THEN RETURN, ''
   RETURN, files(WHERE(selected EQ 1B))

END
