;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : PLAN_OP
;               
; Purpose     : Widget tool to define a LASCO/EIT Observing Program.
;               
; Explanation : This tool allows the user to specify a specific LASCO/EIT
;               Observing Program (OP).  This tool is also used to display
;		the details of a previously defined OP.
;               
; Use         : PLAN_OP, caller, default_op
;    
; Inputs      : caller		Structure containing id of caller.
;               
; Opt. Inputs : default_op	(LONG) bring up details for this unique op_num
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : GET_UTC, UTC2TAI, GET_OP_NUM, XREGISTERED2
;
; Common      : PLAN_OP_SHARE, opv				Defined in this routine.
;		OBS_PROG_DEF, op_id_struct, op_id_arr   	Defined in FAKE_OP.PRO
;		OP_DEFINED, op_instance, defined_op_arr		Defined in FAKE_OP.PRO
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;________________________________________________________________________________________________________
;
 
PRO PLAN_OP_EVENT, event

COMMON PLAN_OP_SHARE, opv

COMMON OBS_PROG_DEF, op_id_struct, op_id_arr
COMMON OP_DEFINED, op_instance, defined_op_arr


CASE (event.id) OF

   opv.dismiss : BEGIN	;** exit program
      WIDGET_CONTROL, /DESTROY, opv.base
   END

   opv.op_num : BEGIN	;** new op_num
      IF ((SIZE(defined_op_arr))(1) EQ 0) THEN BEGIN	;** not defined yet read in
         PRINT, 'Restoring op_arr.dat'
         RESTORE, 'op_arr.dat'
      ENDIF
      WIDGET_CONTROL, opv.op_num, GET_VALUE=op_num & op_num = op_num(0)
      op_num = LONG(op_num)
      loc = WHERE(defined_op_arr.num EQ op_num)
      IF (loc(0) GE 0) THEN BEGIN		 ;** IF OP_NUM EXISTS IN OP_ARR THEN DISPLAY INFO 
         op = defined_op_arr(loc(0))
         WIDGET_CONTROL, opv.op_num, SET_VALUE=STRTRIM(op.num,2)
         WIDGET_CONTROL, opv.op_id, SET_VALUE=op.id
         ;WIDGET_CONTROL, opv.name, SET_VALUE=STRTRIM(op_id_arr(op.id).op_id_name,2)
         WIDGET_CONTROL, opv.camp_num, SET_VALUE=STRTRIM(op.camp_num,2)
         WIDGET_CONTROL, opv.instrument, SET_VALUE=STRTRIM(op.instrument,2)
         WIDGET_CONTROL, opv.sci_obj, SET_VALUE=STRTRIM(op.sci_obj,2)
         WIDGET_CONTROL, opv.object, SET_VALUE=STRTRIM(op.object,2)
         WIDGET_CONTROL, opv.comment, SET_VALUE=STRTRIM(op.comment,2)
         WIDGET_CONTROL, opv.date_modified, SET_VALUE=TAI2UTC(op.date_modified,/ECS)
         WIDGET_CONTROL, opv.op_num, GET_VALUE=tmp
         WIDGET_CONTROL, opv.op_num, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
      ENDIF ELSE BEGIN				;** NO OP_ID IN OP_ARR , WHAT TO DO?
         ;** GENERATE AN EVENT FOR THE CLEAR FORM BUTTON
         event = {event, id:0L, top:0L, handler:0L}
         event.id = opv.clear
         event.top = opv.base
         event.handler = opv.clear
         WIDGET_CONTROL, opv.clear, SEND_EVENT=event, /NO_COPY, SHOW=1
         ;** PUT FOCUS ON THE NEXT ITEM
         WIDGET_CONTROL, opv.op_num, GET_VALUE=tmp
         WIDGET_CONTROL, opv.op_num, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
      ENDELSE
   END

   opv.op_id : BEGIN
;      WIDGET_CONTROL, opv.op_id, GET_VALUE=op_id & op_id = op_id(0)
;      op_num = FIX(op_id)
;      WIDGET_CONTROL, opv.op_id, SET_VALUE=STRTRIM(op_id,2)
;      WIDGET_CONTROL, opv.name, SET_VALUE=STRTRIM(op_id_arr(op_id).op_id_name,2)
;      WIDGET_CONTROL, opv.camp_num, /INPUT_FOCUS
;      WIDGET_CONTROL, opv.camp_num, GET_VALUE=tmp
;      WIDGET_CONTROL, opv.camp_num, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

   opv.camp_num : BEGIN
      WIDGET_CONTROL, opv.camp_num, GET_VALUE=camp_num
      camp_num = FIX(camp_num)
      WIDGET_CONTROL, opv.camp_num, SET_VALUE=STRTRIM(camp_num,2)
      WIDGET_CONTROL, opv.instrument, /INPUT_FOCUS
      WIDGET_CONTROL, opv.instrument, GET_VALUE=tmp
      WIDGET_CONTROL, opv.instrument, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

   opv.instrument : BEGIN
      WIDGET_CONTROL, opv.instrument, GET_VALUE=instrument
      instrument = STRUPCASE(instrument)
      WIDGET_CONTROL, opv.instrument, SET_VALUE=instrument
      WIDGET_CONTROL, opv.sci_obj, /INPUT_FOCUS
      WIDGET_CONTROL, opv.sci_obj, GET_VALUE=tmp
      WIDGET_CONTROL, opv.sci_obj, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

   opv.sci_obj : BEGIN
      WIDGET_CONTROL, opv.sci_obj, GET_VALUE=sci_obj
      sci_obj = sci_obj(0)
      WIDGET_CONTROL, opv.sci_obj, SET_VALUE=sci_obj
      WIDGET_CONTROL, opv.object, /INPUT_FOCUS
      WIDGET_CONTROL, opv.object, GET_VALUE=tmp
      WIDGET_CONTROL, opv.object, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

   opv.object : BEGIN
      WIDGET_CONTROL, opv.object, GET_VALUE=object
      object = STRUPCASE(object)
      WIDGET_CONTROL, opv.object, SET_VALUE=object
      WIDGET_CONTROL, opv.comment, /INPUT_FOCUS
      WIDGET_CONTROL, opv.comment, GET_VALUE=tmp
      WIDGET_CONTROL, opv.comment, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

;   opv.op_start : BEGIN
;      WIDGET_CONTROL, opv.op_start, GET_VALUE=op_start
;      WIDGET_CONTROL, opv.op_start, SET_VALUE=op_start
;      WIDGET_CONTROL, opv.op_stop, /INPUT_FOCUS
;      WIDGET_CONTROL, opv.op_stop, GET_VALUE=tmp
;      WIDGET_CONTROL, opv.op_stop, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
;   END
;
;   opv.op_stop : BEGIN
;      WIDGET_CONTROL, opv.op_stop, GET_VALUE=op_stop
;      WIDGET_CONTROL, opv.op_stop, SET_VALUE=op_stop
;      WIDGET_CONTROL, opv.comment, /INPUT_FOCUS
;      WIDGET_CONTROL, opv.comment, GET_VALUE=tmp
;      ;WIDGET_CONTROL, opv.comment, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
;      WIDGET_CONTROL, opv.comment, SET_TEXT_SELECT=1000
;   END

   opv.comment : BEGIN
      WIDGET_CONTROL, opv.comment, GET_VALUE=comment
      comment = comment(0)
      WIDGET_CONTROL, opv.comment, SET_VALUE=comment
      WIDGET_CONTROL, opv.camp_num, /INPUT_FOCUS
      WIDGET_CONTROL, opv.camp_num, GET_VALUE=tmp
      WIDGET_CONTROL, opv.camp_num, SET_TEXT_SELECT=[STRLEN(STRTRIM(tmp,2))]
   END

   opv.clear : BEGIN	;** clear all inputs
      WIDGET_CONTROL, opv.op_num, SET_VALUE=''
      WIDGET_CONTROL, opv.op_id, SET_VALUE=0
;      WIDGET_CONTROL, opv.name, SET_VALUE=''
      WIDGET_CONTROL, opv.camp_num, SET_VALUE=''
      WIDGET_CONTROL, opv.instrument, SET_VALUE=''
      WIDGET_CONTROL, opv.sci_obj, SET_VALUE=''
      WIDGET_CONTROL, opv.object, SET_VALUE=''
      WIDGET_CONTROL, opv.comment, SET_VALUE=''
      WIDGET_CONTROL, opv.date_modified, SET_VALUE=''
   END

   opv.update : BEGIN	;** save vars to defined_op_arr
      ;** Update DATE_MODIFIED with current time
      GET_UTC, stime, /ECS                    ; get system time
      WIDGET_CONTROL, opv.date_modified, SET_VALUE=stime

      ;** send an event to all input text widgets to do error checking
      evt = {evt, id:0L, top:0L, handler:0L}
      evt.top = opv.base
      id = opv.camp_num
      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
;      id = opv.op_id
;      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
      id = opv.instrument
      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
      id = opv.sci_obj
      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
;      id = opv.name
;      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
      id = opv.object
      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt
      id = opv.comment
      evt.id = id & evt.handler = id & WIDGET_CONTROL, id, SEND_EVENT=evt

      ;** now read in all vars and put them into an op_instance and append to defined_op_arr
      new_op = op_instance
      WIDGET_CONTROL, opv.op_id, GET_VALUE=op_id                 & new_op.id = LONG(op_id(0))
      WIDGET_CONTROL, opv.camp_num, GET_VALUE=camp_num           & new_op.camp_num = LONG(camp_num(0))
      WIDGET_CONTROL, opv.instrument, GET_VALUE=instrument       & new_op.instrument = instrument(0)
      WIDGET_CONTROL, opv.sci_obj, GET_VALUE=sci_obj             & new_op.sci_obj = sci_obj(0)
      WIDGET_CONTROL, opv.object, GET_VALUE=object               & new_op.object = object(0)
      WIDGET_CONTROL, opv.comment, GET_VALUE=comment             & new_op.comment = comment(0)
      WIDGET_CONTROL, opv.date_modified, GET_VALUE=date_modified 
      new_op.date_modified=UTC2TAI(date_modified(0))

      new_op.num = GET_OP_NUM()
      defined_op_arr = [defined_op_arr, new_op]

      ;** Allocate next OP_NUM and update SCHEDULE's num_text label
      ;** Schedule must already be up
      tmp = XREGISTERED2("SCHEDULE", sched_base)
      WIDGET_CONTROL, sched_base, GET_UVALUE=schedv
      WIDGET_CONTROL, schedv.num_text, SET_VALUE='OP_NUM: '+STRTRIM(STRING(new_op.num),2)
      WIDGET_CONTROL, schedv.os_label, SENSITIVE=0
;      WIDGET_CONTROL, schedv.delta_text, SENSITIVE=0
;      WIDGET_CONTROL, schedv.count_text, SENSITIVE=0

   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

PRO PLAN_OP, caller, default_op

COMMON PLAN_OP_SHARE
COMMON OBS_PROG_DEF, op_id_struct, op_id_arr

    IF XRegistered("PLAN_OP") THEN GOTO, CONT

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='DEFINE OBSERVING PROGRAM', /FRAME, $
             GROUP_LEADER=caller.id)

    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='OP_NUM ')
      op_num = WIDGET_TEXT(row, VALUE='', XSIZE=5, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='OP_ID ')
      opids = STRTRIM(op_id_arr.op_id,2) + ':' + op_id_arr.op_id_name
      op_id = CW_BSELECTOR2(row, opids, SET_VALUE=0)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='CAMP_NUM ')
      camp_num = WIDGET_TEXT(row, VALUE='', XSIZE=5, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='INSTRUMENT ')
      instrument = WIDGET_TEXT(row, VALUE='', XSIZE=10, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='OP_SCI_OBJ ')
      sci_obj = WIDGET_TEXT(row, VALUE='', XSIZE=50, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='OBJECT ')
      object = WIDGET_TEXT(row, VALUE='', XSIZE=10, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='COMMENT ')
      comment = WIDGET_TEXT(row, VALUE='', XSIZE=50, YSIZE=1, /EDITABLE)
    row = WIDGET_BASE(base, /ROW)
      tmp = WIDGET_LABEL(row, VALUE='DATE_MODIFIED ')
      date_modified = WIDGET_LABEL(row, VALUE='                           ')

    update  = WIDGET_BUTTON(base, VALUE=' Insert Into Plan  ')
    clear   = WIDGET_BUTTON(base, VALUE='  Clear  ')
    dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    ;WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    opv = CREATE_STRUCT( "base", base,			$
                         "op_num", op_num, 		$
                         "camp_num", camp_num, 		$
                         "op_id", op_id, 		$
                         "instrument", instrument, 		$
                         "sci_obj", sci_obj, 		$
                         ;"name", name, 		$
                         "object", object, 		$
                         "comment", comment, 		$
                         "date_modified", date_modified, 		$
                         "update", update, 		$
                         "clear", clear, 		$
                         "dismiss", dismiss    		$
                       )

    XMANAGER, "PLAN_OP", base

CONT:
    IF KEYWORD_SET(default_op) THEN BEGIN	;** bring up details for this default_op
       WIDGET_CONTROL, opv.op_num, SET_VALUE=STRTRIM(default_op, 2)
       ;** GENERATE AN EVENT FOR THE OP_NUM TEXT WIDGET
       event = {event, id:0L, top:0L, handler:0L}
       event.id = opv.op_num
       event.top = opv.base
       event.handler = opv.op_num
       WIDGET_CONTROL, opv.op_num, SEND_EVENT=event, /NO_COPY, SHOW=1
    ENDIF

    RETURN

END

;________________________________________________________________________________________________________
;
