PRO PLOT_CCD, win, tele, x1, x2, y1, y2, BLOCKS=blocks

   WSET, win
   ERASE

   x1 = (x1-1) / 4.0
   x2 = (x2-1) / 4.0
   y1 = (y1-1) / 4.0
   y2 = (y2-1) / 4.0

   uscan = 20/4	;** underscan pixels
   xs = uscan + 256
   ys = 256
   xc = 128
   yc = 128

   ;** SHADE OUT ENTIRE CCD
   x = [0,1,1,0]
   y = [0,0,1,1]
   pat = BYTARR(2,2)
   pat(1,1) = 9
   POLYFILL, x, y, PATTERN=pat, /NORMAL

   ;** UN-SHADE READ OUT COORDS
   x = [x1,x2,x2,x1]
   y = [y1,y1,y2,y2]
   POLYFILL, x, y, /DEVICE, COLOR=0

   ;** SHADE OUT MASKED BLOCKS IF PASSED IN
   bs = 8	;** block size in pixels
   pat(1,1) = 4
   IF KEYWORD_SET(BLOCKS) THEN BEGIN
   IF (blocks(0) NE -1) THEN BEGIN
      FOR i=0, N_ELEMENTS(blocks)-1 DO BEGIN
         x1 = (blocks(i) - blocks(i)/32*32)*bs
         x1 = x1 + uscan
         y1 = blocks(i)/32*bs
         x2 = x1+bs-1
         y2 = y1+bs-1
         x = [x1,x2,x2,x1]
         y = [y1,y1,y2,y2]
         POLYFILL, x, y, PATTERN=pat, /DEVICE
      ENDFOR
   ENDIF
   ENDIF

   ;** PLOT LINE SHOWING UNDERSCAN REGION
   PLOTS, [uscan-1,uscan-1], [0,ys-1], /DEVICE

   ;** PLOT FIELD OF VIEW AND SOLAR DISK
   IF (tele LE 2) THEN BEGIN
      fov = [ [1.1, 3.0], [2.0, 6.0], [3.7, 32.0] ]	;** field of view Rsun
      sec_r = (16. * 60.)  				;** arc sec per solar radius
      pixel_size = [5.6,11.4,56.0] 			;** pixel size in arc seconds for C1,C2,C3
      pixel_size = pixel_size * 4.0			;** we've shrunk from 1024 to 256
      pix_Rsun = sec_r / pixel_size
      fov(0,*) = fov(0,*) * pix_Rsun			;** convert Rsun to pixels
      fov(1,*) = fov(1,*) * pix_Rsun			;** convert Rsun to pixels

      TVCIRCLE, fov(0,tele), xc+uscan, yc			;** plot inner fov
      TVCIRCLE, fov(1,tele), xc+uscan, yc,$		;** plot outer fov
         CLIP=[uscan-1,0,xs-1,ys-1], NOCLIP=0
      sp = [0.1,0.1,0.]
      TVCIRCLE, 1.0*pix_Rsun(tele), xc+uscan, yc, /FILL,$	;** plot Sun
         /LINE_FILL, SPACING=sp(tele)
   ENDIF

END
