FUNCTION KAP_GET_TIMES, key_val_arr, kap_entry, NO_ENDTIME=NO_ENDTIME

COMMON KAP_INIT, kap_nrt_reserved, kap_resource, kap_resource_names, kap_dsn_names, kap_descriptions, $
                 kap_tlm_mode_names, kap_iie

   key = 'STARTIME' & val = KEYWORD_VALUE(key_val_arr, key)
   IF (val EQ '') THEN BEGIN
      IF (TAG_NAMES(kap_entry, /STRUCTURE_NAME) EQ 'KAP_RESOURCE') THEN $
         PRINT,'%%%READ_KAP: '+key+' undefined for '+kap_resource_names(kap_entry.id)+'.  Ignoring Entry.' $
      ELSE  $
         PRINT,'%%%READ_KAP: '+key+' undefined for '+TAG_NAMES(kap_entry,/STRUCTURE_NAME)+'.  Ignoring Entry.'
      RETURN, -1
   ENDIF ELSE kap_entry.startime = UTC2TAI(STR2UTC(val))

   IF NOT(KEYWORD_SET(NO_ENDTIME)) THEN BEGIN
      key = 'ENDTIME' & val = KEYWORD_VALUE(key_val_arr, key)
      IF (val EQ '') THEN BEGIN
        IF (TAG_NAMES(kap_entry, /STRUCTURE_NAME) EQ 'KAP_RESOURCE') THEN $
         PRINT,'%%%READ_KAP: '+key+' undefined for '+kap_resource_names(kap_entry.id)+'.  Ignoring Entry.' $
        ELSE  $
         PRINT,'%%%READ_KAP: '+key+' undefined for '+TAG_NAMES(kap_entry,/STRUCTURE_NAME)+'.  Ignoring Entry.'
        RETURN, -1
      ENDIF ELSE kap_entry.endtime = UTC2TAI(STR2UTC(val))
   ENDIF

   RETURN, 1

END

;-------------------------------------------------------------------------------------

PRO ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource

COMMON KAP_INPUT, kap_nrt_reserved_arr, kap_resource_arr, kap_iie_arr

   IF (DATATYPE(kap_resource_arr) EQ 'INT') THEN $
      kap_resource_arr = tmp_kap_resource $
   ELSE $
      kap_resource_arr = [kap_resource_arr, tmp_kap_resource]
END

;-------------------------------------------------------------------------------------


PRO READ_KAP, startdis, enddis, DEFAULT=default

COMMON KAP_INPUT, kap_nrt_reserved_arr, kap_resource_arr, kap_iie_arr
COMMON KAP_INIT

   WIDGET_CONTROL, /HOUR

   IF NOT(SEXIST(kap_resource)) THEN KAP_INIT	;** define kap structures in common

   dir = './'

   ;*************************************************
   ;** Try to find default file for startdis
   ;**
   utc = TAI2UTC(startdis, /EXTERNAL)
   dname = 'ECS'+STRN(utc.year)+STRN(utc.month,FORMAT='(I2.2)')+STRN(utc.day,FORMAT='(I2.2)')
 
   exist = FINDFILE(dir + dname + '???.KAP', count=count)
   IF (exist(0) EQ '') THEN $
      IF KEYWORD_SET(default) THEN fname = 'DEFAULT.KAP'  $;** this is a good default
      ELSE fname = PICKFILE(PATH=dir, FILTER='*.KAP', /NOCONFIRM) $
   ELSE BEGIN 
      IF KEYWORD_SET(default) THEN fname = exist(count-1)  $;** don't even verify
      ELSE fname = PICKFILE(PATH=dir, FILTER='*.KAP', /NOCONFIRM, FILE=exist(count-1)) 
   ENDELSE

   IF (FNAME EQ '') THEN RETURN

   PRINT, '%%%READ_KAP: Reading KAP file ', fname
   OPENR, kap_file, fname, /GET_LUN

   str = ''
   kap_resource_arr = 0
   kap_nrt_reserved_arr = 0
   kap_iie_arr = 0

   WIDGET_CONTROL, /HOUR
 
   ;** find first entry
   ;** an entry is a non-empty line that doesn't contain the "=" character and is not "END"
   WHILE ( NOT(EOF(kap_file)) AND ( (str EQ "END") OR (STRPOS(str,'=') GE 0) OR (str EQ '') ) ) DO BEGIN
      READF, kap_file, str
      str = STRTRIM(str, 2)
   ENDWHILE

   ;*************************************************
   ;** loop over each entry
   ;**
   WHILE (NOT(EOF(kap_file))) DO BEGIN

      ;** zero out this structure
      tmp_kap_resource = kap_resource
      tmp_kap_nrt_reserved = kap_nrt_reserved
      tmp_kap_iie = kap_iie

      ;** curr_str_arr is all the keyword/value pairs for this entry
      ;** the first element of curr_str_arr is the entry name
      curr_str_arr = str
 
      str = '='
      ;** find everything up to the next entry
      ;** an entry is a non-empty line that doesn't contain the "=" character
      WHILE ( NOT(EOF(kap_file)) AND ( (STRPOS(str,'=') GE 0) OR (str EQ '') ) ) DO BEGIN
         READF, kap_file, str
         str = STRTRIM(str, 2)
         ;** throw out comments and blank lines
         IF ( (STRMID(str,0,7) NE 'COMMENT') AND (str NE '') ) THEN curr_str_arr = [curr_str_arr, str]
      ENDWHILE
 
      ;** str is the next entry name
      IF NOT(EOF(kap_file)) THEN curr_str_arr = curr_str_arr(0:N_ELEMENTS(curr_str_arr)-2)

      entry = STRUPCASE(curr_str_arr(0))
      key_val_arr = STR_ARR2KEY_VAL(curr_str_arr(1:*))
      CASE (1) OF

   ;---------------------------------------------------------------------------------
   ;-- The following are resources from the KAP file
   ;-- They are stored in kap_resource_arr
   ;--
         ;** DSN_CONTACT
         (STRMID(entry,0,3) EQ 'DSN') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'DSN_CONTACT')))(0)
               tmp_kap_resource.type = (WHERE(kap_dsn_names EQ STRMID(entry,12,3)))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** SVM_RESERVED or PAYLOAD_RESERVED
         ( (STRMID(entry,0,3) EQ 'SVM') OR (STRMID(entry,0,7) EQ 'PAYLOAD') ) : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'RESERVED')))(0)
               IF (STRMID(entry,0,3) EQ 'SVM') THEN tmp_kap_resource.type = 0 ELSE tmp_kap_resource.type = 1
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** THROUGHPUT_RCR or THROUGHPUT_NORCR
         (STRMID(entry,0,10) EQ 'THROUGHPUT') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'THROUGHPUT')))(0)
               IF (STRMID(entry,11,3) EQ 'RCR') THEN tmp_kap_resource.type = 1 ELSE tmp_kap_resource.type = 0
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** SPACECRAFT_MANEUVER
         (entry EQ 'SPACECRAFT_MANEUVER') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'SPACECRAFT_MANEUVER')))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               key = 'NOTES' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN $
                  PRINT,'%%%READ_KAP: '+key+' undefined for '+kap_resource_names(tmp_kap_resource.id) $
               ELSE $
                  tmp_kap_resource.type = GET_KAP_DESCRIPTION(val)
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** CLOCK_ADJUST
         (entry EQ 'CLOCK_ADJUST') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'CLOCK_ADJUST')))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource, /NO_ENDTIME) LT 0) THEN GOTO, SKIP
               key = 'TYPE' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN $
                  PRINT,'%%%READ_KAP: '+key+' undefined for '+kap_resource_names(tmp_kap_resource.id) $
               ELSE $
                  tmp_kap_resource.type = GET_KAP_DESCRIPTION(val)
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** TLM_TAPE_DUMP
         (entry EQ 'TLM_TAPE_DUMP') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'TLM_TAPE_DUMP')))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** TLM_MDI
         (STRMID(entry,0,7) EQ 'TLM_MDI') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'TLM_MDI')))(0)
               IF (STRMID(entry,8,1) EQ 'M') THEN tmp_kap_resource.type = 0 ELSE tmp_kap_resource.type = 1
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** TLM_HR_IDLE
         (entry EQ 'TLM_HR_IDLE') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'TLM_HR_IDLE')))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** TLM_MODE
         (entry EQ 'TLM_MODE') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'TLM_MODE')))(0)
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource, /NO_ENDTIME) LT 0) THEN GOTO, SKIP
               key = 'MODE' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN BEGIN
                  PRINT,'%%%READ_KAP: '+key+' undefined for '+kap_resource_names(tmp_kap_resource.id)
                  GOTO, SKIP
               ENDIF
               ind = WHERE(kap_tlm_mode_names EQ STRUPCASE(val))
               IF (ind(0) LT 0) THEN BEGIN
                  PRINT,'%%%READ_KAP: Unknown TLM_MODE: '+val+' Ignoring entry.'
                  GOTO, SKIP
               ENDIF
               tmp_kap_resource.type = ind(0)
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

         ;** TLM_SUBMODE
         (STRMID(entry,0,11) EQ 'TLM_SUBMODE') : BEGIN
               tmp_kap_resource.id = (BYTE(WHERE(kap_resource_names EQ 'TLM_SUBMODE')))(0)
               tmp_kap_resource.type = FIX(STRMID(entry,12,1))
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_resource, /NO_ENDTIME) LT 0) THEN GOTO, SKIP
               ADD_TO_KAP_RESOURCE_ARR, tmp_kap_resource
            END

   ;---------------------------------------------------------------------------------
   ;-- Store instrument NRT reserved commanding in kap_nrt_reserved_arr
   ;--
         ;** INST_NRT_RESERVED
         (entry EQ 'INST_NRT_RESERVED') : BEGIN
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_nrt_reserved) LT 0) THEN GOTO, SKIP
               key = 'INSTRUME' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_nrt_reserved.instrume = val
               key = 'CMD_RATE' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_nrt_reserved.cmd_rate = FIX(val)
               key = 'STATUS' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_nrt_reserved.status = val
               IF (DATATYPE(kap_nrt_reserved_arr) EQ 'INT') THEN $
                  kap_nrt_reserved_arr = tmp_kap_nrt_reserved $
               ELSE $
                  kap_nrt_reserved_arr = [kap_nrt_reserved_arr, tmp_kap_nrt_reserved]
            END

   ;---------------------------------------------------------------------------------
   ;-- Store IIE Master in kap_iie_arr  (ignore receiver for now)
   ;--
         ;** INST_IIE_MASTER
         (entry EQ 'INST_IIE_MASTER') : BEGIN
               IF (KAP_GET_TIMES(key_val_arr, tmp_kap_iie) LT 0) THEN GOTO, SKIP
               key = 'INSTRUME' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_iie.instrume = val
               key = 'MSTR_TYPE' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_iie.type = FIX(val)
               key = 'STATUS' & val = KEYWORD_VALUE(key_val_arr, key)
               IF (val EQ '') THEN PRINT,'%%%READ_KAP: '+key+' undefined for '+entry $
               ELSE tmp_kap_iie.status = val
               IF (DATATYPE(kap_iie_arr) EQ 'INT') THEN $
                  kap_iie_arr = tmp_kap_iie $
               ELSE $
                  kap_iie_arr = [kap_iie_arr, tmp_kap_iie]
            END

         ELSE : BEGIN
               PRINT, "%%%READ_KAP: Ignoring Unknown entry: ", entry
               GOTO, SKIP
            END
      ENDCASE

      SKIP:

   ENDWHILE
 



   CLOSE, kap_file
   FREE_LUN, kap_file
   PRINT, '%%%READ_KAP: Done.'

   ;**********************
   ;** set day to startdis
   ;today = TAI2UTC(startdis)
   ;utc = TAI2UTC(kap_resource_arr.startime)
   ;utc.mjd = today.mjd
   ;kap_resource_arr.startime = UTC2TAI(utc)
   ;utc = TAI2UTC(kap_resource_arr.endtime)
   ;utc.mjd = today.mjd
   ;kap_resource_arr.endtime = UTC2TAI(utc)

   IF (DATATYPE(kap_nrt_reserved_arr) EQ 'STC') THEN BEGIN
      utc = TAI2UTC(kap_nrt_reserved_arr.startime)
      utc.mjd = today.mjd
      kap_nrt_reserved_arr.startime = UTC2TAI(utc)
      utc = TAI2UTC(kap_nrt_reserved_arr.endtime)
      utc.mjd = today.mjd
      kap_nrt_reserved_arr.endtime = UTC2TAI(utc)
   ENDIF
   IF (DATATYPE(kap_iie_arr) EQ 'STC') THEN BEGIN
      utc = TAI2UTC(kap_iie_arr.startime)
      utc.mjd = today.mjd
      kap_iie_arr.startime = UTC2TAI(utc)
      utc = TAI2UTC(kap_iie_arr.endtime)
      utc.mjd = today.mjd
      kap_iie_arr.endtime = UTC2TAI(utc)
   ENDIF


END
