;+
; Project     : SOHO - LASCO/EIT
;
; Name        : RWMASK
;
; Purpose     : Widget tool to read/write LASCO/EIT mask tables.
;
; Explanation : This tool allows the user to read in a mask definition
;		previously saved or to save a new mask.
;
; Use         : RWMASK, caller
;
; Inputs      : caller          A structure containing the id of the caller.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : POPUP_HELP
;
; Called From : MASK.PRO
;
; Common      : MASK_SHARE      	Defined in MASK.PRO.
;               OS_ALL_SHARE    	Defined in MASK.PRO or OS_INIT.PRO.
;		RWMASK_SHARE, rwmaskv	Defined in this routine.
;
; Restrictions: The saveset file 'masksave.dat' must exist in the current
;               directory and have write permission by the user.
;
; Side effects: None.
;
; Category    : Planning, Scheduling.
;
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;
; Modified    :
;
; Version     : Version 0.1, December 5, 1994
;-
 
;__________________________________________________________________________________________________________
;

PRO RWMASK_EVENT, event

COMMON RWMASK_SHARE, rwmaskv
COMMON MASK_SHARE
COMMON OS_ALL_SHARE, ccd, ip, ipd, ex, exd, occ_blocks, roi_blocks, fpwl, fpwld



    CASE (event.id) OF

	rwmaskv.quit : BEGIN	;** exit program
	   WIDGET_CONTROL, /DESTROY, rwmaskv.base
	END
 
        rwmaskv.helpb : BEGIN    ;** display help
           help_str = STRARR(10)
           help_str(0) = 'To load a mask select it from the list with the left mouse button.'
           help_str(1) = 'To save the current mask enter the name (up to 20 chars)'
           help_str(2) = 'in the Save As: field and press <return>.'
           help_str(3) = 'To delete an entry from the saved table, select it with the'
           help_str(4) = 'left mouse button then press the Delete From List button.'
           POPUP_HELP, help_str, TITLE="HELP"
        END


	rwmaskv.save_text : BEGIN	;**  save current mask
           WIDGET_CONTROL, rwmaskv.save_text, GET_VALUE=name & name = name(0)
           pos = WHERE(rwmaskv.maskt(*).date EQ '')
           pos = pos(0)
           rwmaskv.maskt(pos).name = STRMID(name+'                    ', 0, 19)
           rwmaskv.maskt(pos).date = SYSTIME()
           rwmaskv.maskt(pos).blocks = maskv.blocks
           WIDGET_CONTROL, rwmaskv.loadlist, SET_VALUE=rwmaskv.maskt(*).name+'  '+rwmaskv.maskt(*).date
           good = WHERE(rwmaskv.maskt(*).date NE '')
           len = N_ELEMENTS(good)
           WIDGET_CONTROL, rwmaskv.loadlist, SET_LIST_TOP=len-6
           maskt = rwmaskv.maskt
           SAVE, maskt, FILENAME='masksave.dat'
	END

	rwmaskv.delete : BEGIN	;**  delete from list
           IF (rwmaskv.selected GE 0) THEN BEGIN
              oldmaskt = rwmaskv.maskt
              rwmaskv.maskt(*).name = ''
              rwmaskv.maskt(*).date = ''
              rwmaskv.maskt(*).blocks(*) = -1
              good = WHERE(oldmaskt(*).date NE '')
              good = good(WHERE(good NE rwmaskv.selected))
              len = N_ELEMENTS(good)
              rwmaskv.maskt(0:len-1).name = oldmaskt(good).name
              rwmaskv.maskt(0:len-1).date = oldmaskt(good).date
              rwmaskv.maskt(0:len-1).blocks = oldmaskt(good).blocks

              WIDGET_CONTROL, rwmaskv.loadlist, SET_VALUE=rwmaskv.maskt(*).name+'  '+rwmaskv.maskt(*).date
              WIDGET_CONTROL, rwmaskv.loadlist, SET_LIST_TOP=rwmaskv.selected-6
              maskt = rwmaskv.maskt
              SAVE, maskt, FILENAME='masksave.dat'
              rwmaskv.selected = -1

           ENDIF
	END

	rwmaskv.loadlist : BEGIN	;**  load new mask
           rwmaskv.selected = event.index
           maskv.blocks = rwmaskv.maskt(event.index).blocks
           IF (maskv.type EQ 'OCCULTER') THEN occ_blocks(maskv.tele,*) = maskv.blocks ELSE $
           IF (maskv.type EQ 'ROI') THEN roi_blocks(maskv.tele,*) = maskv.blocks
           WSET, maskv.new_map  & DEVICE, COPY = [0, 0, maskv.ms, maskv.ms, 0, 0, maskv.img_map]
           WSET, maskv.new_gmap & DEVICE, COPY = [0, 0, maskv.ms, maskv.ms, 0, 0, maskv.img_map]
           FOR i=0,31 DO PLOTS, [i*maskv.bs,i*maskv.bs], [0,maskv.ms], /DEVICE, COLOR=maskv.gcol
           FOR i=0,31 DO PLOTS, [0,maskv.ms], [i*maskv.bs,i*maskv.bs], /DEVICE, COLOR=maskv.gcol
           selected = WHERE(maskv.blocks EQ 1)
           IF (selected(0) NE -1) THEN BEGIN
             FOR i=0,N_ELEMENTS(selected)-1 DO BEGIN
               yc = selected(i)/32*maskv.bs
               xc = (selected(i) - selected(i)/32*32)*maskv.bs
               WSET, maskv.new_map  & DEVICE, COPY = [xc, yc, maskv.bs, maskv.bs, xc, yc, maskv.mask_map]
               WSET, maskv.new_gmap & DEVICE, COPY = [xc, yc, maskv.bs, maskv.bs, xc, yc, maskv.mask_map]
             ENDFOR
	   ENDIF
           WSET, maskv.draw_win
           IF (maskv.grid) THEN $
             DEVICE, COPY = [0, 0, maskv.ms, maskv.ms, 0, 0, maskv.new_gmap] $
           ELSE $
             DEVICE, COPY = [0, 0, maskv.ms, maskv.ms, 0, 0, maskv.new_map]
	END

        ELSE : BEGIN
        END

   ENDCASE

END

;__________________________________________________________________________________________________________
;

PRO RWMASK, caller

COMMON RWMASK_SHARE

    IF XRegistered("RWMASK") THEN RETURN

    RESTORE, 'masksave.dat'

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    IF (KEYWORD_SET(caller)) THEN $
       base = WIDGET_BASE(/COLUMN, TITLE='LOAD/SAVE MASK', /FRAME, GROUP_LEADER=caller.id) $
    ELSE $
       base = WIDGET_BASE(/COLUMN, TITLE='LOAD/SAVE MASK', /FRAME)

    row = WIDGET_BASE(base, /ROW, /FRAME)
      junk = WIDGET_LABEL(row, VALUE="Save As:")
      save_text = WIDGET_TEXT(row, XSIZE=20, YSIZE=1, /EDITABLE)
      helpb = WIDGET_BUTTON(row, VALUE="    Help    ")

    loadlist = WIDGET_LIST(base, VALUE=maskt(*).name+'  '+maskt(*).date, YSIZE=6)

    delete = WIDGET_BUTTON(base, VALUE=" Delete From List ")
    quit = WIDGET_BUTTON(base, VALUE=" Dismiss ")

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, base, /REALIZE

    rwmaskv = CREATE_STRUCT( 'base', base, 		$
                             'quit', quit, 		$
                             'helpb', helpb, 		$
                             'loadlist', loadlist,	$
                             'delete', delete,		$
                             'save_text', save_text,	$
                             'selected', -1,		$
                             'maskt', maskt)

   XMANAGER, 'RWMASK', base

END
