;+
; Project     : SOHO - LASCO/EIT
;
; Name        : SCHEDULE_CALL_OS
;
; Purpose     : Routine to interface LASCO/EIT Planning and Scheduling Tools.
;
; Explanation : This routine is the interface between the Scheduling Tool 
;		(SCHEDULE) and the Planning tool (DEFINE_OS).  It brings
;		up the details for a particular OS.
;		It looks up os_num in the defined_os_arr and sets the appropriate 
;		variables for the os definition tool.
;
; Use         : SCHEDULE_CALL_OS, os_num
;
; Inputs      : os_num		The unique number (LONG) that identifies an OS.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : SET_PLAN_LP_INFO
;
; Called From : SCHEDULE_EVENT
;
; Common      : OS_SHARE        Defined in DEFINE_OS.PRO
;               OS_INIT_SHARE   Defined in OS_INIT.PRO
;               OS_ALL_SHARE    Defined in OS_INIT.PRO
;               OS_DEFINED      Defined in OS_INIT.PRO
;
; Restrictions: None.
;
; Side effects: Starts DEFINE_OS if needed.
;
; Category    : Planning, Scheduling.
;
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;
; Modified    :
;
; Version     : Version 0.1, December 5, 1994
;-
 
;__________________________________________________________________________________________________________
;

;** THIS ROUTINE LOOKS UP os_num IN THE defined_os_arr
;** AND SETS THE APPROPRIATE VARIABLES FOR THE OS DEFINITION TOOL.

PRO SCHEDULE_CALL_OS, os_num

COMMON OS_SHARE
COMMON OS_INIT_SHARE
COMMON OS_ALL_SHARE
COMMON OS_DEFINED

   ;** IF ANY LP DEFINITION TOOLS ARE UP GET RID OF THEM
   plan_lp = 0
   FOR i=0, N_ELEMENTS(osv.op_pro)-1 DO BEGIN
      IF XRegistered2(osv.op_pro(i), base) THEN $
         WIDGET_CONTROL, /DESTROY, base
   ENDFOR

   ind = WHERE(defined_os_arr.os_num EQ os_num)
   lp = defined_os_arr(ind).lp

   ;** SET VARS FOR GIVEN LP TYPE
   SET_PLAN_LP_INFO, lp, defined_os_arr(ind).tele, defined_os_arr(ind).table, defined_os_arr(ind).iptable, defined_os_arr(ind).fw, defined_os_arr(ind).pw, defined_os_arr(ind).lamp, defined_os_arr(ind).num_images, defined_os_arr(ind).ex, defined_os_arr(ind).ccd, defined_os_arr(ind).ip, defined_os_arr(ind).occ_blocks, defined_os_arr(ind).roi_blocks, defined_os_arr(ind).fpwl


   ;** GENERATE AN EVENT FOR THE GIVEN LP TO USE VARS SET IN SET_PLAN_LP_INFO.PRO
   event = {event, id:0L, top:0L, handler:0L}
   event.id = osv.op_buttons(lp-1)
   event.top = osv.base
   event.handler = osv.op_buttons(lp-1)
   WIDGET_CONTROL, event.id, SEND_EVENT=event, /NO_COPY, SHOW=1


   RETURN

END
