PRO SCHEDULE_READ_IPT, ipt_file_name, SILENT=silent, STARTDIS=startdis

COMMON OS_SCHEDULED, os_struct, os_arr, tm_arr, load_camtable, load_wlexptable, do_candc, move_fp
COMMON OS_DEFINED, defined_os_arr, os_instance
COMMON OS_ALL_SHARE, ccd, ip, ipd, ex, exd, occ_blocks, roi_blocks, fpwl, fpwld

   USEDEFAULTS = 0

   os_struct = {os_struct, os_num:0L, os_start:0.0D, os_stop:0.0D, os_size:0L, os_duration:0.0D}

   IF (DATATYPE(os_instance) EQ 'UND') THEN OS_INIT
   IF (DATATYPE(os_arr) EQ 'UND') THEN os_arr = -1
   OPENR, ipt_file, ipt_file_name, /GET_LUN

   PRINT, '**************************************'
   PRINT, 'READING IPT FILE: ', ipt_file_name
   PRINT, '**************************************'

   str = ''

   all_commands = ''

   ;** find first occurance of PT_OS_NUM
   WHILE ( NOT(EOF(ipt_file)) AND (STRMID(str,0,9) NE "PT_OS_NUM") ) DO BEGIN
      READF, ipt_file, str
      str = STRTRIM(str, 2)
   ENDWHILE

   ;*************************************************
   ;** loop over each OS
   ;** 
   WHILE (NOT(EOF(ipt_file))) DO BEGIN
      curr_str_arr = str

      str = ''
      ;** find everything up to the next occurance of PT_OS_NUM
      WHILE ( NOT(EOF(ipt_file)) AND (STRMID(str,0,9) NE "PT_OS_NUM") ) DO BEGIN
         READF, ipt_file, str
         str = STRTRIM(str, 2)
         ;** throw out comments and blank lines now
         IF ( (STRMID(str,0,1) NE ';') AND (str NE '') ) THEN curr_str_arr = [curr_str_arr, str]
      ENDWHILE

      ;** if str is "PT_OS_NUM" it is for the next OS loop
      IF NOT(EOF(ipt_file)) THEN curr_str_arr = curr_str_arr(0:N_ELEMENTS(curr_str_arr)-2)

      ;print, curr_str_arr, FORMAT='(a)'
      ;print & print

      ;** curr_str_arr contains all parameters for this OS
      ;** convert this to an array of keyword/value structures
      key_val_arr = STR_ARR2KEY_VAL(curr_str_arr)

      ;** keep track of which parameters we have used
      used = BYTARR(N_ELEMENTS(curr_str_arr))

      ;** now initialize an OS structure and fill it in
      os = FILL_IN_OS(key_val_arr, used)
 
      ;help, /struct, os
 
      ;** now initialize an LP structure for this particular LP and fill it in
      lp = FILL_IN_LP(os.lp_num, key_val_arr, used)
 
      ;help, /struct, lp

      IF NOT(KEYWORD_SET(SILENT)) THEN BEGIN
         print & print
         ;print, key_val_arr(where(used EQ 1)), format='(a)'
         ;print & print
         print, 'Unused parameter/values:'
         print, key_val_arr(where(used NE 1)), format='(a)'
         print & print
      ENDIF

      ;** FILL IN AN OS_INSTANCE
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
 
   new_entry = os_instance                      ;** os_instance defined in OS_DEFINED COMMON
   new_entry.os_num = os.os_num
   ;** convert from OBE LP to LP number defined in define_os
   tmp = [0,9,5,17,14,7,20,16,19,21,2,3,4,6,8,15,11,12,13,18,22,10,1,0]
   t = WHERE(tmp EQ os.lp_num)
   IF (t(0) LE 0) THEN PRINT, '%%SCHEDULE_READ_IPT  Error: Unknown LP', os.lp_num
   new_entry.lp = t(0)

   CASE (new_entry.lp) OF
   1 : BEGIN                 ;** Normal Image LP
      new_entry.tele = lp.tele
      new_entry.num_images = 1
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num
      new_entry.fw = lp.fw
      new_entry.pw(0) = lp.pw
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.iptable).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = lp.exptime
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.iptable).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = $
            exd(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0))
      ENDELSE
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END
 
   2 : BEGIN                 ;** Dark Image LP
      new_entry.tele = lp.tele
      new_entry.num_images = 1
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.iptable).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.iptable).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
      ENDELSE
      new_entry.ex(new_entry.tele, new_entry.table, 0, 0) = lp.exptime
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END
 
   3 : BEGIN                 ;** Cal Lamp LP
      new_entry.tele = lp.tele
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num
      new_entry.fw = lp.fw
      new_entry.pw(0) = lp.pw
      new_entry.num_images = 1
      new_entry.lamp = lp.lamp
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.iptable).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = lp.exptime
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.iptable).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = $
            exd(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0))
      ENDELSE
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END
 
   4 : BEGIN                 ;** Seq PW FW LP
      new_entry.tele = lp.tele
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num
      new_entry.fw = lp.fw
      n = N_ELEMENTS(lp.pw)
      new_entry.num_images = n
      new_entry.pw(0:n-1) = lp.pw
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.iptable).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
         FOR i=0,n-1 DO $
            new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(i)) = lp.exptime(i)
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.iptable).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
         FOR i=0,n-1 DO $
            new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(i)) = $
               exd(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(i))
      ENDELSE
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END
 
   8 : BEGIN                 ;** Take Sum
      new_entry.tele = lp.tele
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num(0)
      new_entry.pw(1) = lp.ip_tab_num(1)
      new_entry.pw(2) = lp.ip_tab_num(2)
      new_entry.fw = lp.fw
      new_entry.pw(0) = lp.pw
      new_entry.num_images = lp.num
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.pw(1)).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = lp.exptime
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.pw(1)).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
         new_entry.ex(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0)) = $
            exd(new_entry.tele, new_entry.table, new_entry.fw, new_entry.pw(0))
      ENDELSE
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END

   14 : BEGIN                 ;** FP Scan Line
      new_entry.tele = 0
      new_entry.table = lp.dpt - 1
      new_entry.iptable = lp.ip_tab_num
      new_entry.fw = lp.fw
      new_entry.pw(0) = lp.pw
      n = N_ELEMENTS(lp.wavelength)
      new_entry.num_images = n
      new_entry.ccd(new_entry.tele,new_entry.table) = lp.ccd
      IF (USEDEFAULTS EQ 0) THEN BEGIN
         new_entry.ip(new_entry.iptable).steps = lp.ip
         new_entry.occ_blocks(new_entry.tele, *) = lp.occ
         FOR i=0,n-1 DO BEGIN
            new_entry.fpwl(new_entry.table, new_entry.fw, i).wl = lp.wavelength(i)
            new_entry.fpwl(new_entry.table, new_entry.fw, i).exp = lp.exptime(i)
            new_entry.fpwl(new_entry.table, new_entry.fw, i).order = lp.order(i)
            ;new_entry.fpwl(new_entry.table, new_entry.fw, i).order = fpwl(new_entry.table, new_entry.fw, i).order
         ENDFOR
      ENDIF ELSE BEGIN
         new_entry.ip(new_entry.iptable).steps = ipd(new_entry.iptable).steps
         new_entry.occ_blocks(new_entry.tele, *) = occ_blocks(new_entry.tele,*)
         FOR i=0,n-1 DO BEGIN
            new_entry.fpwl(new_entry.table, new_entry.fw, i).wl = $
               fpwld(new_entry.table, new_entry.fw, i).wl
            new_entry.fpwl(new_entry.table, new_entry.fw, i).exp = $
               fpwld(new_entry.table, new_entry.fw, i).exp
            new_entry.fpwl(new_entry.table, new_entry.fw, i).order = $
               fpwld(new_entry.table, new_entry.fw, i).order
         ENDFOR
      ENDELSE
      new_entry.roi_blocks(new_entry.tele, *) = lp.roi
   END
 
   ELSE : BEGIN
   END
 
ENDCASE

   IF ((SIZE(defined_os_arr))(1) EQ 0) THEN BEGIN   ;** first os scheduled
      IF (new_entry.os_num EQ 0) THEN new_entry.os_num = GET_OS_NUM()
      defined_os_arr_save = new_entry
      defined_os_arr = new_entry 
   ENDIF ELSE BEGIN		;** only add if new
      ind = WHERE(defined_os_arr.os_num EQ new_entry.os_num)
      IF (ind(0) EQ -1) THEN BEGIN			;** then it is new

         ;** save os definitions from this IPT so that we only allocate new os_num 
         ;** for truly new definitions
         IF ((SIZE(defined_os_arr_save))(1) EQ 0) THEN BEGIN   ;** first os of IPT file
            IF (new_entry.os_num EQ 0) THEN new_entry.os_num = GET_OS_NUM()
            defined_os_arr_save = new_entry
            defined_os_arr = [defined_os_arr, new_entry]	;** append to end of defined array
         ENDIF ELSE BEGIN
          found = 0
          n = 0
          len = N_ELEMENTS(defined_os_arr_save)
          WHILE ( (found NE 1) AND (n LT len) ) DO BEGIN
            t_os =  defined_os_arr_save(n)
            IF ( (new_entry.lp EQ t_os.lp) AND $
                          (new_entry.tele EQ t_os.tele) AND $
                          (new_entry.table EQ t_os.table) AND $
                          (new_entry.iptable EQ t_os.iptable) AND $
                          (new_entry.fw EQ t_os.fw) AND $
                          MIN(new_entry.pw EQ t_os.pw) AND $
                          (new_entry.lamp EQ t_os.lamp) AND $
                          (new_entry.num_images EQ t_os.num_images) AND $
                          MIN(new_entry.ex EQ t_os.ex) AND $
                          MIN(new_entry.occ_blocks EQ t_os.occ_blocks) AND $
                          MIN(new_entry.roi_blocks EQ t_os.roi_blocks) ) THEN found = 1
;                          (new_entry.fpwl(new_entry.table,new_entry.fw) EQ t_os.fpwl) )
;found = 0
            IF (found EQ 1) THEN BEGIN	;** compare all tags in structure
               st = new_entry.ccd(new_entry.tele,new_entry.table)
               st2 = t_os.ccd(new_entry.tele,new_entry.table)
               nt = N_TAGS(st)
               res = BYTARR(nt)
               FOR t=0, nt-1 DO $
                  res(t) = MIN(st.(t) EQ st2.(t))
               st = new_entry.ip(new_entry.iptable)
               st2 = t_os.ip(new_entry.iptable)
               nt = N_TAGS(st)
               res2 = BYTARR(nt)
               FOR t=0, nt-1 DO $
                  res2(t) = MIN(st.(t) EQ st2.(t))
               IF ((MIN(res) < MIN(res2)) EQ 1) THEN found = 1 ELSE found = 0
            ENDIF
            n = n + 1
          ENDWHILE
            IF (found EQ 0) THEN BEGIN			;** this is new
               IF (new_entry.os_num EQ 0) THEN new_entry.os_num = GET_OS_NUM()
               defined_os_arr_save = [defined_os_arr_save, new_entry]
               defined_os_arr = [defined_os_arr, new_entry]	;** append to end of defined array
            ENDIF ELSE BEGIN 						;** this was already defined
               new_entry.os_num = t_os.os_num
            ENDELSE
         ENDELSE

      ENDIF
   ENDELSE

         ;** 
         ;** IF stats are not in IPT file the calculate them
         ;IF ( (os.os_dur EQ 0) OR (os.os_size EQ 0) ) THEN BEGIN
         IF ( (os.os_size EQ 0) ) THEN BEGIN
            GET_OS_DB_STATS, new_entry, os_size, os_duration
            os.os_size = os_size
            os.os_dur = os_duration
         ENDIF

      ;** loop over each scheduled start time and add to os_arr
      FOR s_index = 0, N_ELEMENTS(os.lp_start)-1 DO BEGIN

         tai = UTC2TAI(os.lp_start(s_index))
         add_os = os_struct
         add_os.os_num = new_entry.os_num
         add_os.os_duration = os.os_dur
         add_os.os_size = os.os_size
         add_os.os_start = tai
         add_os.os_stop = add_os.os_start + add_os.os_duration      ;** calc stop time
         IF (DATATYPE(os_arr) EQ 'INT') THEN os_arr = add_os ELSE $
            os_arr = [os_arr, add_os]                    ;** add to current schedule

         ;***************************
         ;** ADD CAMERA TABLE LOADS
         IF (os.lp_load_cam(s_index) EQ 1) THEN BEGIN
            cam_stc = {cam_stc, os_num:0L, os_start:0.0D}
            cam_stc.os_num = add_os.os_num
            cam_stc.os_start = add_os.os_start
            IF (DATATYPE(load_camtable) NE 'STC') THEN BEGIN  ;** first entry
               load_camtable = cam_stc
            ENDIF ELSE BEGIN
               ind = WHERE((load_camtable.os_num EQ add_os.os_num) AND (load_camtable.os_start EQ add_os.os_start))
               IF (ind(0) EQ -1) THEN BEGIN
                  load_camtable = [load_camtable,cam_stc]
               ENDIF
            ENDELSE
         ENDIF

         ;***************************
         ;** ADD WAVELENGTH/EXP TABLE LOADS
         IF (os.lp_load_wlexp(s_index) EQ 1) THEN BEGIN
            cam_stc = {cam_stc, os_num:0L, os_start:0.0D}
            cam_stc.os_num = add_os.os_num
            cam_stc.os_start = add_os.os_start
            IF (DATATYPE(load_wlexptable) NE 'STC') THEN BEGIN  ;** first entry
               load_wlexptable = cam_stc
            ENDIF ELSE BEGIN
               ind = WHERE((load_wlexptable.os_num EQ add_os.os_num) AND (load_wlexptable.os_start EQ add_os.os_start))
               IF (ind(0) EQ -1) THEN BEGIN
                  load_wlexptable = [load_wlexptable,cam_stc]
               ENDIF
            ENDELSE
         ENDIF

         ;****************
         ;** ADD MOVE FP
         IF (os.lp_move_fp_wl(s_index) NE 0) THEN BEGIN
            fp_stc = {fp_stc, os_num:0L, os_start:0.0D, wl:0.0D, order:0}

            fp_stc.os_num = add_os.os_num
            fp_stc.os_start = add_os.os_start
            fp_stc.wl = os.lp_move_fp_wl(s_index)
            fp_stc.order = os.lp_move_fp_order(s_index)
            IF (DATATYPE(move_fp) NE 'STC') THEN BEGIN        ;** first entry
               move_fp = fp_stc
            ENDIF ELSE BEGIN
               ind = WHERE( (move_fp.os_num EQ add_os.os_num) AND (move_fp.os_start EQ add_os.os_start) )
               IF (ind(0) EQ -1) THEN BEGIN
                  move_fp = [move_fp,fp_stc]
               ENDIF
            ENDELSE
         ENDIF

         ;*****************************
         ;** ADD FP CHECK AND CORRECT
         IF (os.lp_do_candc(s_index) EQ 1) THEN BEGIN
            cac_stc = {cam_stc, os_num:0L, os_start:0.0D}
            cac_stc.os_num = add_os.os_num
            cac_stc.os_start = add_os.os_start
            IF (DATATYPE(do_candc) NE 'STC') THEN BEGIN       ;** first entry
               do_candc = cac_stc
            ENDIF ELSE BEGIN
               ind = WHERE((do_candc.os_num EQ add_os.os_num) AND (do_candc.os_start EQ add_os.os_start))
               IF (ind(0) EQ -1) THEN BEGIN
                  do_candc = [do_candc,cac_stc]
               ENDIF
            ENDELSE
         ENDIF

      ENDFOR	;** end looping on start times for this lp

   ENDWHILE

   CLOSE, ipt_file
   FREE_LUN, ipt_file

   PRINT, '**************************************'
   PRINT, 'DONE READING IPT FILE '
   PRINT, '**************************************'

   ind = SORT(os_arr.os_start)
   startdis = os_arr(ind(0)).os_start
   RETURN
   
END
