;+
; Project     : SOHO - LASCO/EIT
;
; Name        : SET_PLAN_LP_INFO
;
; Purpose     : Set details for the given LEB Program.
;
; Explanation : This routine will set the details (tele,table, etc)
;               for the current LEB Program being scheduled (plan_lp)
;               in the LP_..._SHARE common block from the input variables.
;
; Use         : SET_PLAN_LP_INFO, tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table
;
; Inputs      : tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table 	The details of the LP.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Called From : SCHEDULE_CALL_OS.PRO
;
; Common      :
;               OS_INIT_SHARE   Defined in OS_INIT.PRO
;               OS_SHARE        Defined in DEFINE_OS.PRO
;               OS_ALL_SHARE    Defined in OS_INIT.PRO
;
;               The following are defined in OS_LP.PRO
;               LP_NORMAL_IMAGE_SHARE
;               LP_DARK_IMAGE_SHARE
;               LP_SEQ_PW_FW_SHARE
;               LP_CAL_LAMP_SHARE
;               LP_FP_SCAN_LINE_SHARE
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Planning, Scheduling.
;
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;
; Modified    :
;
; Version     : Version 0.1, December 5, 1994
;-
 
;__________________________________________________________________________________________________________
;

PRO SET_PLAN_LP_INFO, lp, tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table, inccd, inip, inocc_blocks, inroi_blocks, infpwl

COMMON OS_INIT_SHARE
COMMON OS_SHARE
COMMON OS_ALL_SHARE

COMMON LP_NORMAL_IMAGE_SHARE
COMMON LP_DARK_IMAGE_SHARE
COMMON LP_SEQ_PW_FW_SHARE
COMMON LP_CAL_LAMP_SHARE
COMMON LP_FP_SCAN_LINE_SHARE
COMMON LP_SUM_IMG_SHARE

;** depending on lp this routine sets the rest of the above
;** variables in the correct COMMON LP_...

caller = {caller, id:0L}

ccd(tele,table) = inccd(tele,table)
ip(iptable) = inip(iptable)

indm = WHERE(ip(iptable).steps EQ 27)
IF (indm(0) LT 0) THEN occ_blocks(tele) = inocc_blocks(tele)
indm = WHERE(ip(iptable).steps EQ 25)
IF (indm(0) LT 0) THEN roi_blocks(tele) = inroi_blocks(tele)

occ_blocks = inocc_blocks
roi_blocks = inroi_blocks

CASE (lp) OF

   1 : BEGIN                 ;** Normal Image LP
      IF ((SIZE(lpnormv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpnormv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpnormv.tele = tele
      lpnormv.table = table
      lpnormv.iptable = iptable
      lpnormv.fw = fw
      lpnormv.pw = pw(0)
      ex(tele,table,fw,pw(0)) = ex_table(tele,table,fw,pw(0))
   END

   2 : BEGIN                 ;** Dark Image LP
      IF ((SIZE(lpdarkv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpdarkv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpdarkv.tele = tele
      lpdarkv.table = table
      lpdarkv.iptable = iptable
      lpdarkv.expt = ex_table(tele,table,0,0)
   END

   3 : BEGIN                 ;** Cal Lamp LP
      IF ((SIZE(lpcalv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpcalv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpcalv.tele = tele
      lpcalv.table = table
      lpcalv.iptable = iptable
      lpcalv.fw = fw
      lpcalv.pw = pw(0)
      lpcalv.lamp = lamp
      ex(tele,table,fw,pw(0)) = ex_table(tele,table,fw,pw(0))
   END

   4 : BEGIN                 ;** Seq PW FW LP
      IF ((SIZE(lpseqpwv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpseqpwv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpseqpwv.tele = tele
      lpseqpwv.table = table
      lpseqpwv.iptable = iptable
      lpseqpwv.fw = fw
      lpseqpwv.pw = pw
      lpseqpwv.num = lp_num_images
      ex(tele,table,fw,*) = ex_table(tele,table,fw,*)
   END

   8 : BEGIN                 ;** Take Sum
      IF ((SIZE(lpsumv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpsumv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpsumv.tele = tele
      lpsumv.table = table
      lpsumv.iptable0 = iptable
      lpsumv.iptable1 = pw(1)
      lpsumv.iptable2 = pw(2)
      lpsumv.fw = fw
      lpsumv.pw = pw(0)
      lpsumv.num = lp_num_images
      ex(tele,table,fw,pw(0)) = ex_table(tele,table,fw,pw(0))
   END

   14 : BEGIN                 ;** FP Scan Line
      IF ((SIZE(lpscanv))(1) EQ 0) THEN BEGIN             ;** not defined yet, call routine
         tmp = CALL_FUNCTION( osv.op_pro(lp-1), caller)
         WIDGET_CONTROL, lpscanv.base, /DESTROY
         plan_lp = 0
      ENDIF
      lpscanv.table = table
      lpscanv.iptable = iptable
      lpscanv.fw = fw
      lpscanv.pw = pw(0)
      lpscanv.num = lp_num_images
      fpwl(table,fw) = infpwl(table,fw)
   END

   ELSE : BEGIN 
      WIDGET_CONTROL, osv.info_text, SET_VALUE='No LP currently being scheduled.'
      RETURN
   END

ENDCASE

RETURN

END
