;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : TEST_DATA
;               
; Purpose     : Temporary routine to set up some test data for DEFINE_OS.
;               
; Explanation : This routine calculates some fake data used by the
;		Observation Sequence definition tool.  The data consists
;		of telescope configuration arrays and statistics (time
;		to process, processed size).  This routine will be replaced
;		by one which reads actual stats from the database.
;		The following arrays are saved to the file 'test_data.dat': 
;		om	Observing Mode Definition
;		cs	Camera State Definition
;		ts	Telescope State Definition
;		cmd	Compression Mode Definition
;		cms	Compression Mode Sequence
;		ct	Compression Types
;               
; Use         : .rnew test_data
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;               
; Restrictions: The user must be able to write the file 'test_data.dat' 
;		to the current directory.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
;PRO TEST_DATA

   camera_state = {camera_state, state_id:0, row_sum:0B, col_sum:0B, clr_mode:0B, num_clr:0B, $
      dmp_spd:0B, rail0_step:0B, rail1_step:0B, rail2_step:0B, rail3_step:0B, port:0B,        $
      ccd_amp_pwr:0B, pre_amp_pwr:0B}

   ns = 1000
   cs = REPLICATE({camera_state}, ns)
   i=0
   rsums = [0,2,4]
   nclrs = [0,1,10,20]
   for rsum=0,n_elements(rsums)-1 do begin
;    for csum=0,n_elements(rsums)-1 do begin
     for clr=0,1 do begin
      for nclr=0,n_elements(nclrs)-1 do begin
       for dmp=0,1 do begin
r0=0;        for r0=0,0 do begin
r1=0;         for r1=0,0 do begin
r2=0;          for r2=0,0 do begin
r3=0;           for r3=0,0 do begin
            for port=0,3 do begin
amp=1;             for amp=0,1 do begin
preamp=1;              for preamp=0,1 do begin
               cs(i).state_id=i
               cs(i).row_sum=rsums(rsum)
               cs(i).col_sum=rsums(rsum)
               cs(i).clr_mode=clr   
               cs(i).num_clr=nclrs(nclr)
               cs(i).dmp_spd=dmp  
               cs(i).rail0_step=r0  
               cs(i).rail1_step=r1 
               cs(i).rail2_step=r2 
               cs(i).rail3_step=r3
               cs(i).port=port     
               cs(i).ccd_amp_pwr=amp 
               cs(i).pre_amp_pwr=preamp
               i=i+1
;             endfor
;            endfor
            endfor
;          endfor
;         endfor
;        endfor
;       endfor
       endfor
      endfor
     endfor
;   endfor
   endfor
   temp = where(cs.state_id EQ 0)
   cs = cs(0:temp(1)-1)

s = camera_state
s.row_sum = 2
s.col_sum=2
s.clr_mode = 1
s.num_clr = 1
s.dmp_spd = 1

print, 'start where'
print, where( (s.row_sum EQ cs.row_sum ) AND $
              (s.col_sum EQ cs.col_sum ) AND $
              (s.col_sum EQ cs.col_sum ) AND $
              (s.clr_mode EQ cs.clr_mode ) AND $
              (s.num_clr EQ cs.num_clr ) AND $
              (s.dmp_spd EQ cs.dmp_spd ) AND $
              (s.rail0_step EQ cs.rail0_step ) AND $
              (s.rail1_step EQ cs.rail1_step ) AND $
              (s.rail2_step EQ cs.rail2_step ) AND $
              (s.rail3_step EQ cs.rail3_step ) AND $
              (s.port EQ cs.port ) AND $
              (s.ccd_amp_pwr EQ cs.ccd_amp_pwr ) AND $
              (s.pre_amp_pwr EQ cs.pre_amp_pwr) )




   c1_telescope_state = {c1_telescope_state, state_id:0, fw_pos:0B, pw_pos:0B, door:0B, focus:0B, lamp:0B}
   nt = 1000
   ts = REPLICATE({c1_telescope_state}, nt)
   i=0
   for fw_pos=0,4 do begin
    for pw_pos=0,4 do begin
door=0;     for door=0,2 do begin
focus=1;      for focus=0,4 do begin
       for lamp=0,1 do begin
        ts(i).state_id=i
        ts(i).fw_pos=fw_pos
        ts(i).pw_pos=pw_pos
        ts(i).door=door
        ts(i).focus=focus
        ts(i).lamp=lamp
        ;print, i, format='($,d)'
        i = i + 1
       endfor
;     endfor
;    endfor
    endfor
   endfor
   temp = where(ts.state_id EQ 0)
   ts = ts(0:temp(1)-1)



   comp_types = {comp_types, type_id:0, type:''}
   temp = [ "Radial Spoke",    	$
            "Square Root",     	$
            "Ref - Diff",      	$
            "No Comp", 		$
            "Rice Comp",       	$
            "ADCT Comp"]
   temp = ["Bad Line Ave",    $			;0
                     "Inter Min",       $	;1
                     "Shift R", $		;2
                     "Pixel Sum",       $	;3
                     "Radial Spoke",    $	;4
                     "Square Root",     $	;5
                     "Pyramid", $		;6
                     "Inter Sum",       $	;7
                     "Ref - Diff",      $	;8
                     "Roll Diff",       $	;9
                     "Sync Strip",      $	;10
                     "II Bright",       $	;11
                     "II Delta",        $	;12
                     "FP Summing",      $	;13
                     "Debug",   $	  	;14
                     "Hdr Only",        $	;15
                     "Lin Grad",        $	;16
                     "Inv Rad Grad",    $	;17
                     "Rad Grad2",       $	;18
                     "Rad Grad256",     $	;19
                     "Lin Grad2",       $	;20
                     "Transient:Rice",  $	;21
                     "Reset SciCBuff",  $	;22
                   "No Compression          ", $	;23
                   "Rice Compression        ", $	;24
                   "DCMP Compression        ", $	;25
                   "ADCT Compression        "]		;26
   nc = N_ELEMENTS(temp)
   ct = REPLICATE({comp_types}, nc)
   FOR i=0, nc-1 DO BEGIN
      ct(i).type_id = i
      ct(i).type = temp(i)
   ENDFOR


   comp_mode_def = {comp_mode_def, mode_id:0, nsteps:0, mode_str:''}
   cmd = REPLICATE({comp_mode_def}, 10)
   i=0 & cmd(i).mode_id=i & cmd(i).nsteps=1 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=1 & cmd(i).mode_id=i & cmd(i).nsteps=1 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=2 & cmd(i).mode_id=i & cmd(i).nsteps=1 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=3 & cmd(i).mode_id=i & cmd(i).nsteps=2 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=4 & cmd(i).mode_id=i & cmd(i).nsteps=2 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=5 & cmd(i).mode_id=i & cmd(i).nsteps=2 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=6 & cmd(i).mode_id=i & cmd(i).nsteps=2 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=7 & cmd(i).mode_id=i & cmd(i).nsteps=2 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)
   i=8 & cmd(i).mode_id=i & cmd(i).nsteps=3 & cmd(i).mode_str='compression mode'+STRTRIM(STRING(i),2)


   comp_mode_seq = {comp_mode_seq, mode_id:0, step_no:0, type_id:0}
   cms = REPLICATE({comp_mode_seq}, 18)
   i=0
   m=0 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=23 & i=i+1	;no comp
   m=1 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=24 & i=i+1	;rice comp
   m=2 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=26 & i=i+1	;adct comp
   m=3 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=5  & i=i+1	;sq rt & rice
   m=3 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=24 & i=i+1
   m=4 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=5  & i=i+1	;sq rt & shift r & adct
   m=4 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=2  & i=i+1
   m=4 & cms(i).mode_id=m & cms(i).step_no=3 & cms(i).type_id=26 & i=i+1
   m=5 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=5  & i=i+1	;sq rt & shift r & no comp
   m=5 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=2  & i=i+1
   m=5 & cms(i).mode_id=m & cms(i).step_no=3 & cms(i).type_id=23 & i=i+1
   m=6 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=4  & i=i+1	;radial spoke & rice
   m=6 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=24 & i=i+1
   m=7 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=5  & i=i+1	;sq rt & ADCT
   m=7 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=26 & i=i+1
   m=8 & cms(i).mode_id=m & cms(i).step_no=1 & cms(i).type_id=4  & i=i+1	;radial spoke & sq rt & rice
   m=8 & cms(i).mode_id=m & cms(i).step_no=2 & cms(i).type_id=5  & i=i+1
   m=8 & cms(i).mode_id=m & cms(i).step_no=3 & cms(i).type_id=24 & i=i+1



   c1_observing_modes = {c1_observing_modes, mode_id:0, tel_state_id:0, cam_state_id:0,       $
      compr_mode_id:0, time_pro:0D, cf:0D, csize:0D}
   num_obs_modes = N_ELEMENTS(ts) * N_ELEMENTS(cs) * N_ELEMENTS(cmd)
   om = REPLICATE({c1_observing_modes}, num_obs_modes)
   i=0L
   FOR compr=0, N_ELEMENTS(cmd)-1 DO BEGIN
     FOR tele=0, N_ELEMENTS(ts)-1 DO BEGIN
       FOR camera=0, N_ELEMENTS(cs)-1 DO BEGIN
         om(i).mode_id = i
         om(i).tel_state_id = ts(tele).state_id
         om(i).cam_state_id = cs(camera).state_id
         om(i).compr_mode_id = cmd(compr).mode_id

         ;** NOW CALCULATE STATS

         ;** FIRST CALC AVG COMPRESSED IMAGE SIZE (bits/pix)
         ;** FOR NOW THIS DEPENDS ON THE TELESCOPE STATE AND PROCESSING STEPS
         bits_pix = 16.D	;** start with default
         ;** FIRST LOOK AT TELESCOPE STATE
         CASE (ts(tele).fw_pos) OF
           0 : bits_pix = bits_pix * 1.00D
           1 : bits_pix = bits_pix * 1.00D
           2 : bits_pix = bits_pix * 1.00D
           3 : bits_pix = bits_pix * 1.00D
           4 : bits_pix = bits_pix * 1.00D
           ELSE :
         ENDCASE
         CASE (ts(tele).pw_pos) OF
           0 : bits_pix = bits_pix * 1.00D
           1 : bits_pix = bits_pix * 1.00D
           2 : bits_pix = bits_pix * 1.00D
           3 : bits_pix = bits_pix * 1.00D
           4 : bits_pix = bits_pix * 1.00D
           ELSE :
         ENDCASE
         CASE (ts(tele).lamp) OF
           0 : bits_pix = bits_pix * 1.00D
           1 : bits_pix = bits_pix * 1.00D
           ELSE :
         ENDCASE
         ;** NOW LOOK AT PROCESSING STEPS
         cms_ind = WHERE(cms(*).mode_id EQ cmd(compr).mode_id)
         FOR j=0, N_ELEMENTS(cms_ind)-1	DO BEGIN		;** for # of compression steps in seq
           ct_ind = WHERE(ct(*).type_id EQ cms(cms_ind(j)).type_id)
           CASE (ct(ct_ind(0)).type) OF				;** look at each one
             'Radial Spoke' : bits_pix = bits_pix * 0.13D	;** c1: .113  c2: .1236  c3: .1535
             'Square Root'  : bits_pix = bits_pix * 0.5D
             'Ref - Diff'   : bits_pix = bits_pix * 0.5D
             "No Compression          " : bits_pix = 16.D
             "Rice Compression        " : bits_pix = bits_pix * 0.5D
             "DCMP Compression        " : bits_pix = bits_pix * 0.5D
             "ADCT Compression        " : bits_pix = bits_pix * 0.1D
             ELSE :
           ENDCASE
         ENDFOR
         om(i).csize = bits_pix
         i=i+1
       ENDFOR
     ENDFOR
   ENDFOR

SAVE, FILENAME='test_data.dat', om, cs, ts, cmd, cms, ct
END
