;+
; NAME:
;       UNIQ_NOSORT
;
; PURPOSE:
;       Return the subscripts of the unique elements in an array.
;       Does not require array to be sorted (as in UNIQ).
;
; CATEGORY:
;       Array manipulation.
;
; CALLING SEQUENCE:
;       UNIQ_SORT(Array)
;
; INPUTS:
;       Array:  The array to be scanned.  
;
; OUTPUTS:
;       An array of indicies into ARRAY is returned.  The expression:
;
;               ARRAY(UNIQ_NOSORT(ARRAY))
;
;       will be a copy of the sorted Array with duplicate elements removed.
;
; COMMON BLOCKS:
;       None.
;
; Written     : Scott Paswaters, NRL, Dec 1996.
;
;
;-
;

;__________________________________________________________________________________________________________
;
FUNCTION UNIQ_NOSORT, a

   len = N_ELEMENTS(a)
   used = BYTARR(len)
   new = 0
   ind = WHERE(a EQ a(0))
   used(ind) = 1
   FOR i=1, len-1 DO BEGIN
      IF (used(i) EQ 0) THEN BEGIN
         new = [new, i]
         ind = WHERE(a EQ a(i))
         used(ind) = 1
      ENDIF
   ENDFOR

   RETURN, new

END
