;input: OS_INSTANCE structure (ex: from defined_os_arr)
;** Structure OS_INSTANCE, 15 tags, length=12100:
;   OS_NUM          LONG              1695
;   LP              INT              4
;   TELE            INT              1
;   TABLE           INT              2
;   IPTABLE         INT             16
;   FW              INT              3
;   PW              INT       Array(5)
;   LAMP            INT              0
;   NUM_IMAGES      INT              4
;   CCD             STRUCT    -> CCDVARS Array(4, 3)
;   IP              STRUCT    -> IPVARS Array(20)
;   EX              INT       Array(4, 3, 5, 5)
;   OCC_BLOCKS      BYTE      Array(4, 1024)
;   ROI_BLOCKS      BYTE      Array(4, 1024)
;   FPWL            STRUCT    -> FPWL1 Array(3, 5, 10)
;
;outputs: shutter - 0:Open, 1:Closed
;
;
FUNCTION OS_GET_SHUTTER, os

   shutter = 0

   ;** LOOK AT LP, LAMP, ETC
   IF (os.lp EQ 2) THEN shutter = 1	;** closed for DARK
   IF ((os.lp EQ 3) AND (os.tele EQ 3)) THEN shutter = 1	;** closed for EIT CAL LAMP
   IF ((os.lp EQ 3) AND (os.tele EQ 2)) THEN shutter = 1	;** closed for C3 CAL LAMP
   IF ((os.lp EQ 3) AND (os.tele EQ 1) AND ((os.lamp+1) EQ 2)) THEN shutter = 1	;** closed for C2 shutter LAMP

   RETURN, shutter

END
