;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : OS_INIT
;               
; Purpose     : Initialize vars used by the LASCO/EIT Observation Definition tools.
;               
; Explanation : This tool initializes the variables defined in the Commons below.
;               
; Use         : OS_INIT
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : None.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : None.
;
; Common      : The following are all defined in this routine.
;		OS_ALL_SHARE, ccd, ip, ipd, ex, exd, occ_blocks, roi_blocks, fpwl, fpwld
;		LOCATION_SHARE, x, y, xx, yy, last_base
;		OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, $
;				proc_tab_types, ip_arr, plan_lp, lprow
;		OS_DEFINED, defined_os_arr, os_instance
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
;__________________________________________________________________________________________________________
;

PRO OS_INIT

COMMON OS_ALL_SHARE, ccd, ip, ipd, ex, exd, occ_blocks, roi_blocks, fpwl, fpwld
COMMON OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, proc_tab_types, $
   ip_arr, plan_lp, lprow


    ;** camera table contents
    IF ((SIZE(ccd))(1) EQ 0) THEN BEGIN
       ccdvars = {ccdvars, x1:0, x2:0, y1:0, y2:0, xsum:0, ysum:0, clr_spd:0B, nclrs:0, lpulse:0, 	$
                           port:0, leb_sum:0, fp_candc:0, hihtr:0B, lowhtr:0, side:0B}
       ccd = REPLICATE(ccdvars,4,3)    	;** 4 cameras; 3 tables
       ccd(*,*).x1 = 20            	;** all cameras; all tables; x1
       ccd(*,*).x2 = 1043          	;** all cameras; all tables; x2
       ccd(*,*).y1 = 1             	;** all cameras; all tables; y1
       ccd(*,*).y2 = 1024          	;** all cameras; all tables; y2
       ccd(*,*).xsum = 0             	;** all cameras; all tables; xsum
       ccd(*,*).ysum = 0             	;** all cameras; all tables; ysum
       ccd(*,1).x1 = 1             	;** all cameras; calib table; x1
       ccd(*,1).x2 = 1024          	;** all cameras; calib table; x2
       ccd(0:2,*).port = 2          	;** all cameras; all tables; port C
       ccd(3,*).port = 1          	;** EIT        ; all tables; port B
       ccd(*,*).clr_spd = 1          	;** all cameras; all tables; fast clears
       ccd(*,*).nclrs = 10          	;** all cameras; all tables; 10 fast clears
       ccd(*,*).lpulse = 20          	;** all cameras; all tables; long pulse 20 (=2 secs)
       ccd(*,*).leb_sum = 1          	;** all cameras; all tables; LEB inter sum wt = 1
       ccd(*,*).fp_candc = 0          	;** all cameras; all tables; FP check and correct opt
       ccd(*,*).hihtr = 0          	;** all cameras; all tables; high heater off
       ccd(*,*).lowhtr = 255          	;** all cameras; all tables; low heater off
       ccd(3,*).side = 1          	;** EIT; all tables; backsided
    ENDIF

    ;** image processing table contents
    IF ((SIZE(ip))(1) EQ 0) THEN BEGIN
       steps = INTARR(26)-1  ;** 26 steps per table
       ipvars = {ipvars, steps:steps, mask:0, comp:0}
       ip = REPLICATE(ipvars,20)    	;** 20 IP tables
       IF (DATATYPE(ip_arr) EQ 'UND') THEN ip_arr = READ_IP_DAT()

       ;** define some defaults
       file = 'default_ip.dat'
       OPENR, lu, file, /GET_LUN
       str = ''
       first = 1
       WHILE NOT(EOF(lu)) DO BEGIN
          READF, lu, str
          a = STR2ARR(str, DELIM=' ', /NOMULT)
          tab = FIX(a(0))
          steps = FIX(a(1:*))
          ip(tab).steps(0:N_ELEMENTS(steps)-1) = steps
       ENDWHILE
       CLOSE, lu
       FREE_LUN, lu
       ipd = ip	;** save defaults
    ENDIF

    ;** exposure durations default table contents (values are for no summing)
    exd = INTARR(4,3,5,5)		;** 4 cameras; 3 tables; 5 fw; 5 pw
    file = 'default_exp.dat'
    OPENR, lu, file, /GET_LUN
    str = ''
    first = 1
    FOR tele=0, 3 DO BEGIN
     FOR table=0, 2 DO BEGIN
      FOR fw=0, 4 DO BEGIN
       READF, lu, str
       a = STR2ARR(str, DELIM=' ', /NOMULT)
       inexp = FIX(a(1:*))
       exd(tele,table,fw,*) = inexp
      ENDFOR
     ENDFOR
    ENDFOR
    CLOSE, lu
    FREE_LUN, lu
    ;** exposure durations table contents
    IF ((SIZE(ex))(1) EQ 0) THEN BEGIN
       ex = exd				;** 4 cameras; 3 tables; 5 fw; 5 pw
    ENDIF

    ;** define mask tables
    IF ((SIZE(occ_blocks))(1) EQ 0) THEN BEGIN
       occ_blocks = BYTARR(4,32*32)	;** 4 cameras; 1024 blocks
       roi_blocks = BYTARR(4,32*32)	;** 4 cameras; 1024 blocks

       RESTORE, 'masksave.dat'
       ind = WHERE(STRTRIM(maskt.name,2) EQ 'C1 Port C inner')
       occ_blocks(0,*) = maskt(ind(0)).blocks
       ind = WHERE(STRTRIM(maskt.name,2) EQ 'C2 Port C inner')
       occ_blocks(1,*) = maskt(ind(0)).blocks
       ind = WHERE(STRTRIM(maskt.name,2) EQ 'C3 Port C inner')
       occ_blocks(2,*) = maskt(ind(0)).blocks
    ENDIF

    ;** fp wl exposure table
    IF ((SIZE(fpwl))(1) EQ 0) THEN BEGIN

       ;fpwl1 = {fpwl1, wl:0., exp:0., order:0}
print, 'defining fpwl & fpwld'
       fpwl1 = {fpwl1, wl:0.D, exp:0, order:0}
       fpwl2 = {fpwl2, wl:0.D, exp:0, order:0}
help, fpwl2, /st
       fpwl = REPLICATE(fpwl2,3,5,60)			;** 3 tables; 5 filters; up to 60 wl-exp pairs
help, fpwl, /st

       ;*********
       ;** Ca XV
       exp = (103-2)*32
       order = 120
       wl = [ 5695.2982D, $
              5698.0396D, $
              5693.4703D, $
              5697.1261D, $
              5693.6734D, $
              5696.9230D, $
              5693.8765D, $
              5696.7199D, $
              5694.0796D, $
              5696.5168D]
       FOR i=0,2 DO fpwl(i,0,0:9).wl = REFORM(wl, 1, 1, 10)		;** Ca XV
       FOR i=0,2 DO fpwl(i,0,*).exp = REFORM(INTARR(60)+exp, 1, 1, 60)
       FOR i=0,2 DO fpwl(i,0,*).order = REFORM(INTARR(60)+order, 1, 1, 60)
       wl = [ 5694.2827D, $
              5696.3137D, $
              5694.4858D, $
              5696.1106D, $
              5694.6889D, $
              5695.9075D, $
              5694.8920D, $
              5695.7044D, $
              5695.0951D, $
              5695.5013D]
       fpwl(1,0,0:9).wl = REFORM(wl, 1, 1, 10)

       ;*********
       ;** Fe X
       exp = (48-2)*32
       order = 107
       wl = [6376.4418D, $
             6380.9556D, $
             6374.8004D, $
             6378.0832D, $
             6375.2107D, $
             6377.6728D, $
             6375.6211D, $
             6377.2625D, $
             6376.0314D, $
             6376.8521D]
       FOR i=0,2 DO fpwl(i,1,0:9).wl = REFORM(wl, 1, 1, 10)		;** Fe X
       FOR i=0,2 DO fpwl(i,1,*).exp = REFORM(INTARR(60)+exp, 1, 1, 60)
       FOR i=0,2 DO fpwl(i,1,*).order = REFORM(INTARR(60)+order, 1, 1, 60)
       wl = [6376.5785D, $
             6374.1164D, $
             6379.0406D, $
             6377.9464D, $
             6375.7578D, $
             6377.3992D, $
             6376.1682D, $
             6376.9889D, $
             6377.1257D, $
             6376.3050D]
       fpwl(1,1,0:9).wl = REFORM(wl, 1, 1, 10)


       ;*********
       ;** Orange
       exp = (20-2)*32
       order = 104
       wl = [ 6565.3908D, $
              6569.5461D, $
              6563.5638D, $
              6567.1177D, $
              6563.7668D, $
              6567.0147D, $
              6563.9698D, $
              6566.8117D, $
              6564.1728D, $
              6566.6087D]
       FOR i=0,2 DO fpwl(i,2,0:9).wl = REFORM(wl, 1, 1, 10)		;** Orange
       FOR i=0,2 DO fpwl(i,2,*).exp = REFORM(INTARR(60)+exp, 1, 1, 60)
       FOR i=0,2 DO fpwl(i,2,*).order = REFORM(INTARR(60)+order, 1, 1, 60)
       wl = [ 6564.3758D, $
              6566.4057D, $
              6564.5788D, $
              6566.2027D, $
              6564.7818D, $
              6565.9998D, $
              6564.9848D, $
              6565.7968D, $
              6565.1878D, $
              6565.5938D]
       fpwl(1,2,0:9).wl = REFORM(wl, 1, 1, 10)

       ;*********
       ;** Na I  
       exp = (120-2)*32
       order = 116
       wl = [ 5891.1339D, $
              5886.6170D, $
              5889.9339D, $
              5892.3339D, $
              5890.2339D, $
              5892.0339D, $
              5890.5339D, $
              5891.7339D, $
              5890.8339D, $
              5891.4339D]
       FOR i=0,2 DO fpwl(i,3,0:9).wl = REFORM(wl, 1, 1, 10)		;** Na I
       FOR i=0,2 DO fpwl(i,3,*).exp = REFORM(INTARR(60)+exp, 1, 1, 60)
       FOR i=0,2 DO fpwl(i,3,*).order = REFORM(INTARR(60)+order, 1, 1, 60)
       wl = [ 5890.1339D, $
              5892.5339D, $
              5890.4339D, $
              5892.2339D, $
              5890.7339D, $
              5891.9339D, $
              5891.0339D, $
              5891.6339D, $
              5891.3339D, $
              5889.7339D]
       fpwl(1,3,0:9).wl = REFORM(wl, 1, 1, 10)

       ;*********
       ;** Fe XIV
       exp = (100-2)*32
       order = 129
       wl = [ 5302.4222D, $
              5309.2365D, $
              5300.8966D, $
              5303.9478D, $
              5301.2018D, $
              5303.6427D, $
              5301.4052D, $
              5303.4393D, $
              5301.5069D, $
              5303.3376D]
       FOR i=0,2 DO fpwl(i,4,0:9).wl = REFORM(wl, 1, 1, 10)		;** Fe XIV
       FOR i=0,2 DO fpwl(i,4,*).exp = REFORM(INTARR(60)+exp, 1, 1, 60)
       FOR i=0,2 DO fpwl(i,4,*).order = REFORM(INTARR(60)+order, 1, 1, 60)
       wl = [ 5301.8120D, $
              5303.0325D, $
              5302.1171D, $
              5302.7273D, $
              5302.0154D, $
              5302.8290D, $
              5302.2697D, $
              5301.6595D, $
              5302.5748D, $
              5303.1850D]
       fpwl(1,4,0:9).wl = REFORM(wl, 1, 1, 10)
       fpwld = fpwl

    ENDIF


COMMON LOCATION_SHARE, x, y, xx, yy, last_base

    ;** initialize location for first pop up window
    last_base = -1
    x = 500
    y = 0
    DEVICE, GET_SCREEN_SIZE=ss
    xx = ss(0)
    yy = ss(1)

    op_types = [ "Normal Image",        $
                 "Dark Image  ",        $
                 "Cal Lamp    ",        $
                 "Seq PW FW   ",        $
                 "Cont Image  ",        $
                 "Take Seq    ",        $
                 "Concurrent  ",        $
                 "Sum Img     ",        $
                 "Move M1     ",        $
                 "M1 Measure  ",        $
                 "Wobble In   ",        $
                 "Wobble Out  ",        $
                 "Chk & Corr  ",        $
                 "FP Scan Line",        $
                 "FP_CamCoord ",        $
                 "Grnd-Periph ",        $
                 "Periph Load ",        $
                 "Up Dflt Prm ",        $
                 "Grnd Mech   ",        $
                 "Trans Det   ",        $
                 "Dump Memory ",        $
                 "Status Req  ",        $
                 "CMD Table   ",        $
                 "NULL        "]


    plan_lp = 0		;** becomes true (1) when an LP scheduling window is active
    tele_types = [ "Telescope: C1      ", $
                   "Telescope: C2      ", $
                   "Telescope: C3      ", $
                   "Telescope: EIT     "]
    table_types =[ "Primary     Table  ", $
                   "Alternate   Table  ", $
                   "Calibration Table  "]

    c1fw = ['0:Ca XV      Filter', $
            '1:Fe X       Filter', $
            '2:Orange     Filter', $
            '3:Na I       Filter', $
            '4:Fe XIV     Filter']
    c2fw = ['0:Blue       Filter', $
            '1:H Alpha    Filter', $
            '2:Deep Red   Filter', $
            '3:Orange     Filter', $
            '4:Lens       Filter']
    c3fw = ['0:Clear      Filter', $
            '1:Deep Red   Filter', $
            '2:Orange     Filter', $
            '3:IR         Filter', $ $
            '4:Blue       Filter']
    c4fw = ['0:Al +1      Filter', $
            '1:Block E    Filter', $
            '2:Clear      Filter', $
            '3:Block W    Filter', $
            '4:Al +2      Filter']
    fw_types = [[c1fw], [c2fw], [c3fw], [c4fw]]
 
    c1pw = ['0:Clear   Polarizer', $
            '1:H_alpha Polarizer', $
            '2:-60     Polarizer', $
            '3:0       Polarizer', $
            '4:+60     Polarizer']
    c2pw = ['0:Clear   Polarizer', $
            '1:+60     Polarizer', $
            '2:0       Polarizer', $
            '3:-60     Polarizer', $
            '4:Density Polarizer']
    c3pw = ['0:Clear   Polarizer', $
            '1:H_alpha Polarizer', $
            '2:-60     Polarizer', $
            '3:0       Polarizer', $
            '4:+60     Polarizer']
    c4pw = ['0:304              ', $
            '1:195              ', $
            '2:284              ', $
            '3:171              ', $
            '4:Invalid          ']
    pw_types = [[c1pw], [c2pw], [c3pw], [c4pw]]
    exit_types = ['Iteration   ', 	$
                  'End at Time ', 	$
                  'Duration    ']
    proc_tab_types = "Img Proc Table  " + STRMID(STRING(INDGEN(20)), 6, 2) + ' '

COMMON OS_DEFINED, defined_os_arr, os_instance
   IF ((SIZE(os_instance))(1) EQ 0) THEN BEGIN
   ;os_instance = {os_instance, os_num:0L, op_num:0L, lp:0, tele:0, table:0, iptable:0, fw:0, $
   os_instance = {os_instance, os_num:0L, lp:0, tele:0, table:0, iptable:0, fw:0, $
                  pw:INTARR(5), 			$;** up to 5 pw pos for SEQ PW LP
                  lamp:0, num_images:0,			$
                  sub:0, 				$;** use subregions for line scan
                  start:0,				$;** start index for line scan
                  ccd:REPLICATE(ccdvars,4,3),    	$;** 4 cameras; 3 tables
                  ip:REPLICATE(ipvars,20),   		$;** 20 IP tables
                  ex:INTARR(4,3,5,5),			$;** 4 cameras; 3 tables; 5 fw; 5 pw
                  occ_blocks:BYTARR(4,32*32),		$;** 4 cameras; 1024 blocks
                  roi_blocks:BYTARR(4,32*32),		$;** 4 cameras; 1024 blocks
                  fpwl:REPLICATE(fpwl2,3,5,60)}		;** 3 tables; 5 filters; up to 10 wl-exp pairs
   ENDIF


END

;__________________________________________________________________________________________________________
;
