;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : OS_LP
;	      :	LP_NORMAL_IMAGE()	Implemented.
;	      :	LP_DARK_IMAGE()		Implemented.
;	      :	LP_CAL_LAMP()		Implemented.
;	      :	LP_SEQ_PW_FW()		Implemented.
;	      :	LP_CONT_IMAGE()
;	      :	LP_TAKE_SEQ()
;	      :	LP_CONCURRENT()
;	      :	LP_SUM_IMG()		Implemented.
;	      :	LP_MOVE_M1()
;	      :	LP_M1_MEASURE()
;	      :	LP_WOBBLE_IN()		Implemented.
;	      :	LP_WOBBLE_OUT()
;	      :	LP_CHK_CORR()
;	      :	LP_FP_SCAN_LINE()	Implemented.
;	      :	LP_FP_CAMCOORD()
;	      :	LP_GRND_PERIPH()
;	      :	LP_PERIPH_LOAD()
;	      :	LP_UP_DFLT_PRM()
;	      :	LP_GRND_MECH()
;	      :	LP_TRANS_DET()
;	      :	LP_DUMP_MEMORY()
;	      :	LP_STATUS_REQ()
;	      :	LP_CMD_TABLE()		Implemented
;	      :	LP_NULL()
;               
; Purpose     : Widgets to define a LEB Program.
;               
; Explanation : These routines create a widget interface for a specific
;		LASCO/EIT LEB Program.  
;               
; Use         :  result = LP_NORMAL_IMAGE( caller )
;    
; Inputs      : caller	structure containing id of caller.
;               
; Opt. Inputs : None.
;               
; Outputs     : Always returns 1.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : OS_CALL_SCHEDULE, CW_BSELECTOR2, P_CHECK, X0(), Y0()
;
; Called From : DEFINE_OS
;
; Common      : OS_INIT_SHARE is defined in OS_INIT.
;		The following are defined in these routines.
;		LP_NORMAL_IMAGE_SHARE, lpnormv
;		LP_DARK_IMAGE_SHARE, lpdarkv
;		LP_CAL_LAMP_SHARE, lpcalv
;		LP_SEQ_PW_FW_SHARE, lpseqpwv
;		LP_FP_SCAN_LINE_SHARE, lpscanv
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
;**
;** Routine to initialize observation routines used by schedule.pro
;**
;** FUNCTION LP_NORMAL_IMAGE
;** FUNCTION LP_DARK_IMAGE
;** FUNCTION LP_CAL_LAMP
;** FUNCTION LP_SEQ_PW_FW
;** FUNCTION LP_CONT_IMAGE
;** FUNCTION LP_TAKE_SEQ
;** FUNCTION LP_CONCURRENT
;** FUNCTION LP_SUM_IMG
;** FUNCTION LP_MOVE_M1
;** FUNCTION LP_M1_MEASURE
;** FUNCTION LP_WOBBLE_IN
;** FUNCTION LP_WOBBLE_OUT
;** FUNCTION LP_CHK_CORR
;** FUNCTION LP_FP_SCAN_LINE
;** FUNCTION LP_FP_CAMCOORD
;** FUNCTION LP_GRND_PERIPH
;** FUNCTION LP_PERIPH_LOAD
;** FUNCTION LP_UP_DFLT_PRM
;** FUNCTION LP_GRND_MECH
;** FUNCTION LP_TRANS_DET
;** FUNCTION LP_DUMP_MEMORY
;** FUNCTION LP_STATUS_REQ
;** FUNCTION LP_NULL
;** FUNCTION OS_LP
;**
;**

;________________________________________________________________________________________________________
;
 
PRO LP_NORMAL_IMAGE_EVENT, event

COMMON OS_INIT_SHARE
COMMON LP_NORMAL_IMAGE_SHARE, lpnormv

CASE (event.id) OF

   lpnormv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpnormv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpnormv.schedule : BEGIN
      print, 'Normal Image Exposure'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpnormv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpnormv.telepd : BEGIN
      lpnormv.tele = event.index
      WIDGET_CONTROL, lpnormv.fwpd, SET_VALUE=fw_types(*,lpnormv.tele)
      WIDGET_CONTROL, lpnormv.fwpd, SET_VALUE=lpnormv.fw
      WIDGET_CONTROL, lpnormv.pwpd, SET_VALUE=pw_types(*,lpnormv.tele)
      WIDGET_CONTROL, lpnormv.pwpd, SET_VALUE=lpnormv.pw
   END
 
   lpnormv.iptable_pd : BEGIN
      lpnormv.iptable = event.index
   END

   lpnormv.table_pd : BEGIN
      lpnormv.table = event.index
   END

   lpnormv.fwpd : BEGIN
      lpnormv.fw = event.index
   END

   lpnormv.pwpd : BEGIN
      lpnormv.pw = event.index
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_NORMAL_IMAGE, caller

COMMON LP_NORMAL_IMAGE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_NORMAL_IMAGE") THEN RETURN, 1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 1
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpnormv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       tele = 0
       table = 0
       iptable = 0
       fw = 0
       pw = 0
    ENDIF ELSE BEGIN
       tele = lpnormv.tele
       table = lpnormv.table
       iptable = lpnormv.iptable
       fw = lpnormv.fw
       pw = lpnormv.pw
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP NORMAL_IMAGE', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW, /FRAME)

      col = WIDGET_BASE(row0, /COLUMN)
        telepd =  CW_BSELECTOR2(col, tele_types, SET_VALUE=tele)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
      col = WIDGET_BASE(row0, /COLUMN)
        fwpd = CW_BSELECTOR2(col, fw_types(*,tele), SET_VALUE=fw)
        pwpd = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    lpnormv = CREATE_STRUCT( 'base', base,			$
                             'telepd', telepd,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,		$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'fwpd', fwpd,			$
                             'pwpd', pwpd,			$
                             'fw', fw,				$
                             'pw', pw,				$
                             'tele', tele,			$
                             'table', table,			$
                             'iptable', iptable )

    XMANAGER, "LP_NORMAL_IMAGE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_DARK_IMAGE_EVENT, event

COMMON OS_INIT_SHARE
COMMON LP_DARK_IMAGE_SHARE, lpdarkv

CASE (event.id) OF

   lpdarkv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpdarkv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpdarkv.schedule : BEGIN
      print, 'Dark Image Exposure'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpdarkv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpdarkv.telepd : BEGIN
      lpdarkv.tele = event.index
   END
 
   lpdarkv.iptable_pd : BEGIN
      lpdarkv.iptable = event.index
   END

   lpdarkv.table_pd : BEGIN
      lpdarkv.table = event.index
   END

   lpdarkv.exp_text : BEGIN
      WIDGET_CONTROL, lpdarkv.exp_text, GET_VALUE=expt & expt = expt(0)
      temp = P_CHECK(expt,'expt',new) & WIDGET_CONTROL, lpdarkv.exp_text, SET_VALUE=new
      WIDGET_CONTROL, lpdarkv.exp_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpdarkv.expt = FIX(new)
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_DARK_IMAGE, caller

COMMON LP_DARK_IMAGE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_DARK_IMAGE") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 2
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpdarkv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       tele = 0
       table = 0
       iptable = 0
       expt = 0
    ENDIF ELSE BEGIN
       tele = lpdarkv.tele
       table = lpdarkv.table
       iptable = lpdarkv.iptable
       expt = lpdarkv.expt
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP DARK_IMAGE', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW)

      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
        telepd =  CW_BSELECTOR2(col, tele_types, SET_VALUE=tele)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
      row = WIDGET_BASE(col, /ROW)
        temp = WIDGET_LABEL(row, VALUE='Exposure Time:')
        exp_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(expt),2))

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)
    WIDGET_CONTROL, exp_text, /INPUT_FOCUS
    WIDGET_CONTROL, exp_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(expt),2))]

    lpdarkv = CREATE_STRUCT( 'base', base,			$
                             'telepd', telepd,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,	$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'exp_text', exp_text,		$
                             'expt', expt,			$
                             'tele', tele,			$
                             'table', table,			$
                             'iptable', iptable )

    XMANAGER, "LP_DARK_IMAGE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_CAL_LAMP_EVENT, event

COMMON LP_CAL_LAMP_SHARE, lpcalv
COMMON OS_INIT_SHARE

CASE (event.id) OF

   lpcalv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpcalv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpcalv.schedule : BEGIN
      print, 'Calibration Lamp Exposure'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpcalv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpcalv.telepd : BEGIN
      oldtele = lpcalv.tele
      lpcalv.tele = event.index
      WIDGET_CONTROL, lpcalv.fwpd, SET_VALUE=fw_types(*,lpcalv.tele)
      WIDGET_CONTROL, lpcalv.fwpd, SET_VALUE=0
      WIDGET_CONTROL, lpcalv.pwpd, SET_VALUE=pw_types(*,lpcalv.tele)
      WIDGET_CONTROL, lpcalv.pwpd, SET_VALUE=0
      IF (lpcalv.tele NE oldtele) THEN BEGIN 	;** only change lamp label(s) if tele changed
         p = WIDGET_INFO(lpcalv.lamppd, /PARENT)
         WIDGET_CONTROL, /DESTROY, lpcalv.lamppd
         IF (lpcalv.tele EQ 1) THEN BEGIN	;** change from label to pull down widget
            lpcalv.lamppd = CW_BSELECTOR2(p, lpcalv.lamp_types(1:2), SET_VALUE=lpcalv.lamp)
         ENDIF ELSE BEGIN			;** change from pull down widget to label
            lpcalv.lamppd = WIDGET_LABEL(p, VALUE=lpcalv.lamp_types(lpcalv.tele), /FRAME)
            lpcalv.lamp = 0
         ENDELSE
      ENDIF
   END
 
   lpcalv.lamppd : BEGIN
      lpcalv.lamp = event.index
   END

   lpcalv.iptable_pd : BEGIN
      lpcalv.iptable = event.index
   END

   lpcalv.table_pd : BEGIN
      lpcalv.table = event.index
   END

   lpcalv.fwpd : BEGIN
      lpcalv.fw = event.index
   END

   lpcalv.pwpd : BEGIN
      lpcalv.pw = event.index
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_CAL_LAMP, caller

COMMON LP_CAL_LAMP_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_CAL_LAMP") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 3
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpcalv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       tele = 0
       table = 0
       iptable = 0
       fw = 0
       pw = 0
       lamp = 0
    ENDIF ELSE BEGIN
       tele = lpcalv.tele
       table = lpcalv.table
       iptable = lpcalv.iptable
       fw = lpcalv.fw
       pw = lpcalv.pw
       lamp = lpcalv.lamp
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP CAL_LAMP', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW, /FRAME)

      col = WIDGET_BASE(row0, /COLUMN)
        telepd =  CW_BSELECTOR2(col, tele_types, SET_VALUE=tele)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
      col = WIDGET_BASE(row0, /COLUMN)
        fwpd = CW_BSELECTOR2(col, fw_types(*,tele), SET_VALUE=fw)
        pwpd = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw)
        lamp_types = ['Door Lamp        ',$
                      'Door Lamp        ',$
                      'Shutter Lamp     ',$
                      'CCD Lamp         ']
        IF (tele EQ 1) THEN lamppd = CW_BSELECTOR2(col, lamp_types(1:2), SET_VALUE=lamp) $
        ELSE lamppd = WIDGET_LABEL(col, VALUE=lamp_types(tele), /FRAME)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    lpcalv = CREATE_STRUCT( 'base', base,			$
                             'telepd', telepd,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,		$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'fwpd', fwpd,			$
                             'pwpd', pwpd,			$
                             'fw', fw,				$
                             'pw', pw,				$
                             'lamp_types', lamp_types,		$
                             'lamp', lamp,			$
                             'lamppd', lamppd,			$
                             'tele', tele,			$
                             'table', table,			$
                             'iptable', iptable )

    XMANAGER, "LP_CAL_LAMP", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_SEQ_PW_FW_EVENT, event

COMMON LP_SEQ_PW_FW_SHARE, lpseqpwv
COMMON OS_INIT_SHARE

CASE (event.id) OF

   lpseqpwv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpseqpwv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpseqpwv.schedule : BEGIN
      print, 'Sequence Polarizer at Filter'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpseqpwv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpseqpwv.telepd : BEGIN
      lpseqpwv.tele = event.index
      ;** set the fw for the given telescope
      WIDGET_CONTROL, lpseqpwv.fwpd, SET_VALUE=fw_types(*,lpseqpwv.tele)
      WIDGET_CONTROL, lpseqpwv.fwpd, SET_VALUE=0
      ;** set the pw number for the given telescope
      WIDGET_CONTROL, lpseqpwv.numpd, SET_VALUE=lpseqpwv.num_types(*,((lpseqpwv.tele-2)>0))
      IF (lpseqpwv.tele EQ 3) THEN maxnum = 4 ELSE maxnum = 5
      lpseqpwv.num = lpseqpwv.num < (maxnum-1)
      WIDGET_CONTROL, lpseqpwv.numpd, SET_VALUE=lpseqpwv.num
      ;** set the pw labels for the given telescope
      FOR i=0, 4 DO BEGIN
         WIDGET_CONTROL, lpseqpwv.pwpd(i), SET_VALUE=pw_types(*,lpseqpwv.tele)
         WIDGET_CONTROL, lpseqpwv.pwpd(i), SET_VALUE=lpseqpwv.pw(i)
         IF (i LE lpseqpwv.num) THEN WIDGET_CONTROL, lpseqpwv.pwpd(i), SENSITIVE=1 $
         ELSE WIDGET_CONTROL, lpseqpwv.pwpd(i), SENSITIVE=0
      ENDFOR
   END
 
   lpseqpwv.numpd : BEGIN
      lpseqpwv.num = event.index
      IF (lpseqpwv.tele EQ 3) THEN maxnum = 4 ELSE maxnum = 5
      lpseqpwv.num = lpseqpwv.num < (maxnum-1)
      WIDGET_CONTROL, lpseqpwv.numpd, SET_VALUE=lpseqpwv.num
      FOR i=0, 4 DO BEGIN
         WIDGET_CONTROL, lpseqpwv.pwpd(i), SET_VALUE=pw_types(*,lpseqpwv.tele)
         WIDGET_CONTROL, lpseqpwv.pwpd(i), SET_VALUE=lpseqpwv.pw(i)
         IF (i LE lpseqpwv.num) THEN WIDGET_CONTROL, lpseqpwv.pwpd(i), SENSITIVE=1 $
         ELSE WIDGET_CONTROL, lpseqpwv.pwpd(i), SENSITIVE=0
      ENDFOR
   END

   lpseqpwv.iptable_pd : BEGIN
      lpseqpwv.iptable = event.index
   END

   lpseqpwv.table_pd : BEGIN
      lpseqpwv.table = event.index
   END

   lpseqpwv.fwpd : BEGIN
      lpseqpwv.fw = event.index
   END

   ELSE : BEGIN		;** must be changing one of the PW positions
      i = WHERE(lpseqpwv.pwpd EQ event.id)
      lpseqpwv.pw(i(0)) = event.index
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_SEQ_PW_FW, caller

COMMON LP_SEQ_PW_FW_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_SEQ_PW_FW") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 4
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpseqpwv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       tele = 0
       table = 0
       iptable = 0
       fw = 0
       pw = [2,3,4,0,1]
       num = 4
    ENDIF ELSE BEGIN
       tele = lpseqpwv.tele
       table = lpseqpwv.table
       iptable = lpseqpwv.iptable
       fw = lpseqpwv.fw
       num = lpseqpwv.num
       pw = lpseqpwv.pw
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP SEQ_PW_FW', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW)

      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
        telepd =  CW_BSELECTOR2(col, tele_types, SET_VALUE=tele)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
        fwpd = CW_BSELECTOR2(col, fw_types(*,tele), SET_VALUE=fw)
        num_types = [ ['1 Polarizer Position ',	$	; (5,2) array: (*,0) for C1-3, (*,1) for EIT
                       '2 Polarizer Positions',	$
                       '3 Polarizer Positions',	$
                       '4 Polarizer Positions',	$
                       '5 Polarizer Positions'],$
                      ['1 Sector    Position ',	$
                       '2 Sector    Positions',	$
                       '3 Sector    Positions',	$
                       '4 Sector    Positions',	$
                       '                     ']]
        numpd = CW_BSELECTOR2(col, num_types(*,((tele-2)>0)), SET_VALUE=num-1)

      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
        pwpd = LONARR(5)
        pwpd(0) = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw(0))
        pwpd(1) = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw(1))
        pwpd(2) = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw(2))
        pwpd(3) = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw(3))
        pwpd(4) = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw(4))

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)
    FOR i=0, 4 DO BEGIN
       IF (i LT num) THEN WIDGET_CONTROL, pwpd(i), SENSITIVE=1 $
       ELSE WIDGET_CONTROL, pwpd(i), SENSITIVE=0
    ENDFOR

    lpseqpwv = CREATE_STRUCT('base', base,			$
                             'telepd', telepd,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,		$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'pwpd', pwpd,			$
                             'pw', pw,				$
                             'fwpd', fwpd,			$
                             'fw', fw,				$
                             'num', num,			$
                             'numpd', numpd,			$
                             'num_types', num_types,		$
                             'tele', tele,			$
                             'table', table,			$
                             'iptable', iptable )

    XMANAGER, "LP_SEQ_PW_FW", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_CONT_IMAGE_EVENT, event

COMMON LP_CONT_IMAGE_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_CONT_IMAGE, caller

COMMON LP_CONT_IMAGE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_CONT_IMAGE") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 5

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP CONT_IMAGE', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_CONT_IMAGE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_TAKE_SEQ_EVENT, event

COMMON LP_TAKE_SEQ_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_TAKE_SEQ, caller

COMMON LP_TAKE_SEQ_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_TAKE_SEQ") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 6

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP TAKE_SEQ', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_TAKE_SEQ", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_CONCURRENT_EVENT, event

COMMON LP_CONCURRENT_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_CONCURRENT, caller

COMMON LP_CONCURRENT_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_CONCURRENT") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 7

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP CONCURRENT', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_CONCURRENT", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_SUM_IMG_EVENT, event

COMMON OS_INIT_SHARE
COMMON LP_SUM_IMG_SHARE, lpsumv

CASE (event.id) OF

   lpsumv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpsumv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpsumv.schedule : BEGIN
      print, 'Sequence Take Sum'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpsumv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpsumv.telepd : BEGIN
      lpsumv.tele = event.index
      WIDGET_CONTROL, lpsumv.fwpd, SET_VALUE=fw_types(*,lpsumv.tele)
      WIDGET_CONTROL, lpsumv.fwpd, SET_VALUE=lpsumv.fw
      WIDGET_CONTROL, lpsumv.pwpd, SET_VALUE=pw_types(*,lpsumv.tele)
      WIDGET_CONTROL, lpsumv.pwpd, SET_VALUE=lpsumv.pw
   END
 
   lpsumv.num_text : BEGIN
      WIDGET_CONTROL, lpsumv.num_text, GET_VALUE=numt & numt = numt(0)
      temp = P_CHECK(numt,'leb_sum',new) & WIDGET_CONTROL, lpsumv.num_text, SET_VALUE=new
      WIDGET_CONTROL, lpsumv.num_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpsumv.num = FIX(new)
   END
 
   lpsumv.iptable0_pd : BEGIN
      lpsumv.iptable0 = event.index
   END
   lpsumv.iptable1_pd : BEGIN
      lpsumv.iptable1 = event.index
   END
   lpsumv.iptable2_pd : BEGIN
      lpsumv.iptable2 = event.index
   END
 
   lpsumv.table_pd : BEGIN
      lpsumv.table = event.index
   END
 
   lpsumv.fwpd : BEGIN
      lpsumv.fw = event.index
   END
 
   lpsumv.pwpd : BEGIN
      lpsumv.pw = event.index
   END
 
   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_SUM_IMG, caller

COMMON OS_INIT_SHARE
COMMON LP_SUM_IMG_SHARE

    IF XRegistered("LP_SUM_IMG") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 8
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpsumv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       tele = 0
       table = 0
       iptable0 = 0
       iptable1 = 0
       iptable2 = 0
       fw = 0
       pw = 0
       num = 1
    ENDIF ELSE BEGIN
       tele = lpsumv.tele
       table = lpsumv.table
       iptable0 = lpsumv.iptable0
       iptable1 = lpsumv.iptable1
       iptable2 = lpsumv.iptable2
       fw = lpsumv.fw
       pw = lpsumv.pw
       num = lpsumv.num
    ENDELSE


    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP SUM_IMG', /FRAME, $
             GROUP_LEADER=caller.id)

      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')
 
      row0 = WIDGET_BASE(base, /ROW)
 
      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
        telepd =  CW_BSELECTOR2(col, tele_types, SET_VALUE=tele)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        fwpd = CW_BSELECTOR2(col, fw_types(*,tele), SET_VALUE=fw)
        pwpd = CW_BSELECTOR2(col, pw_types(*,tele), SET_VALUE=pw)
 
      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
        num_text = WIDGET_TEXT(col, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(num),2))
        iptable0_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable0)
        iptable1_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable1)
        iptable2_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable2)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    lpsumv = CREATE_STRUCT('base', base,                      $
                             'telepd', telepd,                  $
                             'table_pd', table_pd,              $
                             'iptable0_pd', iptable0_pd,          $
                             'iptable1_pd', iptable1_pd,          $
                             'iptable2_pd', iptable2_pd,          $
                             'dismiss', dismiss,                $
                             'schedule', schedule,              $
                             'pwpd', pwpd,                      $
                             'pw', pw,                          $
                             'fwpd', fwpd,                      $
                             'fw', fw,                          $
                             'num', num,                        $
                             'num_text', num_text,                    $
                             'tele', tele,                      $
                             'table', table,                    $
                             'iptable0', iptable0,                    $
                             'iptable1', iptable1,                    $
                             'iptable2', iptable2 )


    XMANAGER, "LP_SUM_IMG", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_MOVE_M1_EVENT, event

COMMON LP_MOVE_M1_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_MOVE_M1, caller

COMMON LP_MOVE_M1_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_MOVE_M1") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 9

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP MOVE_M1', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_MOVE_M1", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_M1_MEASURE_EVENT, event

COMMON LP_M1_MEASURE_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_M1_MEASURE, caller

COMMON LP_M1_MEASURE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_M1_MEASURE") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 10

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP M1_MEASURE', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_M1_MEASURE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;

PRO LP_WOBBLE_IN_EVENT, event

COMMON LP_WOBBLE_IN_SHARE, lpwobinv
COMMON OS_INIT_SHARE

CASE (event.id) OF

   lpwobinv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpwobinv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpwobinv.schedule : BEGIN
      print, 'FP Wobble In'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpwobinv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpwobinv.iptable_pd : BEGIN
      lpwobinv.iptable = event.index
   END

   lpwobinv.table_pd : BEGIN
      lpwobinv.table = event.index
   END

   lpwobinv.fwpd : BEGIN
      lpwobinv.fw = event.index
   END

   lpwobinv.pwpd : BEGIN
      lpwobinv.pw = event.index
   END

   lpwobinv.num_text : BEGIN
      WIDGET_CONTROL, lpwobinv.num_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'num',new) & WIDGET_CONTROL, lpwobinv.num_text, SET_VALUE=new
      WIDGET_CONTROL, lpwobinv.num_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpwobinv.num = FIX(new)
   END

   lpwobinv.start_text : BEGIN
      WIDGET_CONTROL, lpwobinv.start_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'start',new) & WIDGET_CONTROL, lpwobinv.start_text, SET_VALUE=new
      WIDGET_CONTROL, lpwobinv.start_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpwobinv.start = FIX(new)
   END

   lpwobinv.subpd : BEGIN
      lpwobinv.sub = event.index
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_WOBBLE_IN, caller

COMMON LP_WOBBLE_IN_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_WOBBLE_IN") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 11
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpwobinv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       table = 0
       iptable = 0
       fw = 0
       pw = 0
       num = 1
       start = 0
    ENDIF ELSE BEGIN
       table = lpwobinv.table
       iptable = lpwobinv.iptable
       fw = lpwobinv.fw
       pw = lpwobinv.pw
       num = lpwobinv.num
       start = lpwobinv.start
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP WOBBLE_IN', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW, /FRAME)

      col = WIDGET_BASE(row0, /COLUMN)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
        row = WIDGET_BASE(col, /ROW)
           temp = WIDGET_LABEL(row, VALUE=' # WL Steps:')
           num_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(num),2))
      col = WIDGET_BASE(row0, /COLUMN)
        fwpd = CW_BSELECTOR2(col, fw_types(*,0), SET_VALUE=fw)
        pwpd = CW_BSELECTOR2(col, pw_types(*,0), SET_VALUE=pw)
        row = WIDGET_BASE(col, /ROW)
           temp = WIDGET_LABEL(row, VALUE='Start Index:')
           start_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(start),2))

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    lpwobinv = CREATE_STRUCT( 'base', base,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,		$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'fwpd', fwpd,			$
                             'pwpd', pwpd,			$
                             'fw', fw,				$
                             'pw', pw,				$
                             'num_text', num_text,		$
                             'start_text', start_text,		$
                             'num', num,			$
                             'table', table,			$
                             'start', start,			$
                             'iptable', iptable )

    XMANAGER, "LP_WOBBLE_IN", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_WOBBLE_OUT_EVENT, event

COMMON LP_WOBBLE_OUT_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_WOBBLE_OUT, caller

COMMON LP_WOBBLE_OUT_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_WOBBLE_OUT") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 12

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP WOBBLE_OUT', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_WOBBLE_OUT", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_CHK_CORR_EVENT, event

COMMON LP_CHK_CORR_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_CHK_CORR, caller

COMMON LP_CHK_CORR_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_CHK_CORR") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 13

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP CHK_CORR', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_CHK_CORR", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_FP_SCAN_LINE_EVENT, event

COMMON LP_FP_SCAN_LINE_SHARE, lpscanv
COMMON OS_INIT_SHARE

CASE (event.id) OF

   lpscanv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpscanv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpscanv.schedule : BEGIN
      print, 'FP Scan Line'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpscanv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpscanv.iptable_pd : BEGIN
      lpscanv.iptable = event.index
   END

   lpscanv.table_pd : BEGIN
      lpscanv.table = event.index
   END

   lpscanv.fwpd : BEGIN
      lpscanv.fw = event.index
   END

   lpscanv.pwpd : BEGIN
      lpscanv.pw = event.index
   END

   lpscanv.num_text : BEGIN
      WIDGET_CONTROL, lpscanv.num_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'num',new) & WIDGET_CONTROL, lpscanv.num_text, SET_VALUE=new
      WIDGET_CONTROL, lpscanv.num_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpscanv.num = FIX(new)
   END

   lpscanv.start_text : BEGIN
      WIDGET_CONTROL, lpscanv.start_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'start',new) & WIDGET_CONTROL, lpscanv.start_text, SET_VALUE=new
      WIDGET_CONTROL, lpscanv.start_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpscanv.start = FIX(new)
   END

   lpscanv.subpd : BEGIN
      lpscanv.sub = event.index
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_FP_SCAN_LINE, caller

COMMON LP_FP_SCAN_LINE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_FP_SCAN_LINE") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 14
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpscanv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       table = 0
       iptable = 0
       fw = 0
       pw = 0
       sub = 0
       num = 1
       start = 0
    ENDIF ELSE BEGIN
       table = lpscanv.table
       iptable = lpscanv.iptable
       fw = lpscanv.fw
       pw = lpscanv.pw
       sub = lpscanv.sub
       num = lpscanv.num
       start = lpscanv.start
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP FP_SCAN_LINE', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW, /FRAME)

      col = WIDGET_BASE(row0, /COLUMN)
        table_pd = CW_BSELECTOR2(col, table_types, SET_VALUE=table)
        iptable_pd = CW_BSELECTOR2(col, proc_tab_types, SET_VALUE=iptable)
        sub_types = ["Do not Use Sub-Regions", $
                     "Use Sub-Regions       "]
        subpd = CW_BSELECTOR2(col, sub_types, SET_VALUE=sub)
      col = WIDGET_BASE(row0, /COLUMN)
        fwpd = CW_BSELECTOR2(col, fw_types(*,0), SET_VALUE=fw)
        pwpd = CW_BSELECTOR2(col, pw_types(*,0), SET_VALUE=pw)
        row = WIDGET_BASE(col, /ROW)
           temp = WIDGET_LABEL(row, VALUE=' # WL Steps:')
           num_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(num),2))
        row = WIDGET_BASE(col, /ROW)
           temp = WIDGET_LABEL(row, VALUE='Start Index:')
           start_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(start),2))

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    lpscanv = CREATE_STRUCT( 'base', base,			$
                             'table_pd', table_pd,		$
                             'iptable_pd', iptable_pd,		$
                             'dismiss', dismiss,		$
                             'schedule', schedule,		$
                             'fwpd', fwpd,			$
                             'pwpd', pwpd,			$
                             'fw', fw,				$
                             'pw', pw,				$
                             'subpd', subpd,			$
                             'sub', sub,			$
                             'num_text', num_text,		$
                             'start_text', start_text,		$
                             'num', num,			$
                             'table', table,			$
                             'start', start,			$
                             'iptable', iptable )

    XMANAGER, "LP_FP_SCAN_LINE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_FP_CAMCOORD_EVENT, event

COMMON LP_FP_CAMCOORD_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_FP_CAMCOORD, caller

COMMON LP_FP_CAMCOORD_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_FP_CAMCOORD") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 15

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP FP_CAMCOORD', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_FP_CAMCOORD", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_GRND_PERIPH_EVENT, event

COMMON LP_GRND_PERIPH_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_GRND_PERIPH, caller

COMMON LP_GRND_PERIPH_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_GRND_PERIPH") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 16

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP GRND_PERIPH', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_GRND_PERIPH", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_PERIPH_LOAD_EVENT, event

COMMON LP_PERIPH_LOAD_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_PERIPH_LOAD, caller

COMMON LP_PERIPH_LOAD_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_PERIPH_LOAD") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 17

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP PERIPH_LOAD', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_PERIPH_LOAD", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_UP_DFLT_PRM_EVENT, event

COMMON LP_UP_DFLT_PRM_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_UP_DFLT_PRM, caller

COMMON LP_UP_DFLT_PRM_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_UP_DFLT_PRM") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 18

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP UP_DFLT_PRM', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_UP_DFLT_PRM", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_GRND_MECH_EVENT, event

COMMON LP_GRND_MECH_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_GRND_MECH, caller

COMMON LP_GRND_MECH_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_GRND_MECH") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 19

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP GRND_MECH', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_GRND_MECH", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_TRANS_DET_EVENT, event

COMMON LP_TRANS_DET_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_TRANS_DET, caller

COMMON LP_TRANS_DET_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_TRANS_DET") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 20

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP TRANS_DET', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_TRANS_DET", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_DUMP_MEMORY_EVENT, event

COMMON LP_DUMP_MEMORY_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_DUMP_MEMORY, caller

COMMON LP_DUMP_MEMORY_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_DUMP_MEMORY") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 21

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP DUMP_MEMORY', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_DUMP_MEMORY", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_STATUS_REQ_EVENT, event

COMMON LP_STATUS_REQ_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_STATUS_REQ, caller

COMMON LP_STATUS_REQ_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_STATUS_REQ") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 22

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP STATUS_REQ', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_STATUS_REQ", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_CMD_TABLE_EVENT, event

COMMON OS_INIT_SHARE
COMMON LP_CMD_TABLE_SHARE, lpcmdv

CASE (event.id) OF

   lpcmdv.dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpcmdv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END

   lpcmdv.schedule : BEGIN
      print, 'CMD Table Schedule'
      OS_CALL_SCHEDULE
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, lpcmdv.base
      WIDGET_CONTROL, lprow, SENSITIVE=1
   END
 
   lpcmdv.start_text : BEGIN
      WIDGET_CONTROL, lpcmdv.start_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'cmd',new) & WIDGET_CONTROL, lpcmdv.start_text, SET_VALUE=new
      WIDGET_CONTROL, lpcmdv.start_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpcmdv.start = FIX(new)
   END

   lpcmdv.stop_text : BEGIN
      WIDGET_CONTROL, lpcmdv.stop_text, GET_VALUE=num & num = num(0)
      temp = P_CHECK(num,'cmd',new) & WIDGET_CONTROL, lpcmdv.stop_text, SET_VALUE=new
      WIDGET_CONTROL, lpcmdv.stop_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(new),2))]
      lpcmdv.stop = FIX(new)
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_CMD_TABLE, caller

COMMON LP_CMD_TABLE_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_CMD_TABLE") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 23
    WIDGET_CONTROL, lprow, SENSITIVE=0

    IF ((SIZE(lpcmdv))(1) EQ 0) THEN BEGIN          ;** not defined yet use default
       start = 0
       stop = 0
    ENDIF ELSE BEGIN
       start = lpcmdv.start
       stop = lpcmdv.stop
    ENDELSE

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP CMD_TABLE', /FRAME, $
             GROUP_LEADER=caller.id)
      schedule = WIDGET_BUTTON(base, VALUE=' Insert into Plan ')

      row0 = WIDGET_BASE(base, /ROW)

      col = WIDGET_BASE(row0, /COLUMN, /FRAME)
      row = WIDGET_BASE(col, /ROW)
        temp = WIDGET_LABEL(row, VALUE='Start Index:')
        start_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(start),2))
      row = WIDGET_BASE(col, /ROW)
        temp = WIDGET_LABEL(row, VALUE=' Stop Index:')
        stop_text = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=4, VALUE=STRTRIM(STRING(stop),2))

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)
    WIDGET_CONTROL, start_text, /INPUT_FOCUS
    WIDGET_CONTROL, start_text, SET_TEXT_SELECT=[STRLEN(STRTRIM(STRING(start),2))]

    lpcmdv = CREATE_STRUCT( 'base', base,			$
                             'start_text', start_text,		$
                             'start', start,			$
                             'stop_text', stop_text,		$
                             'stop', stop,			$
                             'dismiss', dismiss,		$
                             'schedule', schedule)

    XMANAGER, "LP_CMD_TABLE", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;
 
PRO LP_NULL_EVENT, event

COMMON LP_NULL_SHARE, base, dismiss
COMMON OS_INIT_SHARE

CASE (event.id) OF

   dismiss : BEGIN	;** exit program
      plan_lp = 0
      WIDGET_CONTROL, /DESTROY, base
   END

   ELSE : BEGIN
   END

ENDCASE

END

;________________________________________________________________________________________________________
;

FUNCTION LP_NULL, caller

COMMON LP_NULL_SHARE
COMMON OS_INIT_SHARE

    IF XRegistered("LP_NULL") THEN RETURN,1
    IF (plan_lp) THEN RETURN,1 ELSE plan_lp = 24

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    base = WIDGET_BASE(/COLUMN, TITLE='LP NULL', /FRAME, $
             GROUP_LEADER=caller.id)

     dismiss = WIDGET_BUTTON(base, VALUE=' Dismiss ')

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, /REAL, base
    WIDGET_CONTROL, base, TLB_SET_XOFFSET=X0(base), TLB_SET_YOFFSET=Y0(base)

    XMANAGER, "LP_NULL", base

    RETURN, 1

END

;________________________________________________________________________________________________________
;

PRO OS_LP
END
