;+
; Project     : SOHO - LASCO/EIT
;                   
; Name        : OS_STATS
;               
; Purpose     : Calculates time to process and processed size for LASCO/EIT OS.
;               
; Explanation : This routine reads in the test data from 'test_data.dat'.  Then
;		compares the current OS setup to the test data to get statistics
;		on the time to process the image(s) and the processed image size.
;               
; Use         : OS_STATS, os_duration, os_size, obs_mode_id
;    
; Inputs      : None.
;               
; Opt. Inputs : None.
;               
; Outputs     : os_duration		time in secs to process image(s) (DOUBLE).
;		os_size		size in bits of processed image(s) (LONG).
;		obs_mode_id	The unique ID of this observing mode.
;               
; Opt. Outputs: None.
;               
; Keywords    : None.
;
; Calls       : GET_PLAN_LP_INFO
;
; Common      : OS_SHARE 		Defined in DEFINE_OS.
;		OS_INIT_SHARE 		Defined in OS_INIT.
;		OS_ALL_SHARE		Defined in OS_INIT.PRO
;		OS_TEST_DATA_SHARE	Defined in this routine.
;		OS_TABLE_CAMERA_SHARE	Defined in OS_TABLES.PRO
;               
; Restrictions: None.
;               
; Side effects: None.
;               
; Category    : Planning, Scheduling.
;               
; Prev. Hist. : None.
;
; Written     : Scott Paswaters, NRL, November 1994.
;               
; Modified    : 
;
; Version     : Version 0.1, December 5, 1994
;-            

;__________________________________________________________________________________________________________
;
PRO OS_STATS, os_duration, os_size, obs_mode_id

COMMON OS_SHARE
COMMON OS_INIT_SHARE
COMMON OS_ALL_SHARE
COMMON OS_DEFINED

COMMON OS_TABLE_CAMERA_SHARE

   info_text = osv.info_text
   ;** first erase current values
   new_value = 0D
   WIDGET_CONTROL, osv.time_text, SET_VALUE=STRING(new_value,FORMAT='(i5)')+' secs'
   WIDGET_CONTROL, osv.size_text, SET_VALUE=STRING(new_value,FORMAT='(d10.1)')
   WIDGET_CONTROL, osv.comp_text, SET_VALUE=STRING(new_value,FORMAT='(d5.1)')+' %'

   WIDGET_CONTROL, /HOUR

   WIDGET_CONTROL, info_text, SET_VALUE='Calculating Statistics ....'

   ;** GET VARS FOR GIVEN LP BEING SCHEDULED
   result = GET_PLAN_LP_INFO( tele, table, iptable, fw, pw, lamp, lp_num_images, ex_table, sub, start )
   IF (result LT 0) THEN BEGIN ;** Error. or LP_CMD_TABLE
      os_duration=1
      os_size=1
      RETURN		
   ENDIF

   an_os = os_instance                      ;** os_instance defined in OS_DEFINED COMMON

   an_os.lp = plan_lp
   an_os.tele = tele
   an_os.table = table
   an_os.iptable = iptable
   an_os.fw = fw
   an_os.pw = pw
   an_os.lamp = lamp
   an_os.num_images = lp_num_images
   an_os.ex = ex_table
   an_os.ccd = ccd
   an_os.ip = ip
   an_os.occ_blocks = occ_blocks
   an_os.roi_blocks = roi_blocks
   an_os.fpwl = fpwl

   GET_OS_DB_STATS, an_os, os_size, os_duration, DOORCLOSED=osv.door

   IF (os_size LE 1) THEN $
      WIDGET_CONTROL, info_text, SET_VALUE='No Statistics Found for Given Observing Mode'

   ;** UPDATE STATS IN BASE SCHED WINDOW
   WIDGET_CONTROL, info_text, GET_VALUE=tmp
   IF (tmp EQ 'Calculating Statistics ....') THEN $
      WIDGET_CONTROL, info_text, SET_VALUE='   '
   WIDGET_CONTROL, osv.time_text, SET_VALUE=STRING(os_duration,FORMAT='(i5)')+' secs'

   ;** convert units
   WIDGET_CONTROL, osv.bits_bytes, GET_VALUE=to
   new_value = SCHEDULE_CONVERT_UNITS(os_size, 0, to)
   WIDGET_CONTROL, osv.size_text, SET_VALUE=STRING(new_value,FORMAT='(d10.1)')

   new_value = 0D
   WIDGET_CONTROL, osv.comp_text, SET_VALUE=STRING(new_value,FORMAT='(d5.1)')+' %'

END
