
;** THIS ROUTINE LOOKS UP os_num IN THE defined_os_arr
;** AND OUTPUTS AN ASCII SUMMARY OF ALL OS's

PRO OS_SUMMARY_1LINE, iptname

COMMON OP_SCHEDULED
COMMON OS_DEFINED
COMMON OS_SCHEDULED
COMMON OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, proc_tab_types, $
   ip_arr, plan_lp, lprow

   IF (DATATYPE(os_arr(0)) EQ 'INT') THEN BEGIN
      PRINT, "%%OS_SUMMARY_1LINE: No OS's scheduled"
      RETURN
   ENDIF

   IF (N_PARAMS() EQ 1) THEN PRINT,'%%CREATING SUMMARY FILE: ',iptname

   os_arr2 = os_arr(SORT([os_arr.os_num]))   ;** sort on os_num
   uniq_os_arr2 = os_arr2(UNIQ([os_arr2.os_num]))
   num_os = N_ELEMENTS(uniq_os_arr2)
 
   IF (SEXIST(tele_types) EQ 0) THEN OS_INIT	;** define some variables

str_arr_all = ''

   counter = 0
   FOR i = num_os-1, 0, -1 DO BEGIN    ;** for every unique os_num

      os_num = uniq_os_arr2(i).os_num

      ind = WHERE(defined_os_arr.os_num EQ os_num)

      IF (ind(0) LT 0) THEN GOTO, CONT

      os = defined_os_arr(ind)
      lp = defined_os_arr(ind).lp
      tele = defined_os_arr(ind).tele
      fw = defined_os_arr(ind).fw
      pw = defined_os_arr(ind).pw
      table = defined_os_arr(ind).table
      iptable = defined_os_arr(ind).iptable
      lamp = defined_os_arr(ind).lamp
      start = defined_os_arr(ind).start
      num_images = defined_os_arr(ind).num_images
      ccd = defined_os_arr(ind).ccd
      ip = defined_os_arr(ind).ip
      ex = defined_os_arr(ind).ex
      occ_blocks = REFORM(defined_os_arr(ind).occ_blocks(tele,*))
      roi_blocks = REFORM(defined_os_arr(ind).roi_blocks(tele,*))
      fpwl = defined_os_arr(ind).fpwl

   IF (lp EQ 8) THEN BEGIN          ;** Take Sum
      ;iptable = [defined_os_arr(ind).iptable, defined_os_arr(ind).pw(1), defined_os_arr(ind).pw(2)]
      pw = defined_os_arr(ind).pw(0)
   ENDIF

   indm = WHERE(ip(iptable).steps EQ 27)
   IF (indm(0) LT 0) THEN useocc = 1 ELSE useocc = 0
   indm = WHERE(ip(iptable).steps EQ 25)
   IF (indm(0) LT 0) THEN useroi = 0 ELSE useroi = 1
   CASE (1) OF
      ((useocc EQ 1) AND (useroi EQ 0)) : BEGIN
         blocks = WHERE(occ_blocks GT 0,num)
         blockstr = 'Occulter (' + STRTRIM(num,2) + ' blocks)'
      END
      ((useroi EQ 1) AND (useocc EQ 0)) : BEGIN
         blocks = WHERE(roi_blocks GT 0,num)
         blockstr = 'ROI (' + STRTRIM(num,2) + ' blocks)'
      END
      ((useroi EQ 1) AND (useocc EQ 1)) : BEGIN
         blocks = WHERE((occ_blocks+roi_blocks) GT 0,num)
         blockstr = 'Occulter & ROI (' + STRTRIM(num,2) + ' blocks)'
      END
      ELSE : BEGIN
         blocks = -1
         blockstr = 'None'
      END
   ENDCASE

      ;** convert from LP num defined in define_os (op_types) to
      ;** actual LP num as understood by the LEB
      lptmp = [0,9,5,17,14,7,20,16,19,21,2,3,4,6,8,15,11,12,13,18,22,10,1,24,0]


      tos_num = '  '+STRTRIM(STRING(os_num),2)
      ttele = '  '+STRMID(tele_types(tele),11,3)
      tlp = '  '+STRING(op_types(lp-1),FORMAT='(a12)')+' '
      tfw = ' '+STRING(CNVRT_FILTER(tele,fw), FORMAT='(a7)')+' '

      ccd = ccd(tele,table)
      tnx = STRING((ccd.x2 - ccd.x1+1), FORMAT='(i5)')
      tny = STRING((ccd.y2 - ccd.y1+1), FORMAT='(i5)')
      xs = ccd.xsum > 1
      ys = ccd.ysum > 1
      tsum=' '+STRING(xs, FORMAT='(i1)')+'x'+STRING(ys, FORMAT='(i1)')

      ;** check for LEB summing
      good = WHERE(ip(iptable).steps EQ 4, nip)
      nip = nip*2 > 1
      tlsum=' '+STRING(nip, FORMAT='(i1)')+'x'+STRING(nip, FORMAT='(i1)')

      ind2 = WHERE(os_arr.os_num EQ os_num)
      num_scheduled = N_ELEMENTS(ind2)

      FOR s=0, num_scheduled-1 DO BEGIN	;** loop over num_scheduled

         os_start = os_arr(ind2(s)).os_start
         tdate_obs = STRMID(UTC2STR(TAI2UTC(os_start), /ECS),0,16)

         twl = '          '
         IF (DATATYPE(move_fp) EQ 'STC') THEN BEGIN
            cind = WHERE((os_num EQ move_fp.os_num) AND (os_start EQ move_fp.os_start))
            IF (cind(0) NE -1) THEN BEGIN
               twl = ' '+STRING(move_fp(cind(0)).wl,FORMAT='(f9.4)')
            ENDIF
         ENDIF

         IF (lp EQ 14) THEN BEGIN          ;** FP WL Scan, output wl/exp table instead of pw/exp pairs

            tpw = ' '+STRING(CNVRT_POLAR(tele,pw(0)), FORMAT='(a7)')
            fpwl2 = REFORM(fpwl(table, fw, *))
            FOR n=start, start+num_images -1 DO BEGIN    ;** for each wl/exp position
               twl = ' '+STRING(fpwl2(n).wl,FORMAT='(f9.4)')
               texp = ' '+STRING(FIX(fpwl2(n).exp)/32+2,FORMAT='(i4)') + '  '
               counter = counter+1
               tcntr = STRING(counter,FORMAT='(i4)')
str = tdate_obs+tcntr+ ttele+ texp+ tnx+ tny+ tsum+tlsum+ tfw+ tpw+ tlp+ twl+ tos_num
str_arr_all = [str_arr_all, str]
            ENDFOR

         ENDIF ELSE BEGIN                  ;** output pw/exp pairs

            IF (lp EQ 23) THEN BEGIN          ;** CMD Table
str = tdate_obs+ '     Command Table Entry '+STRTRIM(start,2)+ ' to Entry '+STRTRIM(num_images,2)
str_arr_all = [str_arr_all, str]
            ENDIF ELSE BEGIN
               IF (lp EQ 8) THEN num_images = 1	;** Take Sum LP
               FOR n=0, num_images -1 DO BEGIN        ;** for each pw position
                  IF (tele EQ 3) THEN nchar = 1 ELSE nchar = 10
                  tpw = ' '+STRING(CNVRT_POLAR(tele,pw(n)), FORMAT='(a7)')
                  texp = ' '+STRING(FIX(ex(tele,table,fw,pw(n))/32+2),FORMAT='(i4)') + '  '
                  counter = counter+1
                  tcntr = STRING(counter,FORMAT='(i4)')
str = tdate_obs+tcntr+ ttele+ texp+ tnx+ tny+ tsum+tlsum+ tfw+ tpw+ tlp+ twl+ tos_num
str_arr_all = [str_arr_all, str]
               ENDFOR
            ENDELSE

         ENDELSE
   ENDFOR

      CONT:
 
   ENDFOR

   str_arr_all = str_arr_all(1:*)
   inds = SORT(str_arr_all)
   str_arr_all(inds(0)) = ' '+str_arr_all(inds(0)) 
   str_arr_all = STRMID(str_arr_all,0,17) + STRMID(str_arr_all,21,STRLEN(str_arr_all(0))-1)

   IF (N_PARAMS() EQ 1) THEN BEGIN
      OPENW, LUN, iptname, /GET_LUN
      PRINTF, LUN, '                               r/o size  Bining'
      PRINTF, LUN, ' Date Obs         Tele  Exp    Nx   Ny  CCD LEB  Filter    Polar  LEB Program   Wavelength OS_NUM'
      PRINTF, LUN, str_arr_all(inds)
      CLOSE, LUN
      FREE_LUN, LUN
      PRINT,'%%DONE CREATING SUMMARY FILE: ',iptname
   ENDIF ELSE BEGIN
      print, str_arr_all(inds)
   ENDELSE

END
