PRO pt_gen_occ_cmd,obeblocks,tele,mask_type
;
;  procedure to convert the obeblocks for an occulter mask
;  into a scenario file of 4 commands
;
REPEAT BEGIN
   fname_out = PICKFILE(/WRITE, FILTER='*.sce')
ENDREP UNTIL (fname_out NE '')
PRINT,'Writing occulter mask commands to '+fname_out
OPENW,luout,fname_out,/GET_LUN
lp_num = 13			; occulter upload
num_words = 28
destination = '63'x
lcf_cmd_id = '91'x
cmd = INTARR(num_words)
FOR icmd=0,3 DO BEGIN
    data = LONARR(8)
;
;  exit by iteration count of 1
;
    cmd(0) = (ISHFT(2,8) OR lp_num)
    cmd(4) = 0
    cmd(5) = 0
    cmd(6) = 1
;
;  start time
;
    cmd(1) = 0		; tai(0)
    cmd(2) = 0		; tai(1)
    cmd(3) = 0		; tai(2)
;
;  Occulter Mask Command
;
    cmd(7) = 19		; number of parameters to follow
    CASE mask_type OF
       'OCCULTER':   cmd(8)=3		; type of table - occulter
       'ROI':        cmd(8)=2		; type of table - ROI
       default:      cmd(8)=2		; type of table - ROI
    ENDCASE
    cmd(9) = tele	; telescope number
    cmd(10) = 16*icmd	; start entry (0,16,32,48)
    ok = ''
    blocks = obeblocks(icmd*16:icmd*16+15) AND 'ffff'x
    FOR i=0,15 DO cmd(11+i) = obeblocks(i+icmd*16) AND 'ffff'x
    ; write out the SIS message
    ;so_path = ''
    ;cmd_string = CALL_EXTERNAL(so_path+'build_sis_msg.so', 'build_sis_msg', $
    ;             num_words, destination, lcf_cmd_id, cmd, /S_VALUE)
    build_sis_msg , num_words, destination, lcf_cmd_id, cmd, cmd_string)
    IF (STRLEN(cmd_string) EQ 223)  THEN BEGIN
       PRINTF,luout,cmd_string
    ENDIF ELSE BEGIN
       PRINT,'%%GEN_OCC_CMD: build_sis_msg error'
    ENDELSE

ENDFOR
PRINTF,luout,'*'
CLOSE,luout
FREE_LUN,luout
RETURN
END

