; function takes string of dates in the format required for the planning tool output
; ex. (19951020_000000,19951020_003000)
; and returns an array of UTC date structures (utc = {cds_int_time, mjd:0L, time:0L})
; 
FUNCTION PTDATE2UTC, date_str

   str = STRTRIM(date_str, 2)
   IF ( STRMID(str,0,1) EQ '(' ) THEN $
      str = STRMID(date_str, 1, STRLEN(date_str)-2)	;** clip off "(" and ")"
   d_arr = STR2ARR(str, DELIM=",")
   d_arr = STRTRIM(d_arr, 2)

   d = STRMID(d_arr,0,4)+'/'+STRMID(d_arr,4,2)+'/'+STRMID(d_arr,6,2)+' '+STRMID(d_arr,9,2)+ $
       ':'+STRMID(d_arr,11,2)+':'+STRMID(d_arr,13,2)

   utc = STR2UTC(d)
   RETURN, utc
END
