;+
; NAME:
;	READ_IP_DAT
;
; PURPOSE:
;	Returns an array of structures comtaining defined
;	image processing id codes and descriptions.
;
; CATEGORY:
;	LASCO CONVERT
;
; CALLING SEQUENCE:
;	Result = READ_IP_DAT ()
;
; INPUTS:
;	None
;
; OUTPUTS:
;	Result = array of structures containing:
;		Result.ip_num    ;int: compression type as understood by OBE
;		Result.ip_char   ;string: 1 character compression code 
;		Result.ip_description  	;string: String describing compression step 
;
; CALLS:
;	GET_DB_STRUCT
;
; RESTRICTIONS:
;	The file cnvrt_ip.dat must exist in $NRL_LIB/lasco/convert
;
; MODIFICATION HISTORY:
;         Written,  SE Paswaters, NRL
;   Version 1  sep  13 Jun 1996
;
;       @(#)read_ip_dat.pro	1.5 12/11/97  LASCO IDL LIBRARY
;
;-

FUNCTION READ_IP_DAT

   a = GET_DB_STRUCT('lasco','img_ip_types')
   ;f = FILEPATH('cnvrt_ip.dat', ROOT_DIR='$NRL_LIB', SUBDIRECTORY='lasco/convert')
   f = FILEPATH('cnvrt_ip.dat', ROOT_DIR='$NRL_LIB', SUBDIRECTORY=['lasco','convert'])

   OPENR, lu, f, /GET_LUN
   str = ''
   first = 1
   WHILE NOT(EOF(lu)) DO BEGIN
      READF, lu, str
      len = STRLEN(str)
      id = FIX(STRMID(str, 0, 2))
      char = STRMID(str, 4, 1)
      type = STRTRIM(STRMID(str, 5, len-5), 2)
      a.(2) = id
      a.(3) = char
      a.(4) = type
      IF (first EQ 1) THEN BEGIN
         first = 0
         ip_arr = a
      ENDIF ELSE BEGIN
         ip_arr = [ip_arr, a]
      ENDELSE
   ENDWHILE

   CLOSE, lu
   FREE_LUN, lu

   RETURN, ip_arr

END
