;__________________________________________________________________________________________________________
;

FUNCTION SCHEDULE_CONVERT_UNITS, value, from, to
;** 0:bits, 1:bytes, 2:%buffer

   bufsize = 1069256D                      ;** size of circular buffer in words (A & B are the same)

   CASE (1) OF 
      ((from EQ 0) AND (to EQ 1)) : BEGIN	;** bits to bytes
            new = value / 8.0D
         END
      ((from EQ 1) AND (to EQ 0)) : BEGIN	;** bytes to bits
            new = value * 8.0D
         END
      ((from EQ 0) AND (to EQ 2)) : BEGIN	;** bits to % buf
            new = (value / 8.0D / 2.0D) / bufsize * 100D
         END
      ((from EQ 1) AND (to EQ 2)) : BEGIN	;** bytes to % buf
            new = (value / 2.0D) / bufsize * 100D
         END
      ((from EQ 2) AND (to EQ 0)) : BEGIN	;** % buf to bits
            new = (value / 100D * bufsize) * 2.0D * 8.0D
         END
      ((from EQ 2) AND (to EQ 1)) : BEGIN	;** % buf to bytes
            new = (value / 100D * bufsize) * 2.0D
         END
      ELSE : new = value			;** no change of units
   ENDCASE

   RETURN, new
END
