PRO SHIFT_IPT_EVENT, event

COMMON SHIFT_IPT_SHARE, return_value

  WIDGET_CONTROL, event.top, GET_UVALUE=shiftv   ; get structure from UVALUE

    CASE (event.id) OF

	shiftv.textd : BEGIN	;** exit program
	   WIDGET_CONTROL, shiftv.textd, GET_VALUE=val
           val = UTC2STR(STR2UTC(val), /ECS)
	   WIDGET_CONTROL, shiftv.textd, SET_VALUE=val
	END

	shiftv.cancel : BEGIN	;** cancel and exit program
           return_value = 0
	   WIDGET_CONTROL, /DESTROY, shiftv.base
	END

	shiftv.apply : BEGIN	;** return date to shift to exit program
	   WIDGET_CONTROL, shiftv.textd, GET_VALUE=val
           val = UTC2TAI(STR2UTC(val))
           return_value = val
	   WIDGET_CONTROL, /DESTROY, shiftv.base
	END

        ELSE : BEGIN
        END

   ENDCASE

END

;__________________________________________________________________________________________________________
;

FUNCTION SHIFT_IPT, CALLER=caller, first_dte

COMMON SHIFT_IPT_SHARE, return_value

    IF XRegistered("SHIFT_IPT") THEN RETURN, -1


    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    IF (KEYWORD_SET(caller)) THEN $
       base = WIDGET_BASE(/COLUMN, TITLE='SHIFT IPT', /FRAME, GROUP_LEADER=caller.id) $
    ELSE $
       base = WIDGET_BASE(/COLUMN, TITLE='SHIFT IPT', /FRAME)


    row = WIDGET_BASE(base, /ROW)
     tmp = WIDGET_LABEL(row, VALUE='Date of 1st Obs in IPT file: '+UTC2STR(TAI2UTC(first_dte), /ECS))
    row = WIDGET_BASE(base, /ROW)
     tmp = WIDGET_LABEL(row, VALUE='Shift to: ')
     GET_UTC, utc
     textd = WIDGET_TEXT(row, VALUE=UTC2STR(utc, /ECS), /EDITABLE, XSIZE=22)
    row = WIDGET_BASE(base, /ROW)
     apply = WIDGET_BUTTON(row, VALUE=" Apply ")
     cancel = WIDGET_BUTTON(row, VALUE=" Cancel ")

    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, base, /REALIZE

    shiftv = CREATE_STRUCT( 'base', base, 		$
                             'apply', apply, 		$
                             'cancel', cancel, 		$
                             'textd', textd)

   WIDGET_CONTROL, base, SET_UVALUE=shiftv

   XMANAGER, 'SHIFT_IPT', base, /MODAL

   RETURN, return_value

END
