;
; converts an array of strings of 'keyword = value' 
; to an array of structures of strings
;
FUNCTION STR_ARR2KEY_VAL, str_arr

   key_val_struct = {key_val_struct, key:'', val:''}

   len = N_ELEMENTS(str_arr)
   key_val_arr = REPLICATE(key_val_struct, len)

   j=0
   FOR i=0, len-1 DO BEGIN
      line = str_arr(i)
      pos = STRPOS(line, '=')
      IF (pos LE 0) THEN $
         PRINT, '%%STR_ARR2KEY_VAL: Illegal element of str_arr: no = in line:'+line $
      ELSE BEGIN
         key = STRUPCASE(STRTRIM(STRMID(line, 0, pos), 2))
         val = STRTRIM(STRMID(line, pos+1, STRLEN(line)-pos+1), 2)
         IF (key EQ '') THEN $
            PRINT, '%%STR_ARR2KEY_VAL: Illegal element of str_arr: no keyword in line:'+line $
         ELSE IF (val EQ '') THEN $
            PRINT, '%%STR_ARR2KEY_VAL: Illegal element of str_arr: no value in line:'+line $
         ELSE BEGIN
            key_val_arr(j).key = key
            key_val_arr(j).val = val
            j = j+1
         ENDELSE
      ENDELSE
   ENDFOR

   RETURN, key_val_arr(0:j-1)

END
