PRO TAKE_SEQ_BUILD_WORDS, seq_encv, word1, word2

   word1 = (seq_encv.lp+8) AND 'F'x
   IF (seq_encv.lp EQ 0) THEN word1 = word1 + ISHFT(((seq_encv.num_steps) AND 'F'x),4)
   word1 = word1 + ISHFT(((seq_encv.endt+2) AND '3'x),8)
   word1 = word1 + ISHFT(((seq_encv.iter) AND '3F'x),10)

   IF (seq_encv.lp EQ 0) THEN $
      word2 = seq_encv.reg AND '3'x $
   ELSE $
      word2 = seq_encv.tele AND '3'x
   word2 = word2 + ISHFT(((seq_encv.dpt+1) AND '3'x),2)
   word2 = word2 + ISHFT(((seq_encv.fw) AND '7'x),4)
   word2 = word2 + ISHFT(((seq_encv.pw) AND '7'x),7)
   word2 = word2 + ISHFT(((seq_encv.iptab) AND '3F'x),10)
END


PRO TAKE_SEQ_ENCODE_EVENT, event

COMMON OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, proc_tab_types, $
   ip_arr, plan_lp, lprow

 WIDGET_CONTROL, event.top, GET_UVALUE=seq_encv   ; get structure from UVALUE


    CASE (event.id) OF

	seq_encv.quit : BEGIN	;** exit program
	   WIDGET_CONTROL, /DESTROY, seq_encv.base
           GOTO, DONE
	END

        seq_encv.telepd : BEGIN
           seq_encv.tele = event.index
           WIDGET_CONTROL, seq_encv.fwpd, SET_VALUE=fw_types(*,seq_encv.tele)
           WIDGET_CONTROL, seq_encv.fwpd, SET_VALUE=seq_encv.fw
           WIDGET_CONTROL, seq_encv.pwpd, SET_VALUE=pw_types(*,seq_encv.tele)
           WIDGET_CONTROL, seq_encv.pwpd, SET_VALUE=seq_encv.pw
        END

        seq_encv.regpd : BEGIN
           lseq_encv.reg = event.index
        END
 
        seq_encv.ippd : BEGIN
           seq_encv.iptab = event.index
        END
 
        seq_encv.dptpd : BEGIN
           seq_encv.dpt = event.index
        END
 
        seq_encv.fwpd : BEGIN
           seq_encv.fw = event.index
        END
 
        seq_encv.pwpd : BEGIN
           seq_encv.pw = event.index
        END

        seq_encv.lppd : BEGIN
           seq_encv.lp = event.index
           IF (seq_encv.lp EQ 0) THEN sens = 1 ELSE sens = 0
           WIDGET_CONTROL, seq_encv.numpd, SENSITIVE=sens
           WIDGET_CONTROL, seq_encv.regpd, SENSITIVE=sens
        END

        seq_encv.numpd : BEGIN
           seq_encv.num_steps = event.index+1
        END

        seq_encv.endpd : BEGIN
           seq_encv.endt = event.index
        END

        seq_encv.itertxt : BEGIN
           WIDGET_CONTROL, seq_encv.itertxt, GET_VALUE=str
           seq_encv.iter = FIX(str(0))
           IF (seq_encv.iter LT 1) THEN seq_encv.iter = 1
           IF (seq_encv.iter GT 63) THEN seq_encv.iter = 63
           WIDGET_CONTROL, seq_encv.itertxt, SET_VALUE=STRTRIM(seq_encv.iter,2)
        END

        ELSE : BEGIN
        END

   ENDCASE

 WIDGET_CONTROL, event.top, SET_UVALUE=seq_encv

   ;Gather all data and modify words
   TAKE_SEQ_BUILD_WORDS, seq_encv, word1, word2
   WIDGET_CONTROL, seq_encv.word1, SET_VALUE='Word 1: '+STRING(word1, FORMAT='(i6)')
   WIDGET_CONTROL, seq_encv.word2, SET_VALUE='Word 2: '+STRING(word2, FORMAT='(i6)')

DONE:

END

;__________________________________________________________________________________________________________
;

PRO TAKE_SEQ_ENCODE

COMMON OS_INIT_SHARE, op_types, tele_types, table_types, fw_types, pw_types, exit_types, proc_tab_types, $
   ip_arr, plan_lp, lprow

OS_INIT

    ;********************************************************************
    ;** SET UP WIDGETS **************************************************

    lp = 1
    lp_type = ['Line Scan','Normal']
    end_type = ['Iteration']
    endt = 0
    tele = 0
    reg = 0
    reg_type = ['No Regions', 'Use Regions']
    dpt = 0
    fw = 0
    pw = 0
    iptab = 19
    num_steps = 1
    iter = 1



    title = 'Take Seq Encode'
    base = WIDGET_BASE(/COLUMN, TITLE=title, /FRAME)

    row = WIDGET_BASE(base, /ROW)
      lppd = CW_BSELECTOR2(row, lp_type, SET_VALUE=lp)
       num_types = ['1 WL Image         ', $
                     '2 WL Images        ', $
                     '3 WL Images        ', $
                     '4 WL Images        ', $
                     '5 WL Images        ', $
                     '6 WL Images        ', $
                     '7 WL Images        ', $
                     '8 WL Images        ', $
                     '9 WL Images        ', $
                     '10 WL Images       ']
      numpd = CW_BSELECTOR2(row, num_types, SET_VALUE=num_steps-1)

      endpd = CW_BSELECTOR2(row, end_type, SET_VALUE=endt)
      temp = WIDGET_LABEL(row, VALUE='Iter Cnt:')
      itertxt = WIDGET_TEXT(row, /EDITABLE, YSIZE=1, XSIZE=5, VALUE=STRTRIM(iter,2))

    row = WIDGET_BASE(base, /ROW)
      telepd= CW_BSELECTOR2(row, tele_types, SET_VALUE=tele)
      regpd = CW_BSELECTOR2(row, reg_type, SET_VALUE=reg)
      dptpd = CW_BSELECTOR2(row, table_types, SET_VALUE=dpt)
      fwpd = CW_BSELECTOR2(row, fw_types(*,tele), SET_VALUE=fw) 
      pwpd = CW_BSELECTOR2(row, pw_types(*,tele), SET_VALUE=pw)
      ippd = CW_BSELECTOR2(row, proc_tab_types, SET_VALUE=iptab)

    row = WIDGET_BASE(base, /ROW)
      word1 = WIDGET_LABEL(row, VALUE='Word 1:              ')
      word2 = WIDGET_LABEL(row, VALUE='               Word 2:      ')

     quit = WIDGET_BUTTON(base, VALUE=' Quit ')


    ;********************************************************************
    ;** REALIZE THE WIDGETS *********************************************

    WIDGET_CONTROL, base, /REALIZE
    WIDGET_CONTROL, numpd, SENSITIVE=0
    WIDGET_CONTROL, regpd, SENSITIVE=0

    seq_encv = CREATE_STRUCT( 'base', base,	 	$
                           'quit', quit, 		$
                           'lppd', lppd, 		$
                           'numpd', numpd, 		$
                           'endpd', endpd, 	$
                           'itertxt', itertxt, 		$
                           'telepd', telepd, 			$
                           'regpd', regpd, 			$
                           'dptpd', dptpd,		$
                           'fwpd', fwpd, 		$
                           'pwpd', pwpd, 	$
                           'ippd', ippd, 		$
                           'fw', fw, 		$
                           'pw', pw, 		$
                           'tele', tele, 		$
                           'dpt', dpt, 		$
                           'reg', reg, 		$
                           'lp', lp, 		$
                           'iptab', iptab, 		$
                           'endt', endt, 		$
                           'iter', iter, 		$
                           'num_steps', num_steps, 		$
                           'word1', word1, 	$
                           'word2', word2)

   WIDGET_CONTROL, base, SET_UVALUE=seq_encv

   XMANAGER, 'TAKE_SEQ_ENCODE', base

END
